/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.PrintStream;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.InternalSnapshotCommandStep;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.report.DiffToReport;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.snapshot.SnapshotListener;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.DatabaseObjectFactory;
import liquibase.util.StringUtil;

public class InternalDiffCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"internalDiff"};
    public static final CommandArgumentDefinition<Database> REFERENCE_DATABASE_ARG;
    public static final CommandArgumentDefinition<Database> TARGET_DATABASE_ARG;
    public static final CommandArgumentDefinition<Class[]> SNAPSHOT_TYPES_ARG;
    public static final CommandArgumentDefinition<SnapshotListener> SNAPSHOT_LISTENER_ARG;
    public static final CommandArgumentDefinition<SnapshotControl> REFERENCE_SNAPSHOT_CONTROL_ARG;
    public static final CommandArgumentDefinition<SnapshotControl> TARGET_SNAPSHOT_CONTROL_ARG;
    public static final CommandArgumentDefinition<ObjectChangeFilter> OBJECT_CHANGE_FILTER_ARG;
    public static final CommandArgumentDefinition<CompareControl> COMPARE_CONTROL_ARG;
    public static final CommandArgumentDefinition<Boolean> PRINT_RESULT;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    public static Class<? extends DatabaseObject>[] parseSnapshotTypes(String ... snapshotTypes) {
        if (snapshotTypes == null || snapshotTypes.length == 0 || snapshotTypes[0] == null) {
            return new Class[0];
        }
        Set<Class<? extends DatabaseObject>> types = DatabaseObjectFactory.getInstance().parseTypes(StringUtil.join(snapshotTypes, ","));
        Class[] returnTypes = new Class[types.size()];
        int i2 = 0;
        for (Class<? extends DatabaseObject> type : types) {
            returnTypes[i2++] = type;
        }
        return returnTypes;
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        InternalSnapshotCommandStep.logUnsupportedDatabase(commandScope.getArgumentValue(REFERENCE_DATABASE_ARG), this.getClass());
        DiffResult diffResult = this.createDiffResult(commandScope);
        resultsBuilder.addResult("diffResult", diffResult);
        Boolean printResult = commandScope.getArgumentValue(PRINT_RESULT);
        if (printResult == null || !printResult.booleanValue()) {
            return;
        }
        PrintStream printStream = new PrintStream(resultsBuilder.getOutputStream());
        new DiffToReport(diffResult, printStream).print();
        printStream.flush();
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    public DiffResult createDiffResult(CommandScope commandScope) throws DatabaseException, InvalidExampleException {
        DatabaseSnapshot referenceSnapshot = this.createReferenceSnapshot(commandScope);
        DatabaseSnapshot targetSnapshot = this.createTargetSnapshot(commandScope);
        CompareControl compareControl = commandScope.getArgumentValue(COMPARE_CONTROL_ARG);
        referenceSnapshot.setSchemaComparisons(compareControl.getSchemaComparisons());
        if (targetSnapshot != null) {
            targetSnapshot.setSchemaComparisons(compareControl.getSchemaComparisons());
        }
        return DiffGeneratorFactory.getInstance().compare(referenceSnapshot, targetSnapshot, compareControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseSnapshot createTargetSnapshot(CommandScope commandScope) throws DatabaseException, InvalidExampleException {
        CatalogAndSchema[] schemas;
        CompareControl compareControl = commandScope.getArgumentValue(COMPARE_CONTROL_ARG);
        Database targetDatabase = commandScope.getArgumentValue(TARGET_DATABASE_ARG);
        SnapshotControl snapshotControl = commandScope.getArgumentValue(TARGET_SNAPSHOT_CONTROL_ARG);
        Class[] snapshotTypes = commandScope.getArgumentValue(SNAPSHOT_TYPES_ARG);
        SnapshotListener snapshotListener = commandScope.getArgumentValue(SNAPSHOT_LISTENER_ARG);
        if (compareControl == null || compareControl.getSchemaComparisons() == null) {
            schemas = new CatalogAndSchema[]{targetDatabase.getDefaultSchema()};
        } else {
            schemas = new CatalogAndSchema[compareControl.getSchemaComparisons().length];
            int i2 = 0;
            for (CompareControl.SchemaComparison comparison : compareControl.getSchemaComparisons()) {
                CatalogAndSchema schema = targetDatabase.supportsSchemas() ? new CatalogAndSchema(targetDatabase.getDefaultCatalogName(), comparison.getComparisonSchema().getSchemaName()) : new CatalogAndSchema(comparison.getComparisonSchema().getSchemaName(), comparison.getComparisonSchema().getSchemaName());
                schemas[i2++] = schema;
            }
        }
        if (snapshotControl == null) {
            snapshotControl = new SnapshotControl(targetDatabase, snapshotTypes);
        }
        if (snapshotListener != null) {
            snapshotControl.setSnapshotListener(snapshotListener);
        }
        ObjectQuotingStrategy originalStrategy = targetDatabase.getObjectQuotingStrategy();
        try {
            targetDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            DatabaseSnapshot databaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(schemas, targetDatabase, snapshotControl);
            return databaseSnapshot;
        }
        finally {
            targetDatabase.setObjectQuotingStrategy(originalStrategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseSnapshot createReferenceSnapshot(CommandScope commandScope) throws DatabaseException, InvalidExampleException {
        CatalogAndSchema[] schemas;
        CompareControl compareControl = commandScope.getArgumentValue(COMPARE_CONTROL_ARG);
        Database targetDatabase = commandScope.getArgumentValue(TARGET_DATABASE_ARG);
        Database referenceDatabase = commandScope.getArgumentValue(REFERENCE_DATABASE_ARG);
        SnapshotControl snapshotControl = commandScope.getArgumentValue(REFERENCE_SNAPSHOT_CONTROL_ARG);
        Class[] snapshotTypes = commandScope.getArgumentValue(SNAPSHOT_TYPES_ARG);
        ObjectChangeFilter objectChangeFilter = commandScope.getArgumentValue(OBJECT_CHANGE_FILTER_ARG);
        SnapshotListener snapshotListener = commandScope.getArgumentValue(SNAPSHOT_LISTENER_ARG);
        if (compareControl == null || compareControl.getSchemaComparisons() == null) {
            schemas = new CatalogAndSchema[]{targetDatabase.getDefaultSchema()};
        } else {
            schemas = new CatalogAndSchema[compareControl.getSchemaComparisons().length];
            int i2 = 0;
            for (CompareControl.SchemaComparison comparison : compareControl.getSchemaComparisons()) {
                CatalogAndSchema schema = referenceDatabase.supportsSchemas() ? new CatalogAndSchema(referenceDatabase.getDefaultCatalogName(), comparison.getReferenceSchema().getSchemaName()) : new CatalogAndSchema(comparison.getReferenceSchema().getSchemaName(), comparison.getReferenceSchema().getSchemaName());
                schemas[i2++] = schema;
            }
        }
        if (snapshotControl == null) {
            snapshotControl = new SnapshotControl(referenceDatabase, objectChangeFilter, snapshotTypes);
        }
        if (snapshotListener != null) {
            snapshotControl.setSnapshotListener(snapshotListener);
        }
        ObjectQuotingStrategy originalStrategy = referenceDatabase.getObjectQuotingStrategy();
        try {
            referenceDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            DatabaseSnapshot databaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(schemas, referenceDatabase, snapshotControl);
            return databaseSnapshot;
        }
        finally {
            referenceDatabase.setObjectQuotingStrategy(originalStrategy);
        }
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{COMMAND_NAME});
        REFERENCE_DATABASE_ARG = builder.argument("referenceDatabase", Database.class).required().build();
        TARGET_DATABASE_ARG = builder.argument("targetDatabase", Database.class).required().build();
        SNAPSHOT_TYPES_ARG = builder.argument("snapshotTypes", Class[].class).required().build();
        SNAPSHOT_LISTENER_ARG = builder.argument("snapshotListener", SnapshotListener.class).build();
        REFERENCE_SNAPSHOT_CONTROL_ARG = builder.argument("referenceSnapshotControl", SnapshotControl.class).build();
        TARGET_SNAPSHOT_CONTROL_ARG = builder.argument("targetSnapshotControl", SnapshotControl.class).build();
        OBJECT_CHANGE_FILTER_ARG = builder.argument("objectChangeFilter", ObjectChangeFilter.class).build();
        COMPARE_CONTROL_ARG = builder.argument("compareControl", CompareControl.class).required().build();
        PRINT_RESULT = builder.argument("printResult", Boolean.class).defaultValue(true).build();
    }
}

