/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.WhenClause;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class CaseExpression
extends ASTNodeAccessImpl
implements Expression {
    private boolean usingBrackets = false;
    private Expression switchExpression;
    private List<WhenClause> whenClauses;
    private Expression elseExpression;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public Expression getSwitchExpression() {
        return this.switchExpression;
    }

    public void setSwitchExpression(Expression expression) {
        this.switchExpression = expression;
    }

    public Expression getElseExpression() {
        return this.elseExpression;
    }

    public void setElseExpression(Expression expression) {
        this.elseExpression = expression;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public void setWhenClauses(List<WhenClause> list) {
        this.whenClauses = list;
    }

    public String toString() {
        return (this.usingBrackets ? "(" : "") + "CASE " + (this.switchExpression != null ? this.switchExpression + " " : "") + PlainSelect.getStringList(this.whenClauses, false, false) + " " + (this.elseExpression != null ? "ELSE " + this.elseExpression + " " : "") + "END" + (this.usingBrackets ? ")" : "");
    }

    public CaseExpression withSwitchExpression(Expression expression) {
        this.setSwitchExpression(expression);
        return this;
    }

    public CaseExpression withWhenClauses(List<WhenClause> list) {
        this.setWhenClauses(list);
        return this;
    }

    public CaseExpression withElseExpression(Expression expression) {
        this.setElseExpression(expression);
        return this;
    }

    public CaseExpression addWhenClauses(WhenClause ... whenClauseArray) {
        List list = Optional.ofNullable(this.getWhenClauses()).orElseGet(ArrayList::new);
        Collections.addAll(list, whenClauseArray);
        return this.withWhenClauses(list);
    }

    public CaseExpression addWhenClauses(Collection<? extends WhenClause> collection) {
        List list = Optional.ofNullable(this.getWhenClauses()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withWhenClauses(list);
    }

    public <E extends Expression> E getSwitchExpression(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getSwitchExpression()));
    }

    public <E extends Expression> E getElseExpression(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getElseExpression()));
    }

    public boolean isUsingBrackets() {
        return this.usingBrackets;
    }

    public void setUsingBrackets(boolean bl2) {
        this.usingBrackets = bl2;
    }

    public CaseExpression withUsingBrackets(boolean bl2) {
        this.usingBrackets = bl2;
        return this;
    }
}

