/*
 * Decompiled with CFR 0.152.
 */
package kamon.metric;

import java.io.Serializable;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$Dimension$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.ModuleSerializationProxy;

public final class MeasurementUnit$
implements Serializable {
    public static final MeasurementUnit$ MODULE$ = new MeasurementUnit$();
    private static final Logger _logger = LoggerFactory.getLogger((String)"kamon.metric.MeasurementUnit");
    private static final MeasurementUnit none = new MeasurementUnit(MeasurementUnit$Dimension$.MODULE$.None(), new MeasurementUnit.Magnitude("none", 1.0));
    private static final MeasurementUnit percentage = new MeasurementUnit(MeasurementUnit$Dimension$.MODULE$.Percentage(), new MeasurementUnit.Magnitude("percentage", 1.0));
    private static final MeasurementUnit.TimeUnits time = new MeasurementUnit.TimeUnits(){
        private final MeasurementUnit seconds;
        private final MeasurementUnit milliseconds;
        private final MeasurementUnit microseconds;
        private final MeasurementUnit nanoseconds;

        public MeasurementUnit seconds() {
            return this.seconds;
        }

        public MeasurementUnit milliseconds() {
            return this.milliseconds;
        }

        public MeasurementUnit microseconds() {
            return this.microseconds;
        }

        public MeasurementUnit nanoseconds() {
            return this.nanoseconds;
        }
        {
            this.seconds = MeasurementUnit$.MODULE$.kamon$metric$MeasurementUnit$$timeUnit("seconds", 1.0);
            this.milliseconds = MeasurementUnit$.MODULE$.kamon$metric$MeasurementUnit$$timeUnit("milliseconds", 0.001);
            this.microseconds = MeasurementUnit$.MODULE$.kamon$metric$MeasurementUnit$$timeUnit("microseconds", 1.0E-6);
            this.nanoseconds = MeasurementUnit$.MODULE$.kamon$metric$MeasurementUnit$$timeUnit("nanoseconds", 1.0E-9);
        }
    };
    private static final MeasurementUnit.InformationUnits information = new MeasurementUnit.InformationUnits(){
        private final MeasurementUnit bytes;
        private final MeasurementUnit kilobytes;
        private final MeasurementUnit megabytes;
        private final MeasurementUnit gigabytes;

        public MeasurementUnit bytes() {
            return this.bytes;
        }

        public MeasurementUnit kilobytes() {
            return this.kilobytes;
        }

        public MeasurementUnit megabytes() {
            return this.megabytes;
        }

        public MeasurementUnit gigabytes() {
            return this.gigabytes;
        }
        {
            this.bytes = MeasurementUnit$.MODULE$.kamon$metric$MeasurementUnit$$informationUnit("byte", 1.0);
            this.kilobytes = MeasurementUnit$.MODULE$.kamon$metric$MeasurementUnit$$informationUnit("kilobytes", 1024.0);
            this.megabytes = MeasurementUnit$.MODULE$.kamon$metric$MeasurementUnit$$informationUnit("megabytes", 1048576.0);
            this.gigabytes = MeasurementUnit$.MODULE$.kamon$metric$MeasurementUnit$$informationUnit("gigabytes", 1.073741824E9);
        }
    };

    private Logger _logger() {
        return _logger;
    }

    public MeasurementUnit none() {
        return none;
    }

    public MeasurementUnit percentage() {
        return percentage;
    }

    public MeasurementUnit.TimeUnits time() {
        return time;
    }

    public MeasurementUnit.InformationUnits information() {
        return information;
    }

    public double convert(double value, MeasurementUnit from, MeasurementUnit to) {
        double d;
        MeasurementUnit.Dimension dimension = from.dimension();
        MeasurementUnit.Dimension dimension2 = to.dimension();
        if (dimension == null ? dimension2 != null : !((Object)dimension).equals(dimension2)) {
            this._logger().warn(new StringBuilder(65).append("Can't convert values from the [").append(from.dimension().name()).append("] dimension into the [").append(to.dimension().name()).append("] dimension.").toString());
            d = value;
        } else {
            MeasurementUnit measurementUnit = from;
            MeasurementUnit measurementUnit2 = to;
            d = !(measurementUnit != null ? !((Object)measurementUnit).equals(measurementUnit2) : measurementUnit2 != null) ? value : from.magnitude().scaleFactor() / to.magnitude().scaleFactor() * value;
        }
        return d;
    }

    public MeasurementUnit kamon$metric$MeasurementUnit$$timeUnit(String name, double scaleFactor) {
        return new MeasurementUnit(MeasurementUnit$Dimension$.MODULE$.Time(), new MeasurementUnit.Magnitude(name, scaleFactor));
    }

    public MeasurementUnit kamon$metric$MeasurementUnit$$informationUnit(String name, double scaleFactor) {
        return new MeasurementUnit(MeasurementUnit$Dimension$.MODULE$.Information(), new MeasurementUnit.Magnitude(name, scaleFactor));
    }

    public MeasurementUnit apply(MeasurementUnit.Dimension dimension, MeasurementUnit.Magnitude magnitude) {
        return new MeasurementUnit(dimension, magnitude);
    }

    public Option<Tuple2<MeasurementUnit.Dimension, MeasurementUnit.Magnitude>> unapply(MeasurementUnit x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.dimension(), (Object)x$0.magnitude()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MeasurementUnit$.class);
    }

    private MeasurementUnit$() {
    }
}

