/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.intercept;

import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class AuthorizationFilter
extends GenericFilterBean {
    private final AuthorizationManager<HttpServletRequest> authorizationManager;
    private boolean observeOncePerRequest = true;
    private boolean filterErrorDispatch = false;
    private boolean filterAsyncDispatch = false;

    public AuthorizationFilter(AuthorizationManager<HttpServletRequest> authorizationManager) {
        Assert.notNull(authorizationManager, (String)"authorizationManager cannot be null");
        this.authorizationManager = authorizationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.observeOncePerRequest && this.isApplied(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.skipDispatch(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
        request.setAttribute(alreadyFilteredAttributeName, (Object)Boolean.TRUE);
        try {
            this.authorizationManager.verify(this::getAuthentication, (Object)request);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            request.removeAttribute(alreadyFilteredAttributeName);
        }
    }

    private boolean skipDispatch(HttpServletRequest request) {
        if (DispatcherType.ERROR.equals((Object)request.getDispatcherType()) && !this.filterErrorDispatch) {
            return true;
        }
        return DispatcherType.ASYNC.equals((Object)request.getDispatcherType()) && !this.filterAsyncDispatch;
    }

    private boolean isApplied(HttpServletRequest request) {
        return request.getAttribute(this.getAlreadyFilteredAttributeName()) != null;
    }

    private String getAlreadyFilteredAttributeName() {
        String name = this.getFilterName();
        if (name == null) {
            name = ((Object)((Object)this)).getClass().getName();
        }
        return name + ".APPLIED";
    }

    private Authentication getAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new AuthenticationCredentialsNotFoundException("An Authentication object was not found in the SecurityContext");
        }
        return authentication;
    }

    public AuthorizationManager<HttpServletRequest> getAuthorizationManager() {
        return this.authorizationManager;
    }

    public boolean isObserveOncePerRequest() {
        return this.observeOncePerRequest;
    }

    public void setObserveOncePerRequest(boolean observeOncePerRequest) {
        this.observeOncePerRequest = observeOncePerRequest;
    }

    public void setFilterErrorDispatch(boolean filterErrorDispatch) {
        this.filterErrorDispatch = filterErrorDispatch;
    }

    public void setFilterAsyncDispatch(boolean filterAsyncDispatch) {
        this.filterAsyncDispatch = filterAsyncDispatch;
    }
}

