/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.remote.artery.CacheStatistics;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00055cA\u0002\r\u001a\u0003\u0003ir\u0004\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003*\u0011!a\u0003A!A!\u0002\u0013I\u0003\u0002C\u0017\u0001\u0005\u0007\u0005\u000b1\u0002\u0018\t\u0011}\u0002!1!Q\u0001\f\u0001CQ!\u0012\u0001\u0005\u0002\u0019CaA\u0014\u0001!\u0002\u0013I\u0003BB(\u0001A\u0003&\u0011\u0006\u0003\u0004Q\u0001\u0001\u0006I!\u0015\u0005\u0007)\u0002\u0001\u000b\u0011B+\t\rY\u0003\u0001\u0015!\u0003X\u0011\u0019A\u0006\u0001)A\u0005/\")\u0011\f\u0001C\u00035\")\u0001\r\u0001C\u0003C\")Q\r\u0001C\u0003M\")\u0001\u000e\u0001C\u0005S\")a\u000f\u0001C\u0005o\")a\u000f\u0001C\tu\"1q\u0010\u0001C\u0005\u0003\u0003Aq!!\u0007\u0001\r#\tY\u0002C\u0004\u0002 \u00011\t\"!\t\t\u000f\u0005\u0015\u0002A\"\u0005\u0002(!9\u0011\u0011\u0007\u0001\u0007\u0012\u0005M\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0002\u0010\u0019J,(i\\;oI\u0016$7)Y2iK*\u0011!dG\u0001\u0007CJ$XM]=\u000b\u0005qi\u0012A\u0002:f[>$XMC\u0001\u001f\u0003\u0011\t7n[1\u0016\u0007\u00012$i\u0005\u0002\u0001CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\f\u0001bY1qC\u000eLG/_\u0002\u0001!\t\u0011#&\u0003\u0002,G\t\u0019\u0011J\u001c;\u0002#\u00154\u0018n\u0019;BO\u0016$\u0006N]3tQ>dG-\u0001\u0006fm&$WM\\2fIE\u00022a\f\u001a5\u001b\u0005\u0001$BA\u0019$\u0003\u001d\u0011XM\u001a7fGRL!a\r\u0019\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"!\u000e\u001c\r\u0001\u0011)q\u0007\u0001b\u0001q\t\t1*\u0005\u0002:yA\u0011!EO\u0005\u0003w\r\u0012qAT8uQ&tw\r\u0005\u0002#{%\u0011ah\t\u0002\u0004\u0003:L\u0018AC3wS\u0012,gnY3%eA\u0019qFM!\u0011\u0005U\u0012E!B\"\u0001\u0005\u0004!%!\u0001,\u0012\u0005e\n\u0013A\u0002\u001fj]&$h\bF\u0002H\u00196#2\u0001\u0013&L!\u0011I\u0005\u0001N!\u000e\u0003eAQ!L\u0003A\u00049BQaP\u0003A\u0004\u0001CQaJ\u0003A\u0002%BQ\u0001L\u0003A\u0002%\nA!T1tW\u0006)Q\r]8dQ\u0006!1.Z=t!\r\u0011#\u000bN\u0005\u0003'\u000e\u0012Q!\u0011:sCf\faA^1mk\u0016\u001c\bc\u0001\u0012S\u0003\u00061\u0001.Y:iKN\u00042A\t**\u0003\u0019)\u0007o\\2ig\u0006\u0019q-\u001a;\u0015\u0005ms\u0006c\u0001\u0012]\u0003&\u0011Ql\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b}c\u0001\u0019\u0001\u001b\u0002\u0003-\fQa\u001d;biN,\u0012A\u0019\t\u0003\u0013\u000eL!\u0001Z\r\u0003\u001f\r\u000b7\r[3Ti\u0006$\u0018n\u001d;jGN\fAbZ3u\u001fJ\u001cu.\u001c9vi\u0016$\"!Q4\t\u000b}s\u0001\u0019\u0001\u001b\u0002\u0011I,Wn\u001c<f\u0003R$\"A[7\u0011\u0005\tZ\u0017B\u00017$\u0005\u0011)f.\u001b;\t\u000b9|\u0001\u0019A\u0015\u0002\u0011A|7/\u001b;j_:D#a\u00049\u0011\u0005E$X\"\u0001:\u000b\u0005M\u001c\u0013AC1o]>$\u0018\r^5p]&\u0011QO\u001d\u0002\bi\u0006LGN]3d\u0003=\u0001(o\u001c2f\t&\u001cH/\u00198dK>3GCA\u0015y\u0011\u0015I\b\u00031\u0001*\u0003\u0011\u0019Hn\u001c;\u0015\u0007%ZX\u0010C\u0003}#\u0001\u0007\u0011&A\u0005jI\u0016\fGn\u00157pi\")a0\u0005a\u0001S\u0005Q\u0011m\u0019;vC2\u001cFn\u001c;\u0002\t5|g/\u001a\u000b\u000eU\u0006\r\u0011QAA\u0004\u0003\u0017\ty!a\u0005\t\u000b9\u0014\u0002\u0019A\u0015\t\u000b}\u0013\u0002\u0019\u0001\u001b\t\r\u0005%!\u00031\u0001*\u0003\u0005A\u0007BBA\u0007%\u0001\u0007\u0011)A\u0003wC2,X\r\u0003\u0004\u0002\u0012I\u0001\r!K\u0001\nK2,W.\u00129pG\"Da!!\u0006\u0013\u0001\u0004I\u0013!\u00049s_\n,G)[:uC:\u001cW\r\u000b\u0002\u0013a\u000691m\\7qkR,GcA!\u0002\u001e!)ql\u0005a\u0001i\u0005!\u0001.Y:i)\rI\u00131\u0005\u0005\u0006?R\u0001\r\u0001N\u0001\u000fSN\\U-_\"bG\",\u0017M\u00197f)\u0011\tI#a\f\u0011\u0007\t\nY#C\u0002\u0002.\r\u0012qAQ8pY\u0016\fg\u000eC\u0003`+\u0001\u0007A'A\u0006jg\u000e\u000b7\r[3bE2,G\u0003BA\u0015\u0003kAa!a\u000e\u0017\u0001\u0004\t\u0015!\u0001<\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0010\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005!A.\u00198h\u0015\t\t9%\u0001\u0003kCZ\f\u0017\u0002BA&\u0003\u0003\u0012aa\u0015;sS:<\u0007")
public abstract class LruBoundedCache<K, V> {
    private final int capacity;
    private final int evictAgeThreshold;
    private final int Mask;
    private int epoch;
    private final Object keys;
    private final V[] values;
    private final int[] hashes;
    private final int[] epochs;

    public final Option<V> get(K k) {
        int h = this.hash(k);
        return this.find$1(h & this.Mask, 0, h, k);
    }

    public final CacheStatistics stats() {
        int sum = 0;
        int count = 0;
        int max = 0;
        for (int i = 0; i < this.hashes.length; ++i) {
            if (this.values[i] == null) continue;
            int dist = this.probeDistanceOf(i);
            sum += dist;
            ++count;
            max = package$.MODULE$.max(dist, max);
        }
        return new CacheStatistics(count, max, (double)sum / (double)count);
    }

    public final V getOrCompute(K k) {
        Object object;
        if (!this.isKeyCacheable(k)) {
            object = this.compute(k);
        } else {
            int h = this.hash(k);
            ++this.epoch;
            object = this.findOrCalculate$1(h & this.Mask, 0, k, h);
        }
        return object;
    }

    private void removeAt(int position) {
        while (true) {
            int next;
            if (this.values[next = position + 1 & this.Mask] == null || this.probeDistanceOf(next) == 0) break;
            ScalaRunTime$.MODULE$.array_update(this.keys, position, ScalaRunTime$.MODULE$.array_apply(this.keys, next));
            this.values[position] = this.values[next];
            this.hashes[position] = this.hashes[next];
            this.epochs[position] = this.epochs[next];
            position = next;
        }
        this.values[position] = null;
    }

    private int probeDistanceOf(int slot) {
        return this.probeDistanceOf(this.hashes[slot] & this.Mask, slot);
    }

    public int probeDistanceOf(int idealSlot, int actualSlot) {
        return actualSlot - idealSlot + this.capacity & this.Mask;
    }

    private void move(int position, K k, int h, V value, int elemEpoch, int probeDistance) {
        while (true) {
            if (this.values[position] == null) break;
            int otherEpoch = this.epochs[position];
            if (this.epoch - otherEpoch >= this.evictAgeThreshold) {
                this.removeAt(position);
                int n = h & this.Mask;
                probeDistance = 0;
                position = n;
                continue;
            }
            int otherProbeDistance = this.probeDistanceOf(position);
            int otherEpoch2 = this.epochs[position];
            if (probeDistance > otherProbeDistance) {
                Object otherKey = ScalaRunTime$.MODULE$.array_apply(this.keys, position);
                V otherValue = this.values[position];
                int otherHash = this.hashes[position];
                ScalaRunTime$.MODULE$.array_update(this.keys, position, k);
                this.values[position] = value;
                this.hashes[position] = h;
                this.epochs[position] = elemEpoch;
                probeDistance = otherProbeDistance + 1;
                elemEpoch = otherEpoch2;
                value = otherValue;
                h = otherHash;
                k = otherKey;
                position = position + 1 & this.Mask;
                continue;
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
        ScalaRunTime$.MODULE$.array_update(this.keys, position, k);
        this.values[position] = value;
        this.hashes[position] = h;
        this.epochs[position] = elemEpoch;
    }

    public abstract V compute(K var1);

    public abstract int hash(K var1);

    public abstract boolean isKeyCacheable(K var1);

    public abstract boolean isCacheable(V var1);

    public String toString() {
        return new StringBuilder(0).append("LruBoundedCache(").append(new StringBuilder(11).append(" values = ").append(Predef$.MODULE$.wrapRefArray((Object[])this.values).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(11).append(" hashes = ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(this.hashes), (Function1)(JFunction1.mcII.sp & Serializable)x$1 -> x$1 & $this.Mask, (ClassTag)ClassTag$.MODULE$.Int())).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(11).append(" epochs = ").append(Predef$.MODULE$.wrapIntArray(this.epochs).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(14).append(" distances = ").append(ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.intArrayOps(this.hashes)).map((Function1)(JFunction1.mcII.sp & Serializable)slot -> this.probeDistanceOf(slot)).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(2).append(" ").append(this.epoch).append(")").toString()).toString();
    }

    private final Option find$1(int position, int probeDistance, int h$1, Object k$1) {
        None$ none$;
        while (true) {
            int otherProbeDistance = this.probeDistanceOf(position);
            if (this.values[position] == null) {
                none$ = None$.MODULE$;
                break;
            }
            if (probeDistance > otherProbeDistance) {
                none$ = None$.MODULE$;
                break;
            }
            if (this.hashes[position] == h$1 && BoxesRunTime.equals((Object)k$1, (Object)ScalaRunTime$.MODULE$.array_apply(this.keys, position))) {
                none$ = new Some(this.values[position]);
                break;
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
        return none$;
    }

    private final Object findOrCalculate$1(int position, int probeDistance, Object k$2, int h$2) {
        V v;
        while (true) {
            if (this.values[position] == null) {
                V value = this.compute(k$2);
                if (this.isCacheable(value)) {
                    ScalaRunTime$.MODULE$.array_update(this.keys, position, k$2);
                    this.values[position] = value;
                    this.hashes[position] = h$2;
                    this.epochs[position] = this.epoch;
                }
                v = value;
                break;
            }
            int otherProbeDistance = this.probeDistanceOf(position);
            if (probeDistance > otherProbeDistance) {
                V value = this.compute(k$2);
                if (this.isCacheable(value)) {
                    this.move(position, k$2, h$2, value, this.epoch, probeDistance);
                }
                v = value;
                break;
            }
            if (this.hashes[position] == h$2 && BoxesRunTime.equals((Object)k$2, (Object)ScalaRunTime$.MODULE$.array_apply(this.keys, position))) {
                this.epochs[position] = this.epoch;
                v = this.values[position];
                break;
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
        return v;
    }

    public LruBoundedCache(int capacity, int evictAgeThreshold, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        this.capacity = capacity;
        this.evictAgeThreshold = evictAgeThreshold;
        Predef$.MODULE$.require(capacity > 0, (Function0 & Serializable)() -> "Capacity must be larger than zero");
        Predef$.MODULE$.require((capacity & capacity - 1) == 0, (Function0 & Serializable)() -> "Capacity must be power of two");
        Predef$.MODULE$.require(evictAgeThreshold <= capacity, (Function0 & Serializable)() -> "Age threshold must be less than capacity.");
        this.Mask = capacity - 1;
        this.epoch = 0x7FFFFFFE;
        this.keys = Array$.MODULE$.ofDim(capacity, evidence$1);
        this.values = (Object[])Array$.MODULE$.ofDim(capacity, evidence$2);
        this.hashes = new int[capacity];
        this.epochs = (int[])Array$.MODULE$.fill(capacity, (Function0)(JFunction0.mcI.sp & Serializable)() -> $this.epoch - $this.evictAgeThreshold, (ClassTag)ClassTag$.MODULE$.Int());
    }
}

