/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.internal.util.MapUtils;
import reactor.util.Logger;
import reactor.util.Loggers;

final class AddressResolverGroupMetrics<T extends SocketAddress>
extends AddressResolverGroup<T> {
    private static final Logger log = Loggers.getLogger(AddressResolverGroupMetrics.class);
    static final ConcurrentMap<Integer, AddressResolverGroupMetrics<?>> cache = new ConcurrentHashMap();
    final AddressResolverGroup<T> resolverGroup;
    final ChannelMetricsRecorder recorder;

    static AddressResolverGroupMetrics<?> getOrCreate(AddressResolverGroup<?> resolverGroup, ChannelMetricsRecorder recorder) {
        return MapUtils.computeIfAbsent(cache, Objects.hash(resolverGroup, recorder), key -> new AddressResolverGroupMetrics(resolverGroup, recorder));
    }

    private AddressResolverGroupMetrics(AddressResolverGroup<T> resolverGroup, ChannelMetricsRecorder recorder) {
        this.resolverGroup = resolverGroup;
        this.recorder = recorder;
    }

    protected AddressResolver<T> newResolver(EventExecutor executor) {
        final AddressResolver resolver = this.resolverGroup.getResolver(executor);
        return new AddressResolver<T>(){

            public boolean isSupported(SocketAddress address) {
                return resolver.isSupported(address);
            }

            public boolean isResolved(SocketAddress address) {
                return resolver.isResolved(address);
            }

            public Future<T> resolve(SocketAddress address) {
                return this.resolveInternal(address, () -> resolver.resolve(address));
            }

            public Future<T> resolve(SocketAddress address, Promise<T> promise) {
                return this.resolveInternal(address, () -> resolver.resolve(address, promise));
            }

            public Future<List<T>> resolveAll(SocketAddress address) {
                return this.resolveAllInternal(address, () -> resolver.resolveAll(address));
            }

            public Future<List<T>> resolveAll(SocketAddress address, Promise<List<T>> promise) {
                return this.resolveAllInternal(address, () -> resolver.resolveAll(address, promise));
            }

            public void close() {
                resolver.close();
            }

            Future<T> resolveInternal(SocketAddress address, Supplier<Future<T>> resolver2) {
                long resolveTimeStart = System.nanoTime();
                return resolver2.get().addListener(future -> this.record(resolveTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR", address));
            }

            Future<List<T>> resolveAllInternal(SocketAddress address, Supplier<Future<List<T>>> resolver2) {
                long resolveTimeStart = System.nanoTime();
                return resolver2.get().addListener(future -> this.record(resolveTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR", address));
            }

            void record(long resolveTimeStart, String status, SocketAddress remoteAddress) {
                try {
                    AddressResolverGroupMetrics.this.recorder.recordResolveAddressTime(remoteAddress, Duration.ofNanos(System.nanoTime() - resolveTimeStart), status);
                }
                catch (RuntimeException e) {
                    log.warn("Exception caught while recording metrics.", (Throwable)e);
                }
            }
        };
    }
}

