/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.core.common.security.permission.DeployitPermissions;
import ai.digital.deploy.engine.tasker.service.ActiveTaskPathStatusService;
import ai.digital.deploy.engine.tasker.service.ActiveTaskStepLogService;
import ai.digital.deploy.sql.http.enricher.PaginationService;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.AbstractTaskResource;
import com.xebialabs.deployit.core.rest.api.StepBlockStateView;
import com.xebialabs.deployit.core.rest.api.support.TaskPermissionFilter;
import com.xebialabs.deployit.engine.api.TaskBlockService;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.TaskPathStatus;
import com.xebialabs.deployit.engine.api.dto.TaskStepLog;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.api.task.TaskBlockServiceDefaults;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.TaskReader;
import com.xebialabs.deployit.task.archive.sql.CachingTaskReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option;

@Service
public class TaskBlockResource
extends AbstractTaskResource
implements TaskBlockService,
TaskBlockServiceDefaults {
    private static final Function<ArchivedTask, TaskWithBlock> castToTaskWithBlock = input -> input;
    @Context
    private HttpResponse response;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ActiveTaskPathStatusService activeTaskPathStatusService;
    @Autowired
    private ActiveTaskStepLogService activeTaskStepLogService;

    public List<TaskWithBlock> getMyCurrentTasks(FetchMode fetchMode) {
        String principal = Permissions.getAuthenticatedUserName();
        return this.getAllTasks(fetchMode).filter(input -> input.getOwner().equals(principal)).collect(Collectors.toList());
    }

    public List<TaskWithBlock> getAllCurrentTasks(FetchMode fetchMode) {
        Stream<TaskWithBlock> tasks = this.getAllTasks(fetchMode);
        if (this.hasPermission(PlatformPermissions.ADMIN)) {
            logger.debug("getAllCurrentTasks returning full list as ADMIN");
            return tasks.collect(Collectors.toList());
        }
        return tasks.filter(new TaskPermissionFilter()).collect(Collectors.toList());
    }

    private Stream<TaskWithBlock> getAllTasks(FetchMode fetchMode) {
        return ((TaskExecutionEngine)this.engine.get()).getAllIncompleteTasks(fetchMode).stream();
    }

    private boolean filterBySatelliteId(TaskWithBlock task, String satelliteId) {
        String idsAsString = (String)task.getMetadata().get("satellite_ids");
        if (idsAsString != null) {
            HashSet<String> satelliteIds = new HashSet<String>(Arrays.asList(idsAsString.split(",")));
            return satelliteIds.contains(satelliteId);
        }
        return false;
    }

    public List<TaskWithBlock> getMySatelliteTasks(String satelliteId, FetchMode fetchMode) {
        String principal = Permissions.getAuthenticatedUserName();
        return ((TaskExecutionEngine)this.engine.get()).getAllIncompleteTasks(fetchMode).stream().filter(input -> this.filterBySatelliteId((TaskWithBlock)input, satelliteId)).filter(input -> input.getOwner().equals(principal)).collect(Collectors.toList());
    }

    public List<TaskWithBlock> getCurrentSatelliteTasks(String satelliteId, FetchMode fetchMode) {
        List tasks = ((TaskExecutionEngine)this.engine.get()).getAllIncompleteTasks(fetchMode).stream().filter(input -> this.filterBySatelliteId((TaskWithBlock)input, satelliteId)).collect(Collectors.toList());
        if (this.hasPermission(PlatformPermissions.ADMIN) || this.roleService.isReadOnlyAdmin()) {
            logger.debug("getAllCurrentTasks returning full list as ADMIN");
            return new ArrayList<TaskWithBlock>(tasks);
        }
        return tasks.stream().filter(new TaskPermissionFilter()).collect(Collectors.toList());
    }

    public TaskWithBlock getTaskByFetchMode(String taskId, FetchMode fetchMode) {
        if (Objects.equals(fetchMode, FetchMode.FULL)) {
            return (TaskWithBlock)this.viewAbleTask(this.pendingOrLiveOrArchivedTask(taskId, false));
        }
        try {
            return (TaskWithBlock)this.viewAbleTask((SerializableTask)((TaskExecutionEngine)this.engine.get()).retrieveTaskSummary(taskId));
        }
        catch (TaskNotFoundException l) {
            TaskReader taskReader = (TaskReader)this.taskArchiveQueue.getTaskDetails(taskId).map(task -> new CachingTaskReader((Reader)new StringReader((String)task))).getOrElse(() -> this.taskArchive.getTask(taskId));
            return (TaskWithBlock)this.viewAbleTask((SerializableTask)taskReader.withoutSteps());
        }
    }

    public TaskWithBlock getTask(String taskId) {
        return this.getTaskByFetchMode(taskId, FetchMode.FULL);
    }

    public TaskWithBlock getTaskSummary(String taskId) {
        return this.getTaskByFetchMode(taskId, FetchMode.SUMMARY);
    }

    public BlockState getBlock(String taskId, String blockId) {
        TaskWithBlock taskWithBlock = (TaskWithBlock)this.viewAbleTask(this.pendingOrLiveOrArchivedTask(taskId, false));
        Option block = ((Block)taskWithBlock.getBlock()).getBlock(BlockPath.apply((String)blockId).tail());
        return (BlockState)block.map(b -> this.stepLogRetriever.retrieveLogs(taskId, (BlockState)b)).getOrElse(null);
    }

    public StepBlockState getSteps(String taskId, String blockId) {
        TaskWithBlock task = (TaskWithBlock)this.viewAbleTask(this.pendingOrLiveOrArchivedTask(taskId, true));
        Option blockOption = ((Block)task.getBlock()).getBlock(BlockPath.apply((String)blockId).tail());
        Block block = (Block)blockOption.getOrElse(null);
        if (block instanceof StepBlockState) {
            return new StepBlockStateView((StepBlockState)block);
        }
        throw new DeployitException("Block is a composite block so it has no steps");
    }

    public TaskWithBlock skip(String taskId, List<String> stepPaths) {
        return this.skip(taskId, stepPaths, true);
    }

    public TaskWithBlock unskip(String taskId, List<String> stepPaths) {
        return this.skip(taskId, stepPaths, false);
    }

    public StepBlockState addPause(String taskId, String stepPath) {
        this.pause(taskId, stepPath);
        Task task = ((TaskExecutionEngine)this.engine.get()).retrieveTask(taskId);
        Option block = task.getBlock(BlockPath.apply((String)stepPath).init());
        return new StepBlockStateView((StepBlockState)block.getOrElse(null));
    }

    public TaskWithBlock assign(String taskId, String owner) {
        return this.doAssign(taskId, owner);
    }

    public TaskWithBlock takeover(String taskId, String owner) {
        return this.doTakeover(taskId, owner);
    }

    public Stream<TaskWithBlock> query(LocalDate begin, LocalDate end, Paging paging) {
        Paging limited = this.paginationService.getLimitedPaging(paging);
        ArchivedTaskSearchParameters searchParameters = this.toSearchParameters(begin, end, true);
        searchParameters.showPage(limited.page(), limited.resultsPerPage());
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response), () -> this.taskArchive.countTotalResults(searchParameters));
        return this.search(searchParameters, false).map(castToTaskWithBlock);
    }

    public Stream<TaskWithBlock> export(LocalDate begin, LocalDate end, Paging paging) {
        Paging limited = this.paginationService.getLimitedPaging(paging);
        ArchivedTaskSearchParameters searchParameters = this.toSearchParameters(begin, end, true);
        searchParameters.showPage(limited.page(), limited.resultsPerPage());
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response), () -> this.taskArchive.countTotalResults(searchParameters));
        return this.search(searchParameters, true).map(castToTaskWithBlock);
    }

    protected TaskWithBlock skip(String taskId, List<String> stepPaths, boolean skip) {
        SerializableTask task = this.getSerializableTask(taskId);
        List paths = stepPaths.stream().map(BlockPath::apply).collect(Collectors.toList());
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        this.checkPermission(DeployitPermissions.TASK_SKIPSTEP(), task);
        if (skip) {
            ((TaskExecutionEngine)this.engine.get()).skipStepPaths(taskId, paths);
        } else {
            ((TaskExecutionEngine)this.engine.get()).unskipStepPaths(taskId, paths);
        }
        return ((TaskExecutionEngine)this.engine.get()).retrieveTask(taskId);
    }

    protected void pause(String taskId, String stepPath) {
        this.checkForMissingPermission(this.isNotCalledByOwner(taskId) && !this.hasPermission(PlatformPermissions.ADMIN), "Only owner or ADMIN can add pause to the task.");
        ((TaskExecutionEngine)this.engine.get()).addPauseStep(taskId, BlockPath.apply((String)stepPath));
    }

    public StepState getStep(String taskId, String stepPath, DateTime ifModifiedSince) {
        TaskWithBlock taskWithBlock = (TaskWithBlock)this.viewAbleTask(this.pendingOrLiveOrArchivedTask(taskId, true));
        StepState step = ((Block)taskWithBlock.getBlock()).getStep(BlockPath.apply((String)stepPath).tail());
        step = this.addLogs(taskId, BlockPath.apply((String)stepPath), step);
        if (this.hasBeenModifiedSince(step, ifModifiedSince)) {
            return step;
        }
        throw new AbstractTaskResource.NotModifiedException();
    }

    @Override
    public void setPaginationService(PaginationService paginationService) {
        this.paginationService = paginationService;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public TaskPathStatus getStatus(String taskId, String path) {
        return this.activeTaskPathStatusService.findOne(taskId, path);
    }

    public TaskStepLog getStepLog(String taskId, String stepPath) {
        return this.activeTaskStepLogService.findOne(taskId, stepPath);
    }
}

