/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.output.FormattedChangesetValidated;
import com.datical.liquibase.ext.checks.output.FormattedCheckExecuted;
import com.datical.liquibase.ext.checks.output.FormattedCheckParameter;
import com.datical.liquibase.ext.checks.output.FormattedCheckSkipped;
import com.datical.liquibase.ext.checks.output.FormattedCheckUnrecognized;
import com.datical.liquibase.ext.checks.output.FormattedChecksIssue;
import com.datical.liquibase.ext.checks.output.FormattedChecksOutputSerializer;
import com.datical.liquibase.ext.checks.output.FormattedChecksResultModel;
import com.datical.liquibase.ext.checks.output.FormattedUnlicensedChangeset;
import com.datical.liquibase.ext.checks.output.FormattedUnparseableChangeset;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.LiquibaseChangeSetCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.QualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.QualityChecksRulesEngine$RuleCombination;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.CommandExecutionException;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;

public class ChecksRunCommandStep
extends AbstractChecksCommandStep {
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    public static final String[] COMMAND_NAME = new String[]{"checks", "run"};
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SCOPE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_OUTPUT_FORMAT_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_INTEGRATION_ARG;
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope();
        String string = ((CommandScope)object).getConfiguredValue(CHECKS_INTEGRATION_ARG).getValue();
        object = ((CommandScope)object).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        if (string.equalsIgnoreCase("maven") && StringUtil.isEmpty((String)object)) {
            object = new InMemoryChecksFileAccessor();
            Scope.child(Collections.singletonMap("fileAccessor", object), () -> this.doRun(commandResultsBuilder));
            return;
        }
        this.doRun(commandResultsBuilder);
    }

    private void doRun(CommandResultsBuilder commandResultsBuilder) {
        Object object;
        Object object2;
        List<AbstractConfigurableRule> list;
        Object object3 = commandResultsBuilder.getCommandScope();
        Iterator iterator = ((CommandScope)object3).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksRunCommandStep.checkFileArgExistence((String)((Object)iterator), "checks settings", false);
        Object object4 = ((CommandScope)object3).getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
        object4 = new CheckSettingsConfigHelper((String)((Object)iterator), (String)object4);
        String string = ((CommandScope)object3).getConfiguredValue(CHANGELOG_FILE_ARG).getValue();
        ChecksRunCommandStep.checkFileArgExistence(string, "changelog", true);
        this.sendMessageToUi("Executing Quality Checks against " + string + System.lineSeparator());
        Object object5 = Scope.getCurrentScope().getResourceAccessor();
        Object object6 = ChangeLogParserFactory.getInstance().getParser(string, (ResourceAccessor)object5);
        try {
            object5 = object6.parse(string, new ChangeLogParameters(), (ResourceAccessor)object5);
        }
        catch (ChangeLogParseException changeLogParseException) {
            String string2 = String.format("%nThe changelog file %s cannot be found or is not a valid changelog: %s%nCorrect this issue and try to run checks again.", string, changeLogParseException.getMessage());
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe(string2);
            Scope.getCurrentScope().getUI().sendMessage(string2);
            return;
        }
        object6 = ((CommandScope)object3).getConfiguredValue(CHECK_NAME_ARG).getValue();
        List<AbstractLiquibaseRule> list2 = ChecksRunCommandStep.listAllRules();
        try {
            object4 = ((CheckSettingsConfigHelper)object4).read(list2);
        }
        catch (Exception exception) {
            iterator = String.format("%nUnable to read checks settings file '%s': %s%nCorrect this issue and try to run checks again.", iterator, exception.getMessage());
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)((Object)iterator));
            Scope.getCurrentScope().getUI().sendMessage((String)((Object)iterator));
            return;
        }
        if (StringUtil.isEmpty((String)object6)) {
            list = ((CheckSettingsConfig)object4).getRules();
        } else {
            iterator = Arrays.stream(((String)object6).split(",")).map(String::trim).collect(Collectors.toList());
            list = new ArrayList<AbstractConfigurableRule>(iterator.size());
            ArrayList<String> arrayList = new ArrayList<String>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = ((CheckSettingsConfig)object4).getRuleByShortName((String)object2);
                if (object == null) {
                    arrayList.add((String)object2);
                    continue;
                }
                list.add((AbstractConfigurableRule)object);
            }
            if (!arrayList.isEmpty()) {
                throw new CommandExecutionException("One or more specified checks not found: '" + StringUtil.join(arrayList, "', '") + "'. Please check your arguments and try again.");
            }
        }
        int n2 = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService().daysTilExpiration();
        boolean bl2 = LicenseServiceUtils.isProLicenseValid();
        if (n2 > 0) {
            if (bl2) {
                if (StringUtil.isEmpty((String)object6)) {
                    this.sendMessageToUi("Executing all checks because a valid Liquibase Pro license was found!" + System.lineSeparator());
                } else {
                    object2 = Arrays.stream(((String)object6).split(",")).map(String::trim).collect(Collectors.toList());
                    this.sendMessageToUi("Executing specified checks: '" + StringUtil.join(object2.stream().limit(5L).collect(Collectors.toList()), "', '") + "'");
                }
            } else {
                this.sendMessageToUi("No valid Liquibase Pro license key detected!" + System.lineSeparator() + "Unlock unlimited checks with a free Pro license Key from https://liquibase.com/protrial" + System.lineSeparator() + "Execution limited to 5 checks." + System.lineSeparator());
            }
        } else {
            object2 = LocalDate.now().plusDays(n2);
            this.sendMessageToUi("Pro license expired on " + ((LocalDate)object2).format(DateTimeFormatter.ofPattern("yyyy-MMM-dd")) + "." + System.lineSeparator() + "Unlock unlimited checks with a free Pro license Key from https://liquibase.com/protrial" + System.lineSeparator() + "Execution limited to 5 checks." + System.lineSeparator());
        }
        object2 = new LinkedHashSet<String>();
        object = new LinkedHashSet();
        LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> linkedHashMap = this.runChecks(list2, ((DatabaseChangeLog)object5).getChangeSets(), list);
        linkedHashMap.forEach((arg_0, arg_1) -> ChecksRunCommandStep.lambda$doRun$4(object2, (Set)object, arg_0, arg_1));
        if (object2.isEmpty()) {
            object3 = "\nWarning:  No checks were executed\nChangesets Validated:  None\nChecks run against each changeset:  None\n\n";
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object3);
            Scope.getCurrentScope().getUI().sendMessage((String)object3);
            return;
        }
        object5 = ((CommandScope)object3).getArgumentValue(CHECKS_OUTPUT_FORMAT_ARG);
        if (this.isJsonOutput((String)object5)) {
            object6 = new StringBuilder();
            object3 = ((CommandScope)object3).getConfiguredValue(CHECKS_INTEGRATION_ARG).getValue();
            object3 = this.createJsonOutput(linkedHashMap, string, (String)object3, (CheckSettingsConfig)object4, (StringBuilder)object6);
            commandResultsBuilder.getOutputStream().write(((StringBuilder)object6).toString().getBytes(StandardCharsets.UTF_8));
        } else {
            object3 = this.outputChecksResults(commandResultsBuilder, (Set<String>)object2, (Set<String>)object, linkedHashMap);
        }
        if (object4 != null && !this.isJsonOutput((String)object5)) {
            this.sendMessage(commandResultsBuilder, ((CheckSettingsConfig)object4).getUnrecognizedRulesWarningMessage());
        }
        commandResultsBuilder.getOutputStream().flush();
        int n3 = ((SeverityEnum)((Object)object3)).getExitValue();
        if (n3 != 0) {
            commandResultsBuilder.addResult("statusCode", (Object)n3);
            throw commandResultsBuilder.commandFailed("Checks run command exited with an error code of ".concat(String.valueOf(n3)), n3);
        }
        if (object4 != null) {
            ((CheckSettingsConfig)object4).outputWarningMessage();
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    private boolean isJsonOutput(String string) {
        return string.equalsIgnoreCase(ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.JSON.name());
    }

    private static boolean validateOutputFormat(String string) {
        ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT[] checksRunCommandStep$CHECKS_RUN_OUTPUT_FORMATArray = ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.values();
        int n2 = checksRunCommandStep$CHECKS_RUN_OUTPUT_FORMATArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!checksRunCommandStep$CHECKS_RUN_OUTPUT_FORMATArray[i2].toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private SeverityEnum createJsonOutput(LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> object222, String object32, String object42, CheckSettingsConfig checkSettingsConfig, StringBuilder stringBuilder) {
        void var5_20;
        Iterator<LiquibaseRuleResult> iterator;
        void var4_19;
        Iterator iterator2;
        Object object2;
        void var2_4;
        void var3_12;
        SeverityEnum severityEnum = SeverityEnum.INFO;
        if (((HashMap)object222).isEmpty()) {
            return severityEnum;
        }
        FormattedChecksResultModel formattedChecksResultModel = new FormattedChecksResultModel();
        new FormattedChecksResultModel().username = System.getProperty("user.name");
        formattedChecksResultModel.productVersion = LiquibaseUtil.getBuildVersionInfo();
        formattedChecksResultModel.hasProLicense = LicenseServiceUtils.isProLicenseValid();
        formattedChecksResultModel.integration = var3_12;
        formattedChecksResultModel.changelogFilePath = var2_4;
        formattedChecksResultModel.executionDate = Instant.now().toString();
        formattedChecksResultModel.changesetsValidatedCount = ((HashMap)object222).size();
        ((LinkedHashMap)object222).forEach((changeSet, object) -> {
            object = new FormattedChangesetValidated();
            new FormattedChangesetValidated().author = changeSet.getAuthor();
            ((FormattedChangesetValidated)object).id = changeSet.getId();
            ((FormattedChangesetValidated)object).filepath = changeSet.getFilePath();
            formattedChecksResultModel.changesetsValidated.add((FormattedChangesetValidated)object);
        });
        Map<ChangeSet, LiquibaseChangeSetCheckResult> map = this.getUnparseableChangeSetResultsWithoutMessage((LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult>)object222);
        formattedChecksResultModel.unparseableChangesetsCount = map.size();
        for (Map.Entry<ChangeSet, LiquibaseChangeSetCheckResult> entry : map.entrySet()) {
            ChangeSet changeSet2 = entry.getKey();
            object2 = entry.getValue();
            iterator2 = new FormattedUnparseableChangeset();
            new FormattedUnparseableChangeset().changesetId = changeSet2.getId();
            for (String string : ((LiquibaseChangeSetCheckResult)object2).getSkippedBecauseOfExceptionRuleNames()) {
                FormattedCheckSkipped formattedCheckSkipped = new FormattedCheckSkipped();
                new FormattedCheckSkipped().checkShortName = string != null ? string : "";
                iterator = var4_19.getDynamicRuleByShortName(string);
                formattedCheckSkipped.checkName = iterator != null ? ((DynamicRule)((Object)iterator)).getName() : "";
                ((FormattedUnparseableChangeset)((Object)iterator2)).skipped.add(formattedCheckSkipped);
            }
            formattedChecksResultModel.unparseableChangesets.add((FormattedUnparseableChangeset)((Object)iterator2));
        }
        Map<ChangeSet, LiquibaseChangeSetCheckResult> map2 = this.getUnlicensedChangeSetResults((LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult>)object222);
        formattedChecksResultModel.unlicensedChangesetsCount = map2.size();
        for (Map.Entry<ChangeSet, LiquibaseChangeSetCheckResult> entry : map2.entrySet()) {
            object2 = entry.getKey();
            iterator2 = entry.getValue();
            FormattedUnlicensedChangeset formattedUnlicensedChangeset = new FormattedUnlicensedChangeset();
            new FormattedUnlicensedChangeset().changesetId = ((ChangeSet)object2).getId();
            for (QualityChecksRulesEngine$RuleCombination qualityChecksRulesEngine$RuleCombination : ((LiquibaseChangeSetCheckResult)((Object)iterator2)).getSkippedBecauseOfLicenceRules()) {
                iterator = new FormattedCheckSkipped();
                String string = qualityChecksRulesEngine$RuleCombination.rule.getName();
                Object object3 = null;
                if (qualityChecksRulesEngine$RuleCombination.rule instanceof DynamicRule) {
                    object3 = ((DynamicRule)qualityChecksRulesEngine$RuleCombination.configurableRule).getShortName();
                }
                ((FormattedCheckSkipped)((Object)iterator)).checkName = string;
                ((FormattedCheckSkipped)((Object)iterator)).checkShortName = object3;
                formattedUnlicensedChangeset.skipped.add((FormattedCheckSkipped)((Object)iterator));
            }
            formattedChecksResultModel.unlicensedChangesets.add(formattedUnlicensedChangeset);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        ((LinkedHashMap)object222).forEach((object, object22) -> {
            for (LiquibaseRuleResult liquibaseRuleResult : ((LiquibaseChangeSetCheckResult)object22).getRuleResults()) {
                if (linkedHashSet.contains(liquibaseRuleResult.getRule().getName())) continue;
                linkedHashSet.add(liquibaseRuleResult.getRule().getName());
                FormattedCheckExecuted formattedCheckExecuted = new FormattedCheckExecuted();
                new FormattedCheckExecuted().checkName = liquibaseRuleResult.getRule().getName();
                formattedCheckExecuted.checkShortName = liquibaseRuleResult.getRule().getShortName();
                formattedCheckExecuted.description = liquibaseRuleResult.getRule().getDescription();
                formattedCheckExecuted.severity = Integer.toString(liquibaseRuleResult.getRule().getSeverity().getExitValue());
                formattedCheckExecuted.enabled = true;
                if (liquibaseRuleResult.getDynamicRule() != null) {
                    DynamicRule dynamicRule = liquibaseRuleResult.getDynamicRule();
                    formattedCheckExecuted.enabled = dynamicRule.isEnabled();
                    FormattedCheckParameter formattedCheckParameter = new FormattedCheckParameter();
                    dynamicRule.getParameters().forEach(dynamicRuleParameter -> this.setParamValueInModel(formattedCheckParameter, (DynamicRuleParameter)dynamicRuleParameter));
                    formattedCheckExecuted.customizations.add(formattedCheckParameter);
                }
                formattedChecksResultModel.executedChecks.add(formattedCheckExecuted);
            }
        });
        int n2 = linkedHashSet.size();
        int n3 = 0;
        for (Map.Entry entry : ((LinkedHashMap)object222).entrySet()) {
            ChangeSet changeSet3 = (ChangeSet)entry.getKey();
            for (LiquibaseRuleResult liquibaseRuleResult : ((LiquibaseChangeSetCheckResult)entry.getValue()).getRuleResults()) {
                if (liquibaseRuleResult.hasRuleSucceeded()) continue;
                for (RuleIteration ruleIteration : liquibaseRuleResult.getExecutions()) {
                    void var13_55;
                    void var11_39;
                    ++n3;
                    FormattedChecksIssue formattedChecksIssue = new FormattedChecksIssue();
                    new FormattedChecksIssue().changesetAuthor = changeSet3.getAuthor();
                    formattedChecksIssue.changesetId = changeSet3.getId();
                    formattedChecksIssue.changesetFilePath = changeSet3.getFilePath();
                    formattedChecksIssue.checkName = liquibaseRuleResult.getRule().getName();
                    formattedChecksIssue.checkSeverity = liquibaseRuleResult.getRule().getSeverity().toString();
                    formattedChecksIssue.checkReturnCode = liquibaseRuleResult.getRule().getSeverity().getExitValue();
                    DynamicRule dynamicRule = liquibaseRuleResult.getDynamicRule();
                    if (dynamicRule != null) {
                        String string = dynamicRule.getShortName();
                        SeverityEnum severityEnum2 = dynamicRule.getSeverity();
                    } else {
                        String string = liquibaseRuleResult.getRule().getShortName();
                        SeverityEnum severityEnum3 = liquibaseRuleResult.getRule().getSeverity();
                    }
                    if (var11_39.getValue() > severityEnum.getValue()) {
                        severityEnum = var11_39;
                    }
                    formattedChecksIssue.checkShortName = var13_55;
                    formattedChecksIssue.checkMessage = StringUtil.join(ruleIteration.getMessages(), ",");
                    formattedChecksResultModel.issues.add(formattedChecksIssue);
                }
            }
        }
        for (AbstractConfigurableRule abstractConfigurableRule : var4_19.accessUnrecognizedRules()) {
            FormattedCheckUnrecognized formattedCheckUnrecognized = new FormattedCheckUnrecognized();
            if (abstractConfigurableRule.isConfigurable()) {
                formattedCheckUnrecognized.checkShortName = ((DynamicRule)abstractConfigurableRule).getShortName();
            }
            formattedCheckUnrecognized.checkId = abstractConfigurableRule.getId().toString();
            formattedChecksResultModel.unrecognizedChecks.add(formattedCheckUnrecognized);
        }
        formattedChecksResultModel.issueCount = n3;
        formattedChecksResultModel.executedChecksCount = n2;
        formattedChecksResultModel.returnCode = severityEnum.getExitValue();
        String string = new FormattedChecksOutputSerializer().serialize(formattedChecksResultModel, true).replaceAll("!!com.datical.liquibase.[^\\s]+ (.*)", "$1");
        var5_20.append(string);
        return severityEnum;
    }

    private void setParamValueInModel(FormattedCheckParameter formattedCheckParameter, DynamicRuleParameter dynamicRuleParameter) {
        Object object = dynamicRuleParameter.getParameter();
        object = Arrays.stream(FormattedCheckParameter.class.getFields()).filter(arg_0 -> ChecksRunCommandStep.lambda$setParamValueInModel$8((String)object, arg_0)).findFirst().orElse(null);
        if (object != null) {
            try {
                ((Field)object).set(formattedCheckParameter, dynamicRuleParameter.getValue());
                return;
            }
            catch (Exception exception) {
                Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).warning("Unable to set parameter value for " + ((Field)object).getName());
            }
        }
    }

    private SeverityEnum outputChecksResults(CommandResultsBuilder commandResultsBuilder, Set<String> set, Set<String> set2, LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> linkedHashMap) {
        Object object;
        Object object4 = SeverityEnum.INFO;
        if (linkedHashMap.isEmpty()) {
            return object4;
        }
        LicenseService licenseService = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService();
        int n2 = licenseService.daysTilExpiration();
        boolean bl2 = false;
        for (Map.Entry<ChangeSet, LiquibaseChangeSetCheckResult> entry : linkedHashMap.entrySet()) {
            object = entry.getKey();
            for (Object object2 : entry.getValue().getRuleResults()) {
                if (((LiquibaseRuleResult)object2).hasRuleSucceeded()) continue;
                if (!bl2) {
                    this.sendMessage(commandResultsBuilder, "Checks completed validation of the changelog and found the following issues:" + System.lineSeparator() + System.lineSeparator());
                    bl2 = true;
                }
                for (RuleIteration ruleIteration : ((LiquibaseRuleResult)object2).getExecutions()) {
                    String string2;
                    Object object3 = ((LiquibaseRuleResult)object2).getDynamicRule();
                    if (object3 != null) {
                        string2 = ((DynamicRule)object3).getShortName();
                        object3 = ((AbstractConfigurableRule)object3).getSeverity();
                    } else {
                        string2 = ((LiquibaseRuleResult)object2).getRule().getShortName();
                        object3 = ((LiquibaseRuleResult)object2).getRule().getSeverity();
                    }
                    if (((SeverityEnum)((Object)object3)).getValue() > object4.getValue()) {
                        object4 = object3;
                    }
                    if (StringUtil.isNotEmpty(string2)) {
                        string2 = " (" + string2 + ")";
                    }
                    String string3 = StringUtil.wrap(StringUtil.join(ruleIteration.getMessages(), ";"), 60, 20);
                    string2 = ((LiquibaseRuleResult)object2).getRule().getName() + string2 + System.lineSeparator();
                    String string4 = "Changeset ID:       " + ((ChangeSet)object).getId() + System.lineSeparator() + "Changeset Filepath: " + ((ChangeSet)object).getFilePath() + System.lineSeparator() + "Check Name:         " + string2 + "Check Severity:     " + object3 + " (Return code: " + ((SeverityEnum)((Object)object3)).getExitValue() + ")" + System.lineSeparator() + "Message:            " + string3;
                    this.sendMessage(commandResultsBuilder, string4 + System.lineSeparator() + System.lineSeparator());
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder(System.lineSeparator() + "Changesets Validated:");
        stringBuilder.append(System.lineSeparator());
        Iterator<Map.Entry<ChangeSet, LiquibaseChangeSetCheckResult>> iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2;
            object2 = iterator.next().getKey();
            stringBuilder.append("  ID: ");
            stringBuilder.append(((ChangeSet)object2).getId());
            stringBuilder.append("; Author: ");
            stringBuilder.append(((ChangeSet)object2).getAuthor());
            stringBuilder.append("; File path: ");
            stringBuilder.append(((ChangeSet)object2).getFilePath());
            stringBuilder.append(System.lineSeparator());
        }
        this.sendMessage(commandResultsBuilder, stringBuilder + System.lineSeparator());
        StringBuilder stringBuilder2 = new StringBuilder("Checks run against each changeset:");
        stringBuilder2.append(System.lineSeparator());
        set.forEach(string -> stringBuilder2.append((String)string).append(System.lineSeparator()));
        this.sendMessage(commandResultsBuilder, stringBuilder2 + System.lineSeparator());
        this.printChangeSetsWithSkippedChecks(commandResultsBuilder, linkedHashMap);
        if (!set2.isEmpty()) {
            object = new StringBuilder("Checks Skipped Due to Community Limit of 5 Checks:");
            ((StringBuilder)object).append(System.lineSeparator());
            set2.forEach(arg_0 -> ChecksRunCommandStep.lambda$outputChecksResults$10((StringBuilder)object, arg_0));
            this.sendMessage(commandResultsBuilder, object + System.lineSeparator());
        }
        if (n2 < 0) {
            this.sendMessageToUi(licenseService.getLicenseInfo());
        }
        return object4;
    }

    private void printChangeSetsWithSkippedChecks(CommandResultsBuilder commandResultsBuilder, LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> linkedHashMap) {
        StringBuilder stringBuilder = new StringBuilder("Changeset SQL not parsed by the following checks (please review them directly):").append(System.lineSeparator());
        if (this.getUnparseableChangeSetResults(linkedHashMap, stringBuilder).size() > 0) {
            stringBuilder.append(System.lineSeparator());
            this.sendMessage(commandResultsBuilder, stringBuilder.toString());
        }
    }

    private Map<ChangeSet, LiquibaseChangeSetCheckResult> getUnparseableChangeSetResults(LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> linkedHashMap, StringBuilder stringBuilder) {
        return linkedHashMap.entrySet().stream().filter(entry -> !((LiquibaseChangeSetCheckResult)entry.getValue()).getSkippedBecauseOfExceptionRuleNames().isEmpty()).peek(entry -> this.appendChangeSetWithSkippedChecks(stringBuilder, (Map.Entry<ChangeSet, LiquibaseChangeSetCheckResult>)entry)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (liquibaseChangeSetCheckResult, liquibaseChangeSetCheckResult2) -> liquibaseChangeSetCheckResult2, LinkedHashMap::new));
    }

    private Map<ChangeSet, LiquibaseChangeSetCheckResult> getUnparseableChangeSetResultsWithoutMessage(LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> linkedHashMap) {
        return linkedHashMap.entrySet().stream().filter(entry -> !((LiquibaseChangeSetCheckResult)entry.getValue()).getSkippedBecauseOfExceptionRuleNames().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (liquibaseChangeSetCheckResult, liquibaseChangeSetCheckResult2) -> liquibaseChangeSetCheckResult2, LinkedHashMap::new));
    }

    private Map<ChangeSet, LiquibaseChangeSetCheckResult> getUnlicensedChangeSetResults(LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> linkedHashMap) {
        return linkedHashMap.entrySet().stream().filter(entry -> !((LiquibaseChangeSetCheckResult)entry.getValue()).getSkippedBecauseOfLicenceRules().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (liquibaseChangeSetCheckResult, liquibaseChangeSetCheckResult2) -> liquibaseChangeSetCheckResult2, LinkedHashMap::new));
    }

    private void appendChangeSetWithSkippedChecks(StringBuilder stringBuilder, Map.Entry<ChangeSet, LiquibaseChangeSetCheckResult> object) {
        ChangeSet changeSet = object.getKey();
        stringBuilder.append("  ID: ");
        stringBuilder.append(changeSet.getId());
        stringBuilder.append("; Author: ");
        stringBuilder.append(changeSet.getAuthor());
        stringBuilder.append("; File path: ");
        stringBuilder.append(changeSet.getFilePath());
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("    Skipped by: ");
        object = String.join((CharSequence)", ", object.getValue().getSkippedBecauseOfExceptionRuleNames());
        stringBuilder.append((String)object);
        stringBuilder.append(System.lineSeparator());
    }

    private void sendMessageToUi(String string) {
        Scope.getCurrentScope().getUI().sendMessage(string);
    }

    private void sendMessage(CommandResultsBuilder commandResultsBuilder, String string) {
        commandResultsBuilder.getOutputStream().write(string.getBytes());
    }

    private static boolean validChecksScope(String string) {
        return "changelog".equalsIgnoreCase(string);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Check the changelog for issues");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> runChecks(List<AbstractLiquibaseRule> list, List<ChangeSet> object, List<AbstractConfigurableRule> list2) {
        if (list2 != null) {
            LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult> linkedHashMap = new LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                ChangeSet changeSet = (ChangeSet)object.next();
                linkedHashMap.put(changeSet, this.runCheck(list, changeSet, list2));
            }
            return linkedHashMap;
        }
        return new LinkedHashMap<ChangeSet, LiquibaseChangeSetCheckResult>();
    }

    private LiquibaseChangeSetCheckResult runCheck(List<AbstractLiquibaseRule> iterable, ChangeSet object, List<AbstractConfigurableRule> list) {
        Facts facts = new Facts();
        facts.put(FactEnum.CHANGESET.toString(), object);
        iterable = new Rules(iterable.toArray());
        object = new QualityChecksRulesEngine(list);
        ((QualityChecksRulesEngine)object).fire((Rules)iterable, facts);
        iterable = ((QualityChecksRulesEngine)object).getExecutedRules().stream().map(ChecksRunCommandStep::getRuleNames).collect(Collectors.toList());
        list = new ArrayList<QualityChecksRulesEngine$RuleCombination>(((QualityChecksRulesEngine)object).getSkippedRules());
        return new LiquibaseChangeSetCheckResult(((QualityChecksRulesEngine)object).getResults(), ((QualityChecksRulesEngine)object).getSkippedBecauseOfExceptionRuleNames(), (List<String>)iterable, (List<QualityChecksRulesEngine$RuleCombination>)list);
    }

    private static String getRuleNames(QualityChecksRulesEngine$RuleCombination qualityChecksRulesEngine$RuleCombination) {
        StringBuilder stringBuilder = new StringBuilder("  ").append(qualityChecksRulesEngine$RuleCombination.rule.getName());
        if (qualityChecksRulesEngine$RuleCombination.configurableRule instanceof DynamicRule && ((DynamicRule)qualityChecksRulesEngine$RuleCombination.configurableRule).isCopy()) {
            stringBuilder.append(" (Short Name: ").append(((DynamicRule)qualityChecksRulesEngine$RuleCombination.configurableRule).getShortName()).append(")");
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ void lambda$outputChecksResults$10(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(System.lineSeparator());
    }

    private static /* synthetic */ boolean lambda$setParamValueInModel$8(String string, Field field) {
        return field.getName().equalsIgnoreCase(string.replaceAll("_", ""));
    }

    private static /* synthetic */ void lambda$doRun$4(Set set, Set set2, ChangeSet changeSet, LiquibaseChangeSetCheckResult liquibaseChangeSetCheckResult) {
        set.addAll(liquibaseChangeSetCheckResult.getExecutedRuleNames());
        set2.addAll(liquibaseChangeSetCheckResult.getSkippedBecauseOfLicenceRules().stream().map(ChecksRunCommandStep::getRuleNames).collect(Collectors.toList()));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHANGELOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).required().description("Relative or fully qualified path to a Liquibase changelog file").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_SCOPE_ARG = commandBuilder.argument("checksScope", String.class).defaultValue("changelog").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!ChecksRunCommandStep.validChecksScope((String)(object = (String)object))) {
                object = "\nWARNING:  Check scope value '" + (String)object + "' is not valid.  Valid check scope values include: changelog";
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).description("The Liquibase component to run checks against").build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
        CHECKS_OUTPUT_FORMAT_ARG = commandBuilder.argument("format", String.class).defaultValue(ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.TXT.name()).description("Option to create JSON output").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!ChecksRunCommandStep.validateOutputFormat((String)(object = String.valueOf(object)))) {
                object = "\nWARNING:  The format value '" + (String)object + "' is not valid.  Valid values include: 'json' or 'txt'";
                throw new IllegalArgumentException((String)object);
            }
            if (((String)object).equalsIgnoreCase("json")) {
                if (!LicenseServiceUtils.isProLicenseValid()) {
                    object = "checks run --format=".concat(String.valueOf(object));
                    object = String.format(coreBundle.getString("no.pro.license.found"), object);
                    throw new IllegalArgumentException((String)object);
                }
                return ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.JSON.name();
            }
            return ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.TXT.name();
        }).build();
        CHECKS_INTEGRATION_ARG = commandBuilder.argument("checksIntegration", String.class).hidden().defaultValue("cli").description("Name of the integration that is executing checks run").build();
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).description("Comma-separated list of one or more enabled checks to run. If not specified, all enabled checks will run. Example: --check-name=shortname1,shortname2,shortname3").build();
    }
}

