/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.openidconnect;

import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Clock;
import com.google.api.client.util.Preconditions;
import java.util.Collection;
import java.util.Collections;

@Beta
public class IdTokenVerifier {
    public static final long DEFAULT_TIME_SKEW_SECONDS = 300L;
    private final Clock clock;
    private final long acceptableTimeSkewSeconds;
    private final Collection<String> issuers;
    private final Collection<String> audience;

    public IdTokenVerifier() {
        this(new Builder());
    }

    protected IdTokenVerifier(Builder builder) {
        this.clock = builder.clock;
        this.acceptableTimeSkewSeconds = builder.acceptableTimeSkewSeconds;
        this.issuers = builder.issuers == null ? null : Collections.unmodifiableCollection(builder.issuers);
        this.audience = builder.audience == null ? null : Collections.unmodifiableCollection(builder.audience);
    }

    public final Clock getClock() {
        return this.clock;
    }

    public final long getAcceptableTimeSkewSeconds() {
        return this.acceptableTimeSkewSeconds;
    }

    public final String getIssuer() {
        if (this.issuers == null) {
            return null;
        }
        return this.issuers.iterator().next();
    }

    public final Collection<String> getIssuers() {
        return this.issuers;
    }

    public final Collection<String> getAudience() {
        return this.audience;
    }

    public boolean verify(IdToken idToken) {
        return !(this.issuers != null && !idToken.verifyIssuer(this.issuers) || this.audience != null && !idToken.verifyAudience(this.audience) || !idToken.verifyTime(this.clock.currentTimeMillis(), this.acceptableTimeSkewSeconds));
    }

    @Beta
    public static class Builder {
        Clock clock = Clock.SYSTEM;
        long acceptableTimeSkewSeconds = 300L;
        Collection<String> issuers;
        Collection<String> audience;

        public IdTokenVerifier build() {
            return new IdTokenVerifier(this);
        }

        public final Clock getClock() {
            return this.clock;
        }

        public Builder setClock(Clock clock) {
            this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
            return this;
        }

        public final String getIssuer() {
            if (this.issuers == null) {
                return null;
            }
            return this.issuers.iterator().next();
        }

        public Builder setIssuer(String issuer) {
            if (issuer == null) {
                return this.setIssuers(null);
            }
            return this.setIssuers(Collections.singleton(issuer));
        }

        public final Collection<String> getIssuers() {
            return this.issuers;
        }

        public Builder setIssuers(Collection<String> issuers) {
            Preconditions.checkArgument((issuers == null || !issuers.isEmpty() ? 1 : 0) != 0, (Object)"Issuers must not be empty");
            this.issuers = issuers;
            return this;
        }

        public final Collection<String> getAudience() {
            return this.audience;
        }

        public Builder setAudience(Collection<String> audience) {
            this.audience = audience;
            return this;
        }

        public final long getAcceptableTimeSkewSeconds() {
            return this.acceptableTimeSkewSeconds;
        }

        public Builder setAcceptableTimeSkewSeconds(long acceptableTimeSkewSeconds) {
            Preconditions.checkArgument((acceptableTimeSkewSeconds >= 0L ? 1 : 0) != 0);
            this.acceptableTimeSkewSeconds = acceptableTimeSkewSeconds;
            return this;
        }
    }
}

