/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.http;

import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.http.SSLConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class StandardHttpRequestor
extends HttpRequestor {
    private final Proxy proxy;
    public static final int DefaultConnectTimeoutMillis = 35000;
    public static final int DefaultReadTimeoutMillis = 35000;
    public static final StandardHttpRequestor Instance = new StandardHttpRequestor();

    public StandardHttpRequestor() {
        this(Proxy.NO_PROXY);
    }

    public StandardHttpRequestor(Proxy proxy) {
        this.proxy = proxy;
    }

    private static HttpRequestor.Response toResponse(HttpsURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        InputStream bodyStream = responseCode >= 400 ? conn.getErrorStream() : conn.getInputStream();
        return new HttpRequestor.Response(conn.getResponseCode(), bodyStream, conn.getHeaderFields());
    }

    @Override
    public HttpRequestor.Response doGet(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpsURLConnection conn = this.prepRequest(url, headers);
        conn.setRequestMethod("GET");
        conn.connect();
        return StandardHttpRequestor.toResponse(conn);
    }

    @Override
    public Uploader startPost(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpsURLConnection conn = this.prepRequest(url, headers);
        conn.setRequestMethod("POST");
        return new Uploader(conn);
    }

    @Override
    public Uploader startPut(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpsURLConnection conn = this.prepRequest(url, headers);
        conn.setRequestMethod("PUT");
        return new Uploader(conn);
    }

    protected void configureConnection(HttpsURLConnection conn) throws IOException {
    }

    private HttpsURLConnection prepRequest(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        URL urlObject = new URL(url);
        HttpsURLConnection conn = (HttpsURLConnection)urlObject.openConnection(this.proxy);
        SSLConfig.apply(conn);
        conn.setConnectTimeout(35000);
        conn.setReadTimeout(35000);
        conn.setUseCaches(false);
        conn.setAllowUserInteraction(false);
        this.configureConnection(conn);
        for (HttpRequestor.Header header : headers) {
            conn.addRequestProperty(header.key, header.value);
        }
        return conn;
    }

    private static class Uploader
    extends HttpRequestor.Uploader {
        private HttpsURLConnection conn;

        public Uploader(HttpsURLConnection conn) throws IOException {
            super(Uploader.getOutputStream(conn));
            conn.connect();
            this.conn = conn;
        }

        private static OutputStream getOutputStream(HttpsURLConnection conn) throws IOException {
            conn.setDoOutput(true);
            return conn.getOutputStream();
        }

        @Override
        public void abort() {
            HttpsURLConnection conn = this.conn;
            if (conn == null) {
                throw new IllegalStateException("Can't abort().  Uploader already closed.");
            }
            conn.disconnect();
        }

        @Override
        public void close() {
            HttpsURLConnection conn = this.conn;
            if (conn == null) {
                return;
            }
            conn.disconnect();
        }

        @Override
        public HttpRequestor.Response finish() throws IOException {
            HttpsURLConnection conn = this.conn;
            if (conn == null) {
                throw new IllegalStateException("Can't finish().  Uploader already closed.");
            }
            this.conn = null;
            return StandardHttpRequestor.toResponse(conn);
        }
    }
}

