/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class MergeInsert {
    private List<Column> columns = null;
    private List<Expression> values = null;
    private Expression whereCondition;

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public List<Expression> getValues() {
        return this.values;
    }

    public void setValues(List<Expression> list) {
        this.values = list;
    }

    public Expression getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(Expression expression) {
        this.whereCondition = expression;
    }

    public String toString() {
        return " WHEN NOT MATCHED THEN INSERT " + (this.columns.isEmpty() ? "" : PlainSelect.getStringList(this.columns, true, true)) + " VALUES " + PlainSelect.getStringList(this.values, true, true) + (this.whereCondition != null ? " WHERE " + this.whereCondition : "");
    }

    public MergeInsert withColumns(List<Column> list) {
        this.setColumns(list);
        return this;
    }

    public MergeInsert withValues(List<Expression> list) {
        this.setValues(list);
        return this;
    }

    public MergeInsert addColumns(Column ... columnArray) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnArray);
        return this.withColumns(list);
    }

    public MergeInsert addColumns(Collection<? extends Column> collection) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumns(list);
    }

    public MergeInsert addValues(Expression ... expressionArray) {
        List list = Optional.ofNullable(this.getValues()).orElseGet(ArrayList::new);
        Collections.addAll(list, expressionArray);
        return this.withValues(list);
    }

    public MergeInsert addValues(Collection<? extends Expression> collection) {
        List list = Optional.ofNullable(this.getValues()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withValues(list);
    }

    public MergeInsert withWhereCondition(Expression expression) {
        this.setWhereCondition(expression);
        return this;
    }

    public <E extends Expression> E getWhereCondition(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getWhereCondition()));
    }
}

