/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.pmap;

import ca.odell.glazedlists.impl.io.Bufferlo;
import ca.odell.glazedlists.impl.pmap.Chunk;
import ca.odell.glazedlists.impl.pmap.PersistentMap;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.util.logging.Logger;

class OpenFile
implements Runnable {
    private static Logger logger = Logger.getLogger(OpenFile.class.toString());
    private PersistentMap persistentMap = null;

    public OpenFile(PersistentMap persistentMap) {
        this.persistentMap = persistentMap;
    }

    @Override
    public void run() {
        FileChannel fileChannel = this.persistentMap.getFileChannel();
        try {
            Chunk chunk;
            if (fileChannel.size() == 0L) {
                this.createFile();
                return;
            }
            this.readHeader();
            while ((chunk = Chunk.readChunk(this.persistentMap)) != null) {
                this.persistentMap.loadedChunk(chunk);
                if (!chunk.isOn()) continue;
                logger.info("Successfully loaded key \"" + chunk.getKey() + "\"");
            }
        }
        catch (IOException e) {
            this.persistentMap.fail(e, "Failed to access file " + this.persistentMap.getFile().getPath());
        }
    }

    private void readHeader() throws IOException {
        try {
            Bufferlo fileHeader = new Bufferlo();
            fileHeader.readFromChannel(this.persistentMap.getFileChannel(), 8);
            fileHeader.consume("GLAZED\n\n");
        }
        catch (ParseException e) {
            throw new IOException("The file cannot be read because it is not of the expected type");
        }
        logger.info("Successfully read file header");
    }

    private void createFile() throws IOException {
        Bufferlo fileHeader = new Bufferlo();
        fileHeader.write("GLAZED\n\n");
        this.persistentMap.getFileChannel().position(0L);
        fileHeader.writeToChannel(this.persistentMap.getFileChannel());
        logger.info("Successfully created file");
    }
}

