/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.LongObjectHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncoderPersister;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.AbstractJournalUpdateTask;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalFilesRepository;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalRecord;
import org.apache.activemq.artemis.core.journal.impl.JournalRecordProvider;
import org.apache.activemq.artemis.core.journal.impl.JournalTransaction;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalAddRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalAddRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalCompleteRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalDeleteRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalRollbackRecordTX;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.RunnableEx;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashMap;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashSet;
import org.jboss.logging.Logger;

public class JournalCompactor
extends AbstractJournalUpdateTask
implements JournalRecordProvider {
    private static final Logger logger = Logger.getLogger(JournalCompactor.class);
    LongObjectHashMap<LinkedList<RunnableEx>> pendingWritesOnTX = new LongObjectHashMap();
    IntObjectHashMap<LongObjectHashMap<RunnableEx>> pendingUpdates = new IntObjectHashMap();
    private static final short COMPACT_SPLIT_LINE = 2;
    boolean split = false;
    private final ConcurrentLongHashMap<PendingTransaction> pendingTransactions = new ConcurrentLongHashMap();
    private final ConcurrentLongHashMap<JournalRecord> newRecords = new ConcurrentLongHashMap();
    private final ConcurrentLongHashMap<JournalTransaction> newTransactions = new ConcurrentLongHashMap();
    private final LinkedList<CompactCommand> pendingCommands = new LinkedList();

    public List<JournalFile> getNewDataFiles() {
        return this.newDataFiles;
    }

    public ConcurrentLongHashMap<JournalRecord> getNewRecords() {
        return this.newRecords;
    }

    public ConcurrentLongHashMap<JournalTransaction> getNewTransactions() {
        return this.newTransactions;
    }

    public JournalCompactor(SequentialFileFactory fileFactory, JournalImpl journal, JournalFilesRepository filesRepository, ConcurrentLongHashSet recordsSnapshot, long firstFileID) {
        super(fileFactory, journal, filesRepository, recordsSnapshot, firstFileID);
    }

    public void addPendingTransaction(long transactionID, long[] ids) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("addPendingTransaction::tx=" + transactionID + ", ids=" + Arrays.toString(ids)));
        }
        this.pendingTransactions.put(transactionID, (Object)new PendingTransaction(ids));
    }

    public void addCommandCommit(JournalTransaction liveTransaction, JournalFile currentFile) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("addCommandCommit " + liveTransaction.getId()));
        }
        this.pendingCommands.add(new CommitCompactCommand(liveTransaction, currentFile));
        long[] ids = liveTransaction.getPositiveArray();
        PendingTransaction oldTransaction = (PendingTransaction)this.pendingTransactions.get(liveTransaction.getId());
        long[] ids2 = null;
        if (oldTransaction != null) {
            ids2 = oldTransaction.pendingIDs;
        }
        if (ids != null) {
            for (long id : ids) {
                this.addToRecordsSnaptshot(id);
            }
        }
        if (ids2 != null) {
            for (long id : ids2) {
                this.addToRecordsSnaptshot(id);
            }
        }
    }

    public void addCommandRollback(JournalTransaction liveTransaction, JournalFile currentFile) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("addCommandRollback " + liveTransaction + " currentFile " + currentFile));
        }
        this.pendingCommands.add(new RollbackCompactCommand(liveTransaction, currentFile));
    }

    public void addCommandDelete(long id, JournalFile usedFile) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("addCommandDelete id " + id + " usedFile " + usedFile));
        }
        this.pendingCommands.add(new DeleteCompactCommand(id, usedFile));
    }

    public void addCommandUpdate(long id, JournalFile usedFile, int size, boolean replaceableUpdate) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("addCommandUpdate id " + id + " usedFile " + usedFile + " size " + size));
        }
        this.pendingCommands.add(new UpdateCompactCommand(id, usedFile, size, replaceableUpdate));
    }

    private void checkSize(int size) throws Exception {
        this.checkSizeAndCompactSplit(size, -1);
    }

    private void checkSizeAndCompactSplit(int size, int compactCount) throws Exception {
        if (this.getWritingChannel() == null) {
            if (compactCount < 2) {
                this.split = true;
            }
            this.openFile();
        } else {
            if (compactCount >= 0 && compactCount < 2 && !this.split) {
                this.split = true;
                this.openFile();
            }
            if (this.getWritingChannel().writerIndex() + size > this.getWritingChannel().capacity()) {
                this.openFile();
            }
        }
    }

    public void replayPendingCommands() {
        for (CompactCommand command : this.pendingCommands) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Replay " + command));
            }
            try {
                command.execute();
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                ActiveMQJournalLogger.LOGGER.errorReplayingCommands(e);
            }
        }
        this.pendingCommands.clear();
    }

    public void flushUpdates() throws Exception {
        Collection recordsUpdate = this.pendingUpdates.values();
        for (LongObjectHashMap recordMap : recordsUpdate) {
            for (RunnableEx ex : recordMap.values()) {
                ex.run();
            }
            recordMap.clear();
        }
        recordsUpdate.clear();
    }

    @Override
    public void onReadAddRecord(RecordInfo info) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Read Record " + info));
        }
        if (this.containsRecord(info.id)) {
            JournalAddRecord addRecord = new JournalAddRecord(true, info.id, info.getUserRecordType(), (Persister)EncoderPersister.getInstance(), (Object)new ByteArrayEncoding(info.data));
            addRecord.setCompactCount((short)(info.compactCount + 1));
            this.checkSizeAndCompactSplit(((JournalInternalRecord)addRecord).getEncodeSize(), info.compactCount);
            this.writeEncoder(addRecord);
            this.newRecords.put(info.id, (Object)new JournalRecord(this.currentFile, ((JournalInternalRecord)addRecord).getEncodeSize()));
        }
    }

    @Override
    public void onReadAddRecordTX(long transactionID, RecordInfo info) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Read Add Record TX " + transactionID + " info " + info));
        }
        if (this.pendingTransactions.get(transactionID) != null) {
            this.produceAddRecordTX(transactionID, info);
        } else if (this.containsRecord(info.id)) {
            this.addTX(transactionID, () -> this.produceAddRecordTX(transactionID, info));
        }
    }

    private void produceAddRecordTX(long transactionID, RecordInfo info) throws Exception {
        JournalTransaction newTransaction = this.getNewJournalTransaction(transactionID);
        JournalAddRecordTX record = new JournalAddRecordTX(true, transactionID, info.id, info.getUserRecordType(), EncoderPersister.getInstance(), new ByteArrayEncoding(info.data));
        record.setCompactCount((short)(info.compactCount + 1));
        this.checkSizeAndCompactSplit(((JournalInternalRecord)record).getEncodeSize(), info.compactCount);
        newTransaction.addPositive(this.currentFile, info.id, ((JournalInternalRecord)record).getEncodeSize(), info.replaceableUpdate);
        this.writeEncoder(record);
    }

    @Override
    public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onReadCommitRecord " + transactionID));
        }
        if (this.pendingTransactions.get(transactionID) != null) {
            ActiveMQJournalLogger.LOGGER.inconsistencyDuringCompacting(transactionID);
        } else {
            this.flushTX(transactionID);
            JournalTransaction newTransaction = (JournalTransaction)this.newTransactions.remove(transactionID);
            if (newTransaction != null) {
                JournalCompleteRecordTX commitRecord = new JournalCompleteRecordTX(JournalCompleteRecordTX.TX_RECORD_TYPE.COMMIT, transactionID, null);
                this.checkSize(((JournalInternalRecord)commitRecord).getEncodeSize());
                this.writeEncoder(commitRecord, newTransaction.getCounter(this.currentFile));
                newTransaction.commit(this.currentFile);
            }
        }
    }

    @Override
    public void onReadDeleteRecord(long recordID) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onReadDeleteRecord " + recordID));
        }
        if (this.newRecords.get(recordID) != null) {
            ActiveMQJournalLogger.LOGGER.inconsistencyDuringCompactingDelete(recordID);
        }
    }

    @Override
    public void onReadDeleteRecordTX(long transactionID, RecordInfo info) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onReadDeleteRecordTX " + transactionID + " info " + info));
        }
        if (this.pendingTransactions.get(transactionID) != null) {
            this.produceDeleteRecordTX(transactionID, info);
        }
    }

    private void produceDeleteRecordTX(long transactionID, RecordInfo info) throws Exception {
        JournalTransaction newTransaction = this.getNewJournalTransaction(transactionID);
        JournalDeleteRecordTX record = new JournalDeleteRecordTX(transactionID, info.id, new ByteArrayEncoding(info.data));
        this.checkSize(((JournalInternalRecord)record).getEncodeSize());
        this.writeEncoder(record);
        newTransaction.addNegative(this.currentFile, info.id);
    }

    @Override
    public void markAsDataFile(JournalFile file) {
    }

    private void addTX(long tx, RunnableEx runnable) {
        LinkedList<RunnableEx> runnables = (LinkedList<RunnableEx>)this.pendingWritesOnTX.get(tx);
        if (runnables == null) {
            runnables = new LinkedList<RunnableEx>();
            this.pendingWritesOnTX.put(tx, runnables);
        }
        runnables.add(runnable);
    }

    private void flushTX(long tx) throws Exception {
        LinkedList runnables = (LinkedList)this.pendingWritesOnTX.remove(tx);
        if (runnables != null) {
            for (RunnableEx runnableEx : runnables) {
                runnableEx.run();
            }
            runnables.clear();
        }
    }

    private void dropTX(long tx) {
        LinkedList objects = (LinkedList)this.pendingWritesOnTX.remove(tx);
        if (objects != null) {
            objects.clear();
        }
    }

    @Override
    public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onReadPrepareRecord " + transactionID));
        }
        if (this.pendingTransactions.get(transactionID) != null) {
            this.flushTX(transactionID);
            this.producePrepareRecord(transactionID, extraData);
        }
    }

    private void producePrepareRecord(long transactionID, byte[] extraData) throws Exception {
        JournalTransaction newTransaction = this.getNewJournalTransaction(transactionID);
        JournalCompleteRecordTX prepareRecord = new JournalCompleteRecordTX(JournalCompleteRecordTX.TX_RECORD_TYPE.PREPARE, transactionID, new ByteArrayEncoding(extraData));
        this.checkSize(((JournalInternalRecord)prepareRecord).getEncodeSize());
        this.writeEncoder(prepareRecord, newTransaction.getCounter(this.currentFile));
        newTransaction.prepare(this.currentFile);
    }

    @Override
    public void onReadRollbackRecord(long transactionID) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onReadRollbackRecord " + transactionID));
        }
        if (this.pendingTransactions.get(transactionID) != null) {
            logger.debug((Object)("Inconsistency during compacting: RollbackRecord ID = " + transactionID + " for an already rolled back transaction during compacting"));
        } else {
            JournalTransaction newTransaction = (JournalTransaction)this.newTransactions.remove(transactionID);
            if (newTransaction != null) {
                this.flushTX(transactionID);
                this.produceRollbackRecord(transactionID, newTransaction);
            } else {
                this.dropTX(transactionID);
            }
        }
    }

    private void produceRollbackRecord(long transactionID, JournalTransaction newTransaction) throws Exception {
        JournalRollbackRecordTX rollbackRecord = new JournalRollbackRecordTX(transactionID);
        this.checkSize(((JournalInternalRecord)rollbackRecord).getEncodeSize());
        this.writeEncoder(rollbackRecord);
        newTransaction.rollback(this.currentFile);
    }

    public void replaceableRecord(byte recordType) {
        LongObjectHashMap longmap = new LongObjectHashMap();
        this.pendingUpdates.put((int)recordType, (Object)longmap);
    }

    @Override
    public void onReadUpdateRecord(RecordInfo info) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onReadUpdateRecord " + info));
        }
        if (this.containsRecord(info.id)) {
            LongObjectHashMap longmap = (LongObjectHashMap)this.pendingUpdates.get((int)info.userRecordType);
            if (longmap == null) {
                this.produceUpdateRecord(info);
            } else {
                longmap.put(info.id, () -> this.produceUpdateRecord(info));
            }
        }
    }

    private void produceUpdateRecord(RecordInfo info) throws Exception {
        JournalAddRecord updateRecord = new JournalAddRecord(false, info.id, info.userRecordType, (Persister)EncoderPersister.getInstance(), (Object)new ByteArrayEncoding(info.data));
        updateRecord.setCompactCount((short)(info.compactCount + 1));
        this.checkSizeAndCompactSplit(((JournalInternalRecord)updateRecord).getEncodeSize(), info.compactCount);
        JournalRecord newRecord = (JournalRecord)this.newRecords.get(info.id);
        if (newRecord == null) {
            ActiveMQJournalLogger.LOGGER.compactingWithNoAddRecord(info.id);
        } else {
            newRecord.addUpdateFile(this.currentFile, ((JournalInternalRecord)updateRecord).getEncodeSize(), info.replaceableUpdate);
        }
        this.writeEncoder(updateRecord);
    }

    @Override
    public void onReadUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onReadUpdateRecordTX " + info));
        }
        if (this.pendingTransactions.get(transactionID) != null) {
            this.produceUpdateRecordTX(transactionID, info);
        } else if (this.containsRecord(info.id)) {
            this.addTX(transactionID, () -> this.produceUpdateRecordTX(transactionID, info));
        }
    }

    private void produceUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
        JournalTransaction newTransaction = this.getNewJournalTransaction(transactionID);
        JournalAddRecordTX updateRecordTX = new JournalAddRecordTX(false, transactionID, info.id, info.userRecordType, EncoderPersister.getInstance(), new ByteArrayEncoding(info.data));
        updateRecordTX.setCompactCount((short)(info.compactCount + 1));
        this.checkSizeAndCompactSplit(((JournalInternalRecord)updateRecordTX).getEncodeSize(), info.compactCount);
        this.writeEncoder(updateRecordTX);
        newTransaction.addPositive(this.currentFile, info.id, ((JournalInternalRecord)updateRecordTX).getEncodeSize(), info.replaceableUpdate);
    }

    private JournalTransaction getNewJournalTransaction(long transactionID) {
        JournalTransaction newTransaction = (JournalTransaction)this.newTransactions.get(transactionID);
        if (newTransaction == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("creating new journal Transaction " + transactionID));
            }
            newTransaction = new JournalTransaction(transactionID, this);
            this.newTransactions.put(transactionID, (Object)newTransaction);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("reusing TX " + transactionID));
        }
        return newTransaction;
    }

    @Override
    public JournalCompactor getCompactor() {
        return null;
    }

    @Override
    public ConcurrentLongHashMap<JournalRecord> getRecords() {
        return this.newRecords;
    }

    private class RollbackCompactCommand
    extends CompactCommand {
        private final JournalTransaction liveTransaction;
        private final JournalFile rollbackFile;

        private RollbackCompactCommand(JournalTransaction liveTransaction, JournalFile rollbackFile) {
            this.liveTransaction = liveTransaction;
            this.rollbackFile = rollbackFile;
        }

        @Override
        void execute() throws Exception {
            JournalTransaction newTransaction = (JournalTransaction)JournalCompactor.this.newTransactions.get(this.liveTransaction.getId());
            if (newTransaction != null) {
                this.liveTransaction.merge(newTransaction);
                this.liveTransaction.rollback(this.rollbackFile);
            }
            JournalCompactor.this.newTransactions.remove(this.liveTransaction.getId());
        }

        public String toString() {
            return "RollbackCompactCommand{liveTransaction=" + this.liveTransaction + ", rollbackFile=" + this.rollbackFile + "}";
        }
    }

    private class CommitCompactCommand
    extends CompactCommand {
        private final JournalTransaction liveTransaction;
        private final JournalFile commitFile;

        private CommitCompactCommand(JournalTransaction liveTransaction, JournalFile commitFile) {
            this.liveTransaction = liveTransaction;
            this.commitFile = commitFile;
        }

        @Override
        void execute() throws Exception {
            JournalTransaction newTransaction = (JournalTransaction)JournalCompactor.this.newTransactions.get(this.liveTransaction.getId());
            if (newTransaction != null) {
                this.liveTransaction.merge(newTransaction);
                this.liveTransaction.commit(this.commitFile);
            }
            JournalCompactor.this.newTransactions.remove(this.liveTransaction.getId());
        }

        public String toString() {
            return "CommitCompactCommand{commitFile=" + this.commitFile + ", liveTransaction=" + this.liveTransaction + "}";
        }
    }

    private class UpdateCompactCommand
    extends CompactCommand {
        private final long id;
        private final JournalFile usedFile;
        private final int size;
        private final boolean replaceableUpdate;

        private UpdateCompactCommand(long id, JournalFile usedFile, int size, boolean replaceableUpdate) {
            this.id = id;
            this.usedFile = usedFile;
            this.size = size;
            this.replaceableUpdate = replaceableUpdate;
        }

        @Override
        void execute() throws Exception {
            JournalRecord updateRecord = (JournalRecord)JournalCompactor.this.journal.getRecords().get(this.id);
            if (updateRecord == null) {
                ActiveMQJournalLogger.LOGGER.noRecordDuringCompactReplay(this.id);
            } else {
                updateRecord.addUpdateFile(this.usedFile, this.size, this.replaceableUpdate);
            }
        }

        public String toString() {
            return "UpdateCompactCommand{id=" + this.id + ", usedFile=" + this.usedFile + ", size=" + this.size + "}";
        }
    }

    private static class PendingTransaction {
        long[] pendingIDs;

        PendingTransaction(long[] ids) {
            this.pendingIDs = ids;
        }
    }

    private class DeleteCompactCommand
    extends CompactCommand {
        long id;
        JournalFile usedFile;

        private DeleteCompactCommand(long id, JournalFile usedFile) {
            this.id = id;
            this.usedFile = usedFile;
        }

        @Override
        void execute() throws Exception {
            JournalRecord deleteRecord = (JournalRecord)JournalCompactor.this.journal.getRecords().remove(this.id);
            if (deleteRecord == null) {
                ActiveMQJournalLogger.LOGGER.noRecordDuringCompactReplay(this.id);
            } else {
                deleteRecord.delete(this.usedFile);
            }
        }
    }

    private static abstract class CompactCommand {
        private CompactCommand() {
        }

        abstract void execute() throws Exception;
    }
}

