/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion.comparer.value;

import java.util.Set;
import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.comparer.value.ValueComparer;
import org.dbunit.assertion.comparer.value.ValueComparerBase;
import org.dbunit.assertion.comparer.value.ValueFactory;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.DataType;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalSetBiValueComparer<T>
extends ValueComparerBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ValueFactory<T> actualValueFactory;
    private final Set<T> values;
    private final ValueComparer inValuesValueComparer;
    private final ValueComparer notInValuesValueComparer;

    public ConditionalSetBiValueComparer(ValueFactory<T> actualValueFactory, Set<T> values, ValueComparer inValuesValueComparer, ValueComparer notInValuesValueComparer) {
        Assert.assertNotNull((String)"actualValueFactory is null.", actualValueFactory);
        Assert.assertNotNull((String)"values is null.", values);
        Assert.assertNotNull((String)"inValuesValueComparer is null.", (Object)inValuesValueComparer);
        Assert.assertNotNull((String)"notInValuesValueComparer is null.", (Object)notInValuesValueComparer);
        this.actualValueFactory = actualValueFactory;
        this.values = values;
        this.inValuesValueComparer = inValuesValueComparer;
        this.notInValuesValueComparer = notInValuesValueComparer;
    }

    @Override
    public String doCompare(ITable expectedTable, ITable actualTable, int rowNum, String columnName, DataType dataType, Object expectedValue, Object actualValue) throws DatabaseUnitException {
        boolean isInValues = this.isActualValueInValues(actualTable, rowNum);
        String failMessage = isInValues ? this.inValuesValueComparer.compare(expectedTable, actualTable, rowNum, columnName, dataType, expectedValue, actualValue) : this.notInValuesValueComparer.compare(expectedTable, actualTable, rowNum, columnName, dataType, expectedValue, actualValue);
        return failMessage;
    }

    protected boolean isActualValueInValues(ITable actualTable, int rowNum) throws DataSetException {
        T actualValue = this.actualValueFactory.make(actualTable, rowNum);
        boolean isListContains = this.values.contains(actualValue);
        this.log.debug("isActualValueInValues: actualValue={}, isListContains={}", actualValue, (Object)isListContains);
        return isListContains;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(400);
        sb.append(super.toString());
        sb.append(": [values=");
        sb.append(this.values);
        sb.append(", inValuesValueComparer=");
        sb.append(this.inValuesValueComparer);
        sb.append(", notInValuesValueComparer=");
        sb.append(this.notInValuesValueComparer);
        sb.append("]");
        return sb.toString();
    }
}

