/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.sbr;

import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.DowningProvider;
import akka.cluster.sbr.DownAllNodes;
import akka.cluster.sbr.DowningStrategy;
import akka.cluster.sbr.KeepMajority;
import akka.cluster.sbr.KeepOldest;
import akka.cluster.sbr.KeepOldestSettings;
import akka.cluster.sbr.LeaseMajority;
import akka.cluster.sbr.LeaseMajoritySettings;
import akka.cluster.sbr.SplitBrainResolver$;
import akka.cluster.sbr.SplitBrainResolverSettings;
import akka.cluster.sbr.StaticQuorum;
import akka.cluster.sbr.StaticQuorumSettings;
import akka.coordination.lease.scaladsl.Lease;
import akka.coordination.lease.scaladsl.LeaseProvider;
import akka.coordination.lease.scaladsl.LeaseProvider$;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m2Aa\u0002\u0005\u0003\u001f!AA\u0003\u0001B\u0001B\u0003%Q\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0004!\u0001\t\u0007I\u0011B\u0011\t\r\u0015\u0002\u0001\u0015!\u0003#\u0011\u00151\u0003\u0001\"\u0011(\u0011\u0015\u0011\u0004\u0001\"\u00114\u0005i\u0019\u0006\u000f\\5u\u0005J\f\u0017N\u001c*fg>dg/\u001a:Qe>4\u0018\u000eZ3s\u0015\tI!\"A\u0002tEJT!a\u0003\u0007\u0002\u000f\rdWo\u001d;fe*\tQ\"\u0001\u0003bW.\f7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003)I!a\u0005\u0006\u0003\u001f\u0011{wO\\5oOB\u0013xN^5eKJ\faa]=ti\u0016l\u0007C\u0001\f\u001a\u001b\u00059\"B\u0001\r\r\u0003\u0015\t7\r^8s\u0013\tQrCA\u0006BGR|'oU=ti\u0016l\u0017A\u0002\u001fj]&$h\b\u0006\u0002\u001e?A\u0011a\u0004A\u0007\u0002\u0011!)AC\u0001a\u0001+\u0005A1/\u001a;uS:<7/F\u0001#!\tq2%\u0003\u0002%\u0011\tQ2\u000b\u001d7ji\n\u0013\u0018-\u001b8SKN|GN^3s'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0012I><hNU3n_Z\fG.T1sO&tW#\u0001\u0015\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005-b\u0013\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u00055r\u0013AC2p]\u000e,(O]3oi*\tq&A\u0003tG\u0006d\u0017-\u0003\u00022U\tqa)\u001b8ji\u0016$UO]1uS>t\u0017!\u00053po:LgnZ!di>\u0014\bK]8qgV\tA\u0007E\u00026maj\u0011AL\u0005\u0003o9\u0012aa\u00149uS>t\u0007C\u0001\f:\u0013\tQtCA\u0003Qe>\u00048\u000f")
public final class SplitBrainResolverProvider
extends DowningProvider {
    private final ActorSystem system;
    private final SplitBrainResolverSettings settings;

    private SplitBrainResolverSettings settings() {
        return this.settings;
    }

    @Override
    public FiniteDuration downRemovalMargin() {
        FiniteDuration drm;
        FiniteDuration finiteDuration = drm = ((Cluster)Cluster$.MODULE$.apply(this.system)).settings().DownRemovalMargin();
        FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
        return (finiteDuration == null ? finiteDuration2 != null : !finiteDuration.equals(finiteDuration2)) ? drm : this.settings().DowningStableAfter();
    }

    @Override
    public Option<Props> downingActorProps() {
        DowningStrategy downingStrategy;
        block7: {
            Cluster cluster = (Cluster)Cluster$.MODULE$.apply(this.system);
            String selfDc = cluster.selfDataCenter();
            String string = this.settings().DowningStrategy();
            switch (string == null ? 0 : string.hashCode()) {
                case -1642658489: {
                    if (!"keep-oldest".equals(string)) break;
                    KeepOldestSettings s = this.settings().keepOldestSettings();
                    downingStrategy = new KeepOldest(selfDc, s.downIfAlone(), s.role(), cluster.selfUniqueAddress());
                    break block7;
                }
                case -1566599576: {
                    if (!"lease-majority".equals(string)) break;
                    LeaseMajoritySettings s = this.settings().leaseMajoritySettings();
                    String leaseOwnerName = cluster.selfUniqueAddress().address().hostPort();
                    String leaseName = s.safeLeaseName(this.system.name());
                    Lease lease = ((LeaseProvider)LeaseProvider$.MODULE$.apply(this.system)).getLease(leaseName, s.leaseImplementation(), leaseOwnerName);
                    downingStrategy = new LeaseMajority(selfDc, s.role(), lease, s.acquireLeaseDelayForMinority(), s.releaseAfter(), cluster.selfUniqueAddress());
                    break block7;
                }
                case -849301474: {
                    if (!"static-quorum".equals(string)) break;
                    StaticQuorumSettings s = this.settings().staticQuorumSettings();
                    downingStrategy = new StaticQuorum(selfDc, s.size(), s.role(), cluster.selfUniqueAddress());
                    break block7;
                }
                case 1425928694: {
                    if (!"down-all".equals(string)) break;
                    downingStrategy = new DownAllNodes(selfDc, cluster.selfUniqueAddress());
                    break block7;
                }
                case 1770871197: {
                    if (!"keep-majority".equals(string)) break;
                    downingStrategy = new KeepMajority(selfDc, this.settings().keepMajorityRole(), cluster.selfUniqueAddress());
                    break block7;
                }
            }
            throw new MatchError((Object)string);
        }
        DownAllNodes strategy = downingStrategy;
        return new Some((Object)SplitBrainResolver$.MODULE$.props(this.settings().DowningStableAfter(), strategy));
    }

    public SplitBrainResolverProvider(ActorSystem system) {
        this.system = system;
        this.settings = new SplitBrainResolverSettings(system.settings().config());
    }
}

