/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.exception.CommandValidationException;
import liquibase.exception.MissingRequiredArgumentException;
import liquibase.integration.commandline.LiquibaseCommandLine;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.util.StringUtil;
import picocli.CommandLine;

class CommandRunner
implements Callable<CommandResults> {
    private CommandLine.Model.CommandSpec spec;

    CommandRunner() {
    }

    @Override
    public CommandResults call() throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.spec.commandLine().getCommandName());
        CommandLine parentCommand = this.spec.commandLine().getParent();
        while (!parentCommand.getCommandName().equals("liquibase")) {
            command.add(0, parentCommand.getCommandName());
            parentCommand = parentCommand.getParent();
        }
        String[] commandName = LiquibaseCommandLine.getCommandNames(this.spec.commandLine());
        for (int i = 0; i < commandName.length; ++i) {
            commandName[i] = StringUtil.toCamelCase(commandName[i]);
        }
        CommandScope commandScope = new CommandScope(commandName);
        File outputFile = LiquibaseCommandLineConfiguration.OUTPUT_FILE.getCurrentValue();
        OutputStream outputStream = null;
        try {
            if (outputFile != null) {
                outputStream = new FileOutputStream(outputFile);
                commandScope.setOutput(outputStream);
            }
            CommandResults commandResults = commandScope.execute();
            return commandResults;
        }
        catch (CommandValidationException cve) {
            Throwable cause = cve.getCause();
            if (cause instanceof MissingRequiredArgumentException) {
                Set initProjectArguments = Stream.of(CommonArgumentNames.CHANGELOG_FILE, CommonArgumentNames.URL, CommonArgumentNames.USERNAME, CommonArgumentNames.PASSWORD).map(CommonArgumentNames::getArgumentName).collect(Collectors.toSet());
                throw new CommandValidationException(cve.getMessage() + (initProjectArguments.contains(((MissingRequiredArgumentException)cause).getArgumentName()) ? ". If you need to configure new liquibase project files and arguments, run the 'liquibase init project' command." : ""));
            }
            throw cve;
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
    }

    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }
}

