/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import liquibase.resource.AbstractPathHandler;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class FileSystemPathHandler
extends AbstractPathHandler {
    @Override
    public int getPriority(String root) {
        if (root == null) {
            return -1;
        }
        if (!root.startsWith("/") && root.contains(":")) {
            if (root.startsWith("file:") || root.matches("^[A-Za-z]:.*")) {
                return 1;
            }
            return -1;
        }
        return 1;
    }

    @Override
    public ResourceAccessor getResourceAccessor(String root) {
        return new FileSystemResourceAccessor(new File(root.replace("\\", "/")));
    }

    @Override
    public InputStream open(String path) throws IOException {
        try {
            return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            throw new IOException("File '" + path + "' does not exist");
        }
    }
}

