/*
 * Decompiled with CFR 0.152.
 */
package akka.http.shaded.com.twitter.hpack;

import akka.http.shaded.com.twitter.hpack.HpackUtil;

class HeaderField
implements Comparable<HeaderField> {
    static final int HEADER_ENTRY_OVERHEAD = 32;
    final String name;
    final String value;
    Object parsedValue = null;

    static int sizeOf(String string, String string2) {
        return string.length() + string2.length() + 32;
    }

    HeaderField(String string, String string2) {
        this.name = HpackUtil.requireNonNull(string);
        this.value = HpackUtil.requireNonNull(string2);
    }

    HeaderField(String string, String string2, Object object) {
        this.name = HpackUtil.requireNonNull(string);
        this.value = HpackUtil.requireNonNull(string2);
        this.parsedValue = object;
    }

    int size() {
        return this.name.length() + this.value.length() + 32;
    }

    @Override
    public int compareTo(HeaderField headerField) {
        int n = this.compareTo(this.name, headerField.name);
        if (n == 0) {
            n = this.compareTo(this.value, headerField.value);
        }
        return n;
    }

    private int compareTo(String string, String string2) {
        return string.compareTo(string2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HeaderField)) {
            return false;
        }
        HeaderField headerField = (HeaderField)object;
        return this.name.equals(headerField.name) && this.value.equals(headerField.value);
    }

    public String toString() {
        return this.name + ": " + this.value;
    }
}

