/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.ChannelLogger;
import io.grpc.InternalChannelz;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import io.grpc.alts.internal.AltsClientOptions;
import io.grpc.alts.internal.AltsHandshakerOptions;
import io.grpc.alts.internal.AltsInternalContext;
import io.grpc.alts.internal.AltsTsiHandshaker;
import io.grpc.alts.internal.AsyncSemaphore;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.NettyTsiHandshaker;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiHandshakeHandler;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.alts.internal.TsiPeer;
import io.grpc.grpclb.GrpclbConstants;
import io.grpc.internal.ObjectPool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class AltsProtocolNegotiator {
    private static final Logger logger = Logger.getLogger(AltsProtocolNegotiator.class.getName());
    private static final AsyncSemaphore handshakeSemaphore = new AsyncSemaphore(32);
    public static final Attributes.Key<TsiPeer> TSI_PEER_KEY = Attributes.Key.create((String)"internal:TSI_PEER");
    public static final Attributes.Key<Object> AUTH_CONTEXT_KEY = Attributes.Key.create((String)"internal:AUTH_CONTEXT_KEY");
    private static final AsciiString SCHEME = AsciiString.of((CharSequence)"https");
    private static final String DIRECT_PATH_SERVICE_CFE_CLUSTER_PREFIX = "google_cfe_";
    private static final String CFE_CLUSTER_RESOURCE_NAME_PREFIX = "/envoy.config.cluster.v3.Cluster/google_cfe_";
    private static final String CFE_CLUSTER_AUTHORITY_NAME = "traffic-director-c2p.xds.googleapis.com";

    public static InternalProtocolNegotiator.ProtocolNegotiator serverAltsProtocolNegotiator(ObjectPool<Channel> handshakerChannelPool) {
        LazyChannel lazyHandshakerChannel = new LazyChannel(handshakerChannelPool);
        final class ServerTsiHandshakerFactory
        implements TsiHandshakerFactory {
            final /* synthetic */ LazyChannel val$lazyHandshakerChannel;

            ServerTsiHandshakerFactory(LazyChannel lazyChannel) {
                this.val$lazyHandshakerChannel = lazyChannel;
            }

            @Override
            public TsiHandshaker newHandshaker(@Nullable String authority, ChannelLogger negotiationLogger) {
                assert (authority == null);
                return AltsTsiHandshaker.newServer(HandshakerServiceGrpc.newStub(this.val$lazyHandshakerChannel.get()), new AltsHandshakerOptions(RpcProtocolVersionsUtil.getRpcProtocolVersions()), negotiationLogger);
            }
        }
        return new ServerAltsProtocolNegotiator(new ServerTsiHandshakerFactory(lazyHandshakerChannel), lazyHandshakerChannel);
    }

    private AltsProtocolNegotiator() {
    }

    private static final class AltsHandshakeValidator
    extends TsiHandshakeHandler.HandshakeValidator {
        private AltsHandshakeValidator() {
        }

        @Override
        public TsiHandshakeHandler.HandshakeValidator.SecurityDetails validatePeerObject(Object peerObject) throws GeneralSecurityException {
            AltsInternalContext altsContext = (AltsInternalContext)peerObject;
            RpcProtocolVersionsUtil.RpcVersionsCheckResult checkResult = RpcProtocolVersionsUtil.checkRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions(), altsContext.getPeerRpcVersions());
            if (!checkResult.getResult()) {
                String errorMessage = "Local Rpc Protocol Versions " + RpcProtocolVersionsUtil.getRpcProtocolVersions() + " are not compatible with peer Rpc Protocol Versions " + altsContext.getPeerRpcVersions();
                throw Status.UNAVAILABLE.withDescription(errorMessage).asRuntimeException();
            }
            return new TsiHandshakeHandler.HandshakeValidator.SecurityDetails(SecurityLevel.PRIVACY_AND_INTEGRITY, new InternalChannelz.Security(new InternalChannelz.OtherSecurity("alts", (Object)Any.pack((Message)altsContext.context))));
        }
    }

    @VisibleForTesting
    static final class LazyChannel {
        private final ObjectPool<Channel> channelPool;
        private Channel channel;

        @VisibleForTesting
        LazyChannel(ObjectPool<Channel> channelPool) {
            this.channelPool = (ObjectPool)Preconditions.checkNotNull(channelPool, (Object)"channelPool");
        }

        synchronized Channel get() {
            if (this.channel == null) {
                this.channel = (Channel)this.channelPool.getObject();
            }
            return this.channel;
        }

        synchronized void close() {
            if (this.channel != null) {
                this.channel = (Channel)this.channelPool.returnObject((Object)this.channel);
            }
        }
    }

    private static final class ClientTsiHandshakerFactory
    implements TsiHandshakerFactory {
        private final ImmutableList<String> targetServiceAccounts;
        private final LazyChannel lazyHandshakerChannel;

        ClientTsiHandshakerFactory(ImmutableList<String> targetServiceAccounts, LazyChannel lazyHandshakerChannel) {
            this.targetServiceAccounts = (ImmutableList)Preconditions.checkNotNull(targetServiceAccounts, (Object)"targetServiceAccounts");
            this.lazyHandshakerChannel = (LazyChannel)Preconditions.checkNotNull((Object)lazyHandshakerChannel, (Object)"lazyHandshakerChannel");
        }

        @Override
        public TsiHandshaker newHandshaker(@Nullable String authority, ChannelLogger negotiationLogger) {
            AltsClientOptions handshakerOptions = new AltsClientOptions.Builder().setRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions()).setTargetServiceAccounts(this.targetServiceAccounts).setTargetName(authority).build();
            return AltsTsiHandshaker.newClient(HandshakerServiceGrpc.newStub(this.lazyHandshakerChannel.get()), handshakerOptions, negotiationLogger);
        }
    }

    private static final class GoogleDefaultProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final TsiHandshakerFactory handshakerFactory;
        private final LazyChannel lazyHandshakerChannel;
        private final SslContext sslContext;
        @Nullable
        private final Attributes.Key<String> clusterNameAttrKey;

        GoogleDefaultProtocolNegotiator(ImmutableList<String> targetServiceAccounts, ObjectPool<Channel> handshakerChannelPool, SslContext sslContext, @Nullable Attributes.Key<String> clusterNameAttrKey) {
            this.lazyHandshakerChannel = new LazyChannel(handshakerChannelPool);
            this.handshakerFactory = new ClientTsiHandshakerFactory(targetServiceAccounts, this.lazyHandshakerChannel);
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"checkNotNull");
            this.clusterNameAttrKey = clusterNameAttrKey;
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            Object securityHandler;
            ChannelHandler gnh = InternalProtocolNegotiators.grpcNegotiationHandler((GrpcHttp2ConnectionHandler)grpcHandler);
            ChannelLogger negotiationLogger = grpcHandler.getNegotiationLogger();
            boolean isXdsDirectPath = false;
            if (this.clusterNameAttrKey != null) {
                isXdsDirectPath = this.isDirectPathCluster((String)grpcHandler.getEagAttributes().get(this.clusterNameAttrKey));
            }
            if (grpcHandler.getEagAttributes().get(GrpclbConstants.ATTR_LB_ADDR_AUTHORITY) != null || grpcHandler.getEagAttributes().get(GrpclbConstants.ATTR_LB_PROVIDED_BACKEND) != null || isXdsDirectPath) {
                TsiHandshaker handshaker = this.handshakerFactory.newHandshaker(grpcHandler.getAuthority(), negotiationLogger);
                NettyTsiHandshaker nettyHandshaker = new NettyTsiHandshaker(handshaker);
                securityHandler = new TsiHandshakeHandler(gnh, nettyHandshaker, new AltsHandshakeValidator(), handshakeSemaphore, negotiationLogger);
            } else {
                securityHandler = InternalProtocolNegotiators.clientTlsHandler((ChannelHandler)gnh, (SslContext)this.sslContext, (String)grpcHandler.getAuthority(), (ChannelLogger)negotiationLogger);
            }
            ChannelHandler wuah = InternalProtocolNegotiators.waitUntilActiveHandler((ChannelHandler)securityHandler, (ChannelLogger)negotiationLogger);
            return wuah;
        }

        private boolean isDirectPathCluster(String clusterName) {
            if (clusterName == null) {
                return false;
            }
            if (clusterName.startsWith(AltsProtocolNegotiator.DIRECT_PATH_SERVICE_CFE_CLUSTER_PREFIX)) {
                return false;
            }
            if (!clusterName.startsWith("xdstp:")) {
                return true;
            }
            try {
                URI uri = new URI(clusterName);
                return !AltsProtocolNegotiator.CFE_CLUSTER_AUTHORITY_NAME.equals(uri.getHost()) || !uri.getPath().startsWith(AltsProtocolNegotiator.CFE_CLUSTER_RESOURCE_NAME_PREFIX);
            }
            catch (URISyntaxException e) {
                return true;
            }
        }

        public void close() {
            logger.finest("ALTS Server ProtocolNegotiator Closed");
            this.lazyHandshakerChannel.close();
        }
    }

    public static final class GoogleDefaultProtocolNegotiatorFactory
    implements InternalProtocolNegotiator.ClientFactory {
        @Nullable
        @VisibleForTesting
        static Attributes.Key<String> clusterNameAttrKey = GoogleDefaultProtocolNegotiatorFactory.loadClusterNameAttrKey();
        private final ImmutableList<String> targetServiceAccounts;
        private final ObjectPool<Channel> handshakerChannelPool;
        private final SslContext sslContext;

        public GoogleDefaultProtocolNegotiatorFactory(List<String> targetServiceAccounts, ObjectPool<Channel> handshakerChannelPool, SslContext sslContext) {
            this.targetServiceAccounts = ImmutableList.copyOf(targetServiceAccounts);
            this.handshakerChannelPool = (ObjectPool)Preconditions.checkNotNull(handshakerChannelPool, (Object)"handshakerChannelPool");
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
        }

        public InternalProtocolNegotiator.ProtocolNegotiator newNegotiator() {
            return new GoogleDefaultProtocolNegotiator(this.targetServiceAccounts, this.handshakerChannelPool, this.sslContext, clusterNameAttrKey);
        }

        public int getDefaultPort() {
            return 443;
        }

        @Nullable
        private static Attributes.Key<String> loadClusterNameAttrKey() {
            Attributes.Key key = null;
            try {
                Class<?> klass = Class.forName("io.grpc.xds.InternalXdsAttributes");
                key = (Attributes.Key)klass.getField("ATTR_CLUSTER_NAME").get(null);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.FINE, "Unable to load xDS endpoint cluster name key, this may be expected", e);
            }
            catch (NoSuchFieldException e) {
                logger.log(Level.FINE, "Unable to load xDS endpoint cluster name key, this may be expected", e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.FINE, "Unable to load xDS endpoint cluster name key, this may be expected", e);
            }
            return key;
        }
    }

    @VisibleForTesting
    static final class ServerAltsProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final TsiHandshakerFactory handshakerFactory;
        private final LazyChannel lazyHandshakerChannel;

        @VisibleForTesting
        ServerAltsProtocolNegotiator(TsiHandshakerFactory handshakerFactory, LazyChannel lazyHandshakerChannel) {
            this.handshakerFactory = (TsiHandshakerFactory)Preconditions.checkNotNull((Object)handshakerFactory, (Object)"handshakerFactory");
            this.lazyHandshakerChannel = (LazyChannel)Preconditions.checkNotNull((Object)lazyHandshakerChannel, (Object)"lazyHandshakerChannel");
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            ChannelLogger negotiationLogger = grpcHandler.getNegotiationLogger();
            TsiHandshaker handshaker = this.handshakerFactory.newHandshaker(null, negotiationLogger);
            NettyTsiHandshaker nettyHandshaker = new NettyTsiHandshaker(handshaker);
            ChannelHandler gnh = InternalProtocolNegotiators.grpcNegotiationHandler((GrpcHttp2ConnectionHandler)grpcHandler);
            TsiHandshakeHandler thh = new TsiHandshakeHandler(gnh, nettyHandshaker, new AltsHandshakeValidator(), handshakeSemaphore, negotiationLogger);
            ChannelHandler wuah = InternalProtocolNegotiators.waitUntilActiveHandler((ChannelHandler)thh, (ChannelLogger)negotiationLogger);
            return wuah;
        }

        public void close() {
            logger.finest("ALTS Server ProtocolNegotiator Closed");
            this.lazyHandshakerChannel.close();
        }
    }

    private static final class ClientAltsProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final TsiHandshakerFactory handshakerFactory;
        private final LazyChannel lazyHandshakerChannel;

        ClientAltsProtocolNegotiator(ImmutableList<String> targetServiceAccounts, ObjectPool<Channel> handshakerChannelPool) {
            this.lazyHandshakerChannel = new LazyChannel(handshakerChannelPool);
            this.handshakerFactory = new ClientTsiHandshakerFactory(targetServiceAccounts, this.lazyHandshakerChannel);
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            ChannelLogger negotiationLogger = grpcHandler.getNegotiationLogger();
            TsiHandshaker handshaker = this.handshakerFactory.newHandshaker(grpcHandler.getAuthority(), negotiationLogger);
            NettyTsiHandshaker nettyHandshaker = new NettyTsiHandshaker(handshaker);
            ChannelHandler gnh = InternalProtocolNegotiators.grpcNegotiationHandler((GrpcHttp2ConnectionHandler)grpcHandler);
            TsiHandshakeHandler thh = new TsiHandshakeHandler(gnh, nettyHandshaker, new AltsHandshakeValidator(), handshakeSemaphore, negotiationLogger);
            ChannelHandler wuah = InternalProtocolNegotiators.waitUntilActiveHandler((ChannelHandler)thh, (ChannelLogger)negotiationLogger);
            return wuah;
        }

        public void close() {
            this.lazyHandshakerChannel.close();
        }
    }

    public static final class ClientAltsProtocolNegotiatorFactory
    implements InternalProtocolNegotiator.ClientFactory {
        private final ImmutableList<String> targetServiceAccounts;
        private final ObjectPool<Channel> handshakerChannelPool;

        public ClientAltsProtocolNegotiatorFactory(List<String> targetServiceAccounts, ObjectPool<Channel> handshakerChannelPool) {
            this.targetServiceAccounts = ImmutableList.copyOf(targetServiceAccounts);
            this.handshakerChannelPool = (ObjectPool)Preconditions.checkNotNull(handshakerChannelPool, (Object)"handshakerChannelPool");
        }

        public InternalProtocolNegotiator.ProtocolNegotiator newNegotiator() {
            return new ClientAltsProtocolNegotiator(this.targetServiceAccounts, this.handshakerChannelPool);
        }

        public int getDefaultPort() {
            return 443;
        }
    }
}

