/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.deployit.plugin.stitch.service.ValidationService;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.ExecutionLogger;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler$StitchRepositoryLoadException$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler$StitchRepositoryParseException$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.StitchDefinitionsWithContent;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.adapter.FolderSourceEntryAdapter;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.adapter.SourceEntryAdapter;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.parser.SnippetRange;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.ParametersDTO;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.ProcessorDTO;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.RuleSpecDTO;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.StitchDefinitionDTO;
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.ProcessorHandlerRegistry;
import com.xebialabs.deployit.plugin.stitch.service.engine.util.JsonPathUtils$;
import com.xebialabs.deployit.plugin.stitch.service.util.YamlTransformUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@Component
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\u0005\u000b\u0001uA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!)A\b\u0001C\u0001{!)\u0011\t\u0001C\u0005\u0005\")1\u000f\u0001C\u0005i\")\u0001\u0010\u0001C\u0005s\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0002\u0019\t\u00164\u0017-\u001e7u%\u0016\u0004xn]5u_JL8I]1xY\u0016\u0014(BA\u0006\r\u0003\u001d\u0019'/Y<mKJT!!\u0004\b\u0002\u000b%tG-\u001a=\u000b\u0005=\u0001\u0012AB3oO&tWM\u0003\u0002\u0012%\u000591/\u001a:wS\u000e,'BA\n\u0015\u0003\u0019\u0019H/\u001b;dQ*\u0011QCF\u0001\u0007a2,x-\u001b8\u000b\u0005]A\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005eQ\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u001fI!\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013'\u001b\u0005Q\u0011BA\u0014\u000b\u0005E\u0011V\r]8tSR|'/_\"sC^dWM\u001d\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nQa\u001d7gi)T\u0011!L\u0001\tOJL'P\u001f7fI&\u0011qF\u000b\u0002\b\u0019><w-\u001b8h\u0003a\u0001(o\\2fgN|'\u000fS1oI2,'OU3hSN$(/\u001f\t\u0003eUj\u0011a\r\u0006\u0003i9\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\n\u0005Y\u001a$\u0001\u0007)s_\u000e,7o]8s\u0011\u0006tG\r\\3s%\u0016<\u0017n\u001d;ss\u0006\tb/\u00197jI\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005eRT\"\u0001\t\n\u0005m\u0002\"!\u0005,bY&$\u0017\r^5p]N+'O^5dK\u00061A(\u001b8jiz\"2AP A!\t)\u0003\u0001C\u00031\u0007\u0001\u0007\u0011\u0007C\u00038\u0007\u0001\u0007\u0001(A\u0007qCJ\u001cX-W1nY\u001aKG.\u001a\u000b\u0004\u0007&\f\b\u0003B\u0010E\rbK!!\u0012\u0011\u0003\rQ+\b\u000f\\33!\r9uJ\u0015\b\u0003\u00116s!!\u0013'\u000e\u0003)S!a\u0013\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013B\u0001(!\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001U)\u0003\t1K7\u000f\u001e\u0006\u0003\u001d\u0002\u0002\"a\u0015,\u000e\u0003QS!!\u0016\u0007\u0002\u0007\u0011$x.\u0003\u0002X)\n\u00192\u000b^5uG\"$UMZ5oSRLwN\u001c#U\u001fB!\u0011,\u00181d\u001d\tQ6\f\u0005\u0002JA%\u0011A\fI\u0001\u0007!J,G-\u001a4\n\u0005y{&aA'ba*\u0011A\f\t\t\u00033\u0006L!AY0\u0003\rM#(/\u001b8h!\t!w-D\u0001f\u0015\t1'\"\u0001\u0004qCJ\u001cXM]\u0005\u0003Q\u0016\u0014Ab\u00158jaB,GOU1oO\u0016DQA\u001b\u0003A\u0002-\fQ!\u001a8uef\u0004\"\u0001\\8\u000e\u00035T!A\u001c\u0006\u0002\u000f\u0005$\u0017\r\u001d;fe&\u0011\u0001/\u001c\u0002\u0013'>,(oY3F]R\u0014\u00180\u00113baR,'\u000fC\u0003s\t\u0001\u0007\u0001-\u0001\u0005s_>$\b+\u0019;i\u0003=9W\r\u001e*fY\u0006$\u0018N^3QCRDGc\u00011vo\")a/\u0002a\u0001A\u0006Aa-\u001e7m!\u0006$\b\u000eC\u0003s\u000b\u0001\u0007\u0001-\u0001\rqCJ\u001cX\r\u0015:pG\u0016\u001c8o\u001c:QCJ\fW.\u001a;feN$2A_?\u0000!\ty20\u0003\u0002}A\t!QK\\5u\u0011\u0015qh\u00011\u0001G\u0003\u00191\u0018\r\\;fg\")!N\u0002a\u0001W\u0006yq-\u001a;GS2,Gj\\2bi&|g\u000eF\u0003a\u0003\u000b\tI\u0001\u0003\u0004\u0002\b\u001d\u0001\r\u0001Y\u0001\re\u0016\u0004x\u000eT8dCRLwN\u001c\u0005\u0007\u0003\u00179\u0001\u0019A6\u0002\u000b\rD\u0017\u000e\u001c3\u0002\u000b\r\u0014\u0018m\u001e7\u0015\t\u0005E\u00111\u0006\u000b\u0005\u0003'\ty\u0002E\u0003H\u0003+\tI\"C\u0002\u0002\u0018E\u0013\u0001\u0002T1{s2K7\u000f\u001e\t\u0004K\u0005m\u0011bAA\u000f\u0015\ta2\u000b^5uG\"$UMZ5oSRLwN\\:XSRD7i\u001c8uK:$\bbBA\u0011\u0011\u0001\u000f\u00111E\u0001\u0007Y><w-\u001a:\u0011\t\u0005\u0015\u0012qE\u0007\u0002\u0019%\u0019\u0011\u0011\u0006\u0007\u0003\u001f\u0015CXmY;uS>tGj\\4hKJDQA\u001c\u0005A\u0002-D3\u0001AA\u0018!\u0011\t\t$a\u0012\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\t!\"\u00198o_R\fG/[8o\u0015\u0011\tI$a\u000f\u0002\u000f\u0019\f7\r^8ss*!\u0011QHA \u0003\u0015\u0011W-\u00198t\u0015\u0011\t\t%a\u0011\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\u0012\u0002\u0007=\u0014x-\u0003\u0003\u0002J\u0005M\"!C!vi><\u0018N]3eQ\r\u0001\u0011Q\n\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)!\u00111KA \u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003/\n\tFA\u0005D_6\u0004xN\\3oi\u0002")
public class DefaultRepositoryCrawler
implements RepositoryCrawler,
Logging {
    private final ProcessorHandlerRegistry processorHandlerRegistry;
    private final ValidationService validationService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultRepositoryCrawler defaultRepositoryCrawler = this;
        synchronized (defaultRepositoryCrawler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private Tuple2<List<StitchDefinitionDTO>, Map<String, SnippetRange>> parseYamlFile(SourceEntryAdapter entry, String rootPath) {
        Throwable e;
        this.validationService.validateFileFormatting(entry.path());
        boolean bl = false;
        Failure failure = null;
        Try try_ = Using$.MODULE$.apply((Function0 & Serializable)() -> entry.read(), (Function1 & Serializable)file -> YamlTransformUtils$.MODULE$.toStitchDefinitionDTO((Reader)file), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable e2 = failure.exception();
            if (e2 instanceof JsonMappingException) {
                Object object;
                JsonMappingException jsonMappingException = (JsonMappingException)e2;
                this.warn((Function0<Object>)(Function0 & Serializable)() -> "Couldn't parse " + entry.path() + ", error was: " + jsonMappingException.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> jsonMappingException);
                Object object2 = jsonMappingException.getProcessor();
                if (object2 instanceof JsonParser) {
                    JsonParser jsonParser = (JsonParser)object2;
                    JsonLocation location = jsonParser.getTokenLocation();
                    object = " (line: " + location.getLineNr() + ", column: " + location.getColumnNr() + ")";
                } else {
                    object = "";
                }
                String locationMsg = object;
                String string = JsonPathUtils$.MODULE$.getPath(jsonMappingException);
                switch (string == null ? 0 : string.hashCode()) {
                    default: 
                }
                Object pathMsg = !string.isBlank() ? " Error found on path '" + string + "'." : string;
                throw RepositoryCrawler$StitchRepositoryParseException$.MODULE$.apply("Error parsing file " + this.getRelativePath(entry.path(), rootPath) + locationMsg + "." + (String)pathMsg);
            }
        }
        if (bl && (e = failure.exception()) instanceof Exception) {
            Exception exception = (Exception)e;
            this.warn((Function0<Object>)(Function0 & Serializable)() -> "Couldn't parse " + entry.path() + ", error was: " + exception.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> exception);
            throw new RepositoryCrawler.StitchRepositoryParseException(exception, "Error parsing file " + this.getRelativePath(entry.path(), rootPath) + ".");
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple2 value = (Tuple2)success.value();
            return value;
        }
        throw new MatchError((Object)try_);
    }

    private String getRelativePath(String fullPath, String rootPath) {
        return fullPath.replace(rootPath + "/", "");
    }

    private void parseProcessorParameters(List<StitchDefinitionDTO> values, SourceEntryAdapter entry) {
        values.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultRepositoryCrawler.$anonfun$parseProcessorParameters$1(x$1))).foreach((Function1 & Serializable)rule -> {
            DefaultRepositoryCrawler.$anonfun$parseProcessorParameters$2(this, entry, rule);
            return BoxedUnit.UNIT;
        });
    }

    private String getFileLocation(String repoLocation, SourceEntryAdapter child) {
        Path repoPath = Paths.get(repoLocation, new String[0]);
        Path childPath = Paths.get(child.path(), new String[0]);
        return ((Object)repoPath.relativize(childPath)).toString();
    }

    @Override
    public LazyList<StitchDefinitionsWithContent> crawl(SourceEntryAdapter adapter, ExecutionLogger logger) {
        Throwable exception;
        Throwable exception2;
        if (!adapter.exists()) {
            throw RepositoryCrawler$StitchRepositoryLoadException$.MODULE$.apply("Configured root location [" + adapter.path() + "] does not exist.");
        }
        if (adapter.isFile()) {
            throw RepositoryCrawler$StitchRepositoryLoadException$.MODULE$.apply("Configured root location [" + adapter.path() + "] points to file but must be a directory.");
        }
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.validationService.validateLoadedRules((LazyList<StitchDefinitionsWithContent>)adapter.list(logger).map((Function1 & Serializable)entry -> new Tuple2(entry, this.parseYamlFile((SourceEntryAdapter)entry, adapter.path()))).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SourceEntryAdapter entry = (SourceEntryAdapter)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    List dtoList = (List)tuple22._1();
                    Map parseContext = (Map)tuple22._2();
                    logger.log("[" + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(entry.path()), adapter.path()) + "] contains [" + dtoList.length() + "] stitch definitions:");
                    ((List)dtoList.zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
                        DefaultRepositoryCrawler.$anonfun$crawl$4(logger, x0$2);
                        return BoxedUnit.UNIT;
                    });
                    this.parseProcessorParameters((List<StitchDefinitionDTO>)dtoList, entry);
                    String originalYaml = (String)Using$.MODULE$.apply((Function0 & Serializable)() -> entry.read(), (Function1 & Serializable)x$1 -> IOUtils.toString((Reader)x$1), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).getOrElse((Function0 & Serializable)() -> {
                        throw RepositoryCrawler$StitchRepositoryLoadException$.MODULE$.apply("Cannot read original yaml " + entry.path());
                    });
                    return Option$.MODULE$.apply((Object)new StitchDefinitionsWithContent((List<StitchDefinitionDTO>)dtoList, (Map<String, SnippetRange>)parseContext, this.getFileLocation(adapter.path(), entry), originalYaml));
                }
            }
            throw new MatchError((Object)tuple2);
        })));
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable exception3 = failure.exception();
            if (exception3 instanceof RepositoryCrawler.StitchRepositoryLoadException) {
                RepositoryCrawler.StitchRepositoryLoadException stitchRepositoryLoadException = (RepositoryCrawler.StitchRepositoryLoadException)((Object)exception3);
                logger.error("Validation errors found while indexing [" + stitchRepositoryLoadException.message() + "]");
                throw stitchRepositoryLoadException;
            }
        }
        if (bl && (exception2 = failure.exception()) instanceof RepositoryCrawler.StitchRepositoryParseException) {
            RepositoryCrawler.StitchRepositoryParseException stitchRepositoryParseException = (RepositoryCrawler.StitchRepositoryParseException)((Object)exception2);
            throw stitchRepositoryParseException;
        }
        if (bl && (exception = failure.exception()) != null) {
            Throwable throwable = exception;
            logger.error("Validation errors found while indexing [" + throwable.getMessage() + "]");
            throw new RepositoryCrawler.StitchRepositoryLoadException(throwable, "Validation errors found while indexing [" + throwable.getMessage() + "]");
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            LazyList stream = (LazyList)success.value();
            return stream;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$parseProcessorParameters$1(StitchDefinitionDTO x$1) {
        return x$1.spec() != null;
    }

    public static final /* synthetic */ boolean $anonfun$parseProcessorParameters$3(RuleSpecDTO x$2) {
        return x$2.processor() != null;
    }

    public static final /* synthetic */ boolean $anonfun$parseProcessorParameters$5(ProcessorDTO x$3) {
        return x$3.parameters() != null;
    }

    public static final /* synthetic */ void $anonfun$parseProcessorParameters$4(DefaultRepositoryCrawler $this, SourceEntryAdapter entry$2, RuleSpecDTO spec) {
        spec.processor().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DefaultRepositoryCrawler.$anonfun$parseProcessorParameters$5(x$3))).foreach((Function1 & Serializable)proc -> {
            proc.parametersWithContent_$eq((Map<String, ParametersDTO>)((Map)proc.parameters().transform((Function2 & Serializable)(key, value) -> {
                if ($this.processorHandlerRegistry.fileNameParameterSupported((String)key)) {
                    String fileLocation = value.asText();
                    Path relativePath = Paths.get(fileLocation, new String[0]);
                    Path parentPath = Paths.get(entry$2.path(), new String[0]).getParent();
                    FolderSourceEntryAdapter fileAdapter = new FolderSourceEntryAdapter(((Object)parentPath.resolve(relativePath)).toString());
                    return (ParametersDTO)Using$.MODULE$.apply((Function0 & Serializable)() -> fileAdapter.read(), (Function1 & Serializable)x$1 -> IOUtils.toString((Reader)x$1), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).map((Function1 & Serializable)x$4 -> new ParametersDTO((JsonNode)value, fileLocation, (String)x$4)).recoverWith((PartialFunction)new Serializable(null, (String)key, fileLocation){
                        private static final long serialVersionUID = 0L;
                        private final String key$1;
                        private final String fileLocation$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof FileNotFoundException) {
                                throw RepositoryCrawler$StitchRepositoryLoadException$.MODULE$.apply("File for parameter [" + this.key$1 + "] with value [" + this.fileLocation$1 + "] could not be found!");
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            return throwable instanceof FileNotFoundException;
                        }
                        {
                            this.key$1 = key$1;
                            this.fileLocation$1 = fileLocation$1;
                        }
                    }).getOrElse((Function0 & Serializable)() -> {
                        throw RepositoryCrawler$StitchRepositoryLoadException$.MODULE$.apply("Cannot read file " + fileAdapter.path());
                    });
                }
                return new ParametersDTO((JsonNode)value, null, null);
            })));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$parseProcessorParameters$2(DefaultRepositoryCrawler $this, SourceEntryAdapter entry$2, StitchDefinitionDTO rule) {
        rule.spec().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DefaultRepositoryCrawler.$anonfun$parseProcessorParameters$3(x$2))).foreach((Function1 & Serializable)spec -> {
            DefaultRepositoryCrawler.$anonfun$parseProcessorParameters$4($this, entry$2, spec);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$crawl$4(ExecutionLogger logger$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            StitchDefinitionDTO dto = (StitchDefinitionDTO)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (dto.spec() != null && dto.spec().nonEmpty()) {
                logger$1.log(index + " -> For kind [" + dto.kind() + "] found [" + dto.spec().map((Function1 & Serializable)x$5 -> x$5.name()).mkString(", ") + "]");
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public DefaultRepositoryCrawler(ProcessorHandlerRegistry processorHandlerRegistry, ValidationService validationService) {
        this.processorHandlerRegistry = processorHandlerRegistry;
        this.validationService = validationService;
        Logging.$init$((Logging)this);
    }
}

