/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Objects;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.configuration.attributes.PropertiesAttributeSerializer;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class GlobalJmxConfiguration
extends GlobalJmxStatisticsConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)false).immutable().build();
    public static final AttributeDefinition<String> DOMAIN = AttributeDefinition.builder((Enum)Attribute.DOMAIN, (Object)"org.infinispan").immutable().build();
    public static final AttributeDefinition<MBeanServerLookup> MBEAN_SERVER_LOOKUP = AttributeDefinition.builder((Enum)Attribute.MBEAN_SERVER_LOOKUP, null, MBeanServerLookup.class).copier((AttributeCopier)IdentityAttributeCopier.identityCopier()).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
    public static final AttributeDefinition<TypedProperties> PROPERTIES = AttributeDefinition.builder((Enum)Element.PROPERTIES, null, TypedProperties.class).immutable().initializer(TypedProperties::new).serializer((AttributeSerializer)PropertiesAttributeSerializer.PROPERTIES).build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> enabled;
    private final org.infinispan.commons.configuration.attributes.Attribute<String> domain;
    private final org.infinispan.commons.configuration.attributes.Attribute<MBeanServerLookup> mBeanServerLookup;
    private final org.infinispan.commons.configuration.attributes.Attribute<TypedProperties> properties;
    private final String cacheManagerName;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalJmxConfiguration.class, new AttributeDefinition[]{ENABLED, DOMAIN, MBEAN_SERVER_LOOKUP, PROPERTIES});
    }

    GlobalJmxConfiguration(AttributeSet attributes, String cacheManagerName) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.domain = attributes.attribute(DOMAIN);
        this.mBeanServerLookup = attributes.attribute(MBEAN_SERVER_LOOKUP);
        this.properties = attributes.attribute(PROPERTIES);
        this.cacheManagerName = cacheManagerName;
    }

    @Override
    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    @Override
    public String domain() {
        return (String)this.domain.get();
    }

    @Override
    public TypedProperties properties() {
        return (TypedProperties)this.properties.get();
    }

    @Override
    @Deprecated
    public String cacheManagerName() {
        return this.cacheManagerName;
    }

    @Override
    public MBeanServerLookup mbeanServerLookup() {
        return (MBeanServerLookup)this.mBeanServerLookup.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalJmxConfiguration that = (GlobalJmxConfiguration)o;
        if (!Objects.equals(this.cacheManagerName, that.cacheManagerName)) {
            return false;
        }
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        int result = this.cacheManagerName != null ? this.cacheManagerName.hashCode() : 0;
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GlobalJmxConfiguration [cacheManagerName='" + this.cacheManagerName + "', attributes=" + this.attributes + "]";
    }
}

