/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.internal;

import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnErrorEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnSuccessEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnTimeoutEvent;
import io.github.resilience4j.timelimiter.internal.TimeLimiterEventProcessor;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeLimiterImpl
implements TimeLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(TimeLimiterImpl.class);
    private final String name;
    private final Map<String, String> tags;
    private final TimeLimiterConfig timeLimiterConfig;
    private final TimeLimiterEventProcessor eventProcessor;

    public TimeLimiterImpl(String name, TimeLimiterConfig timeLimiterConfig) {
        this(name, timeLimiterConfig, (Map<String, String>)HashMap.empty());
    }

    public TimeLimiterImpl(String name, TimeLimiterConfig timeLimiterConfig, Map<String, String> tags) {
        this.name = name;
        this.tags = Objects.requireNonNull(tags, "Tags must not be null");
        this.timeLimiterConfig = timeLimiterConfig;
        this.eventProcessor = new TimeLimiterEventProcessor();
    }

    @Override
    public <T, F extends Future<T>> Callable<T> decorateFutureSupplier(Supplier<F> futureSupplier) {
        return () -> {
            Future future = (Future)futureSupplier.get();
            try {
                Object result = future.get(this.getTimeLimiterConfig().getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS);
                this.onSuccess();
                return result;
            }
            catch (TimeoutException e) {
                TimeoutException timeoutException = TimeLimiter.createdTimeoutExceptionWithName(this.name, e);
                this.onError(timeoutException);
                if (this.getTimeLimiterConfig().shouldCancelRunningFuture()) {
                    future.cancel(true);
                }
                throw timeoutException;
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t == null) {
                    this.onError(e);
                    throw e;
                }
                this.onError(t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw (Exception)t;
            }
        };
    }

    @Override
    public <T, F extends CompletionStage<T>> Supplier<CompletionStage<T>> decorateCompletionStage(ScheduledExecutorService scheduler, Supplier<F> supplier) {
        return () -> {
            CompletableFuture future = ((CompletionStage)supplier.get()).toCompletableFuture();
            ScheduledFuture<?> timeoutFuture = Timeout.of(future, scheduler, this.name, this.getTimeLimiterConfig().getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS);
            return future.whenComplete((result, throwable) -> {
                if (result != null) {
                    if (!timeoutFuture.isDone()) {
                        timeoutFuture.cancel(false);
                    }
                    this.onSuccess();
                }
                if (throwable != null) {
                    if (throwable instanceof CompletionException) {
                        Throwable cause = throwable.getCause();
                        this.onError(cause);
                    } else if (throwable instanceof ExecutionException) {
                        Throwable cause = throwable.getCause();
                        if (cause == null) {
                            this.onError((Throwable)throwable);
                        } else {
                            this.onError(cause);
                        }
                    } else {
                        this.onError((Throwable)throwable);
                    }
                }
            });
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public TimeLimiterConfig getTimeLimiterConfig() {
        return this.timeLimiterConfig;
    }

    @Override
    public TimeLimiter.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    @Override
    public void onSuccess() {
        if (!this.eventProcessor.hasConsumers()) {
            return;
        }
        this.publishEvent(new TimeLimiterOnSuccessEvent(this.name));
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof TimeoutException) {
            this.onTimeout();
        } else {
            this.onFailure(throwable);
        }
    }

    private void onTimeout() {
        if (!this.eventProcessor.hasConsumers()) {
            return;
        }
        this.publishEvent(new TimeLimiterOnTimeoutEvent(this.name));
    }

    private void onFailure(Throwable throwable) {
        if (!this.eventProcessor.hasConsumers()) {
            return;
        }
        this.publishEvent(new TimeLimiterOnErrorEvent(this.name, throwable));
    }

    private void publishEvent(TimeLimiterEvent event) {
        try {
            this.eventProcessor.consumeEvent(event);
            LOG.debug("Event {} published: {}", (Object)event.getEventType(), (Object)event);
        }
        catch (Exception e) {
            LOG.warn("Failed to handle event {}", (Object)event.getEventType(), (Object)e);
        }
    }

    static final class Timeout {
        private Timeout() {
        }

        static ScheduledFuture<?> of(CompletableFuture<?> future, ScheduledExecutorService scheduler, String name, long delay, TimeUnit unit) {
            return scheduler.schedule(() -> {
                if (future != null && !future.isDone()) {
                    future.completeExceptionally(TimeLimiter.createdTimeoutExceptionWithName(name, null));
                }
            }, delay, unit);
        }
    }
}

