/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.parsing;

import akka.annotation.InternalApi;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.parsing.HttpMessageParser;
import akka.http.impl.engine.parsing.HttpMessageParser$;
import akka.http.impl.engine.parsing.HttpRequestParser$;
import akka.http.impl.engine.parsing.NotEnoughDataException$;
import akka.http.impl.engine.parsing.ParserOutput;
import akka.http.impl.engine.parsing.ParserOutput$NeedMoreData$;
import akka.http.impl.engine.parsing.ParserOutput$StreamEnd$;
import akka.http.impl.engine.parsing.ParsingException;
import akka.http.impl.engine.parsing.package$;
import akka.http.impl.engine.server.HttpAttributes;
import akka.http.impl.engine.ws.Handshake$Server$;
import akka.http.impl.engine.ws.UpgradeToWebSocketLowLevel;
import akka.http.impl.model.parser.CharacterClasses$;
import akka.http.impl.model.parser.UriParser;
import akka.http.impl.model.parser.UriParser$;
import akka.http.impl.util.ByteStringParserInput;
import akka.http.scaladsl.model.AttributeKeys$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.ErrorInfo$;
import akka.http.scaladsl.model.HttpCharsets$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.IllegalUriException;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.SslSessionInfo$;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.UniversalEntity;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.headers.Connection;
import akka.http.scaladsl.model.headers.Content$minusLength;
import akka.http.scaladsl.model.headers.Content$minusType;
import akka.http.scaladsl.model.headers.Raw$minusRequest$minusURI;
import akka.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import akka.http.scaladsl.settings.ParserSettings;
import akka.http.scaladsl.settings.WebSocketSettings;
import akka.parboiled2.ParserInput;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.FlowShape;
import akka.stream.FlowShape$;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.TLSProtocol;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import javax.net.ssl.SSLSession;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea!B\b\u0011\u0005YQ\u0002\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005%\")Q\u000b\u0001C\u0001-\"9A\f\u0001b\u0001\n\u0003i\u0006BB1\u0001A\u0003%a\fC\u0004c\u0001\t\u0007I\u0011A2\t\r\u001d\u0004\u0001\u0015!\u0003e\u0011\u001dA\u0007A1A\u0005\u0002%DaA\u001b\u0001!\u0002\u0013\u0019\u0003\"B6\u0001\t#b\u0007\"\u00029\u0001\t\u0003\n\b\"B<\u0001\t\u0003B(!\u0005%uiB\u0014V-];fgR\u0004\u0016M]:fe*\u0011\u0011CE\u0001\ba\u0006\u00148/\u001b8h\u0015\t\u0019B#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003+Y\tA![7qY*\u0011q\u0003G\u0001\u0005QR$\bOC\u0001\u001a\u0003\u0011\t7n[1\u0014\u0005\u0001Y\u0002c\u0001\u000f\"G5\tQD\u0003\u0002\u001f?\u0005)1\u000f^1hK*\u0011\u0001\u0005G\u0001\u0007gR\u0014X-Y7\n\u0005\tj\"AC$sCBD7\u000b^1hKB!A%J\u00147\u001b\u0005y\u0012B\u0001\u0014 \u0005%1En\\<TQ\u0006\u0004X\r\u0005\u0002)g9\u0011\u0011&\r\b\u0003UAr!aK\u0018\u000e\u00031R!!\f\u0018\u0002\rq\u0012xn\u001c;?\u0007\u0001I\u0011!G\u0005\u0003AaI!AM\u0010\u0002\u0017Qc5\u000b\u0015:pi>\u001cw\u000e\\\u0005\u0003iU\u0012AbU3tg&|gNQ=uKNT!AM\u0010\u0011\u0005]ZdB\u0001\u001d:\u001b\u0005\u0001\u0012B\u0001\u001e\u0011\u00031\u0001\u0016M]:fe>+H\u000f];u\u0013\taTHA\u0007SKF,Xm\u001d;PkR\u0004X\u000f\u001e\u0006\u0003uA\t\u0001b]3ui&twm\u001d\t\u0003\u0001\u0012k\u0011!\u0011\u0006\u0003}\tS!a\u0011\f\u0002\u0011M\u001c\u0017\r\\1eg2L!!R!\u0003\u001dA\u000b'o]3s'\u0016$H/\u001b8hg\u0006\tr/\u001a2t_\u000e\\W\r^*fiRLgnZ:\u0011\u0005\u0001C\u0015BA%B\u0005E9VMY*pG.,GoU3ui&twm]\u0001\u0014e\u0006<(+Z9vKN$XK]5IK\u0006$WM\u001d\t\u0003\u0019>k\u0011!\u0014\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+\u0014\u0002\b\u0005>|G.Z1o\u00031AW-\u00193feB\u000b'o]3s!\tA4+\u0003\u0002U!\t\u0001\u0002\n\u001e;q\u0011\u0016\fG-\u001a:QCJ\u001cXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b]C\u0016LW.\u0011\u0005a\u0002\u0001\"\u0002 \u0006\u0001\u0004y\u0004\"\u0002$\u0006\u0001\u00049\u0005\"\u0002&\u0006\u0001\u0004Y\u0005\"B)\u0006\u0001\u0004\u0011\u0016AA5o+\u0005q\u0006c\u0001\u0013`O%\u0011\u0001m\b\u0002\u0006\u0013:dW\r^\u0001\u0004S:\u0004\u0013aA8viV\tA\rE\u0002%KZJ!AZ\u0010\u0003\r=+H\u000f\\3u\u0003\u0011yW\u000f\u001e\u0011\u0002\u000bMD\u0017\r]3\u0016\u0003\r\naa\u001d5ba\u0016\u0004\u0013!E5oSRL\u0017\r\\!uiJL'-\u001e;fgV\tQ\u000e\u0005\u0002%]&\u0011qn\b\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\u0018aC2sK\u0006$X\rT8hS\u000e$\"A];\u0011\u0005q\u0019\u0018B\u0001;\u001e\u0005=9%/\u00199i'R\fw-\u001a'pO&\u001c\u0007\"\u0002<\u000e\u0001\u0004i\u0017aE5oQ\u0016\u0014\u0018\u000e^3e\u0003R$(/\u001b2vi\u0016\u001c\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003e\u0004\"A\u001f@\u000f\u0005md\bCA\u0016N\u0013\tiX*\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!AB*ue&twM\u0003\u0002~\u001b\"\u001a\u0001!!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\tIAA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public final class HttpRequestParser
extends GraphStage<FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput>> {
    public final ParserSettings akka$http$impl$engine$parsing$HttpRequestParser$$settings;
    public final WebSocketSettings akka$http$impl$engine$parsing$HttpRequestParser$$websocketSettings;
    public final boolean akka$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader;
    public final HttpHeaderParser akka$http$impl$engine$parsing$HttpRequestParser$$headerParser;
    private final Inlet<TLSProtocol.SessionBytes> in;
    private final Outlet<ParserOutput.RequestOutput> out;
    private final FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput> shape;

    public Inlet<TLSProtocol.SessionBytes> in() {
        return this.in;
    }

    public Outlet<ParserOutput.RequestOutput> out() {
        return this.out;
    }

    public FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput> shape() {
        return this.shape;
    }

    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("HttpRequestParser");
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new HttpMessageParser<ParserOutput.RequestOutput>(this, inheritedAttributes){
            private final ParserSettings settings;
            private final HttpHeaderParser headerParser;
            private final boolean isResponseParser;
            private HttpMethod method;
            private Uri uri;
            private ByteString uriBytes;
            private final UriParser uriParser;
            private Object akka$http$impl$engine$parsing$HttpMessageParser$$result;
            private Function1<ByteString, HttpMessageParser.StateResult> akka$http$impl$engine$parsing$HttpMessageParser$$state;
            private HttpProtocol akka$http$impl$engine$parsing$HttpMessageParser$$protocol;
            private Function0<Option<ParserOutput.ErrorOutput>> completionHandling;
            private boolean terminated;
            private SSLSession akka$http$impl$engine$parsing$HttpMessageParser$$lastSession;
            private Tls$minusSession$minusInfo akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
            private final /* synthetic */ HttpRequestParser $outer;
            private final Attributes inheritedAttributes$1;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            public final ListBuffer<HttpHeader> initialHeaderBuffer() {
                return HttpMessageParser.initialHeaderBuffer$(this);
            }

            public final ParserOutput parseSessionBytes(TLSProtocol.SessionBytes input) {
                return HttpMessageParser.parseSessionBytes$(this, input);
            }

            public final ParserOutput parseBytes(ByteString input) {
                return HttpMessageParser.parseBytes$(this, input);
            }

            public final ParserOutput doPull() {
                return HttpMessageParser.doPull$(this);
            }

            public final boolean shouldComplete() {
                return HttpMessageParser.shouldComplete$(this);
            }

            public final HttpMessageParser.StateResult startNewMessage(ByteString input, int offset) {
                return HttpMessageParser.startNewMessage$(this, input, offset);
            }

            public final int parseProtocol(ByteString input, int cursor) {
                return HttpMessageParser.parseProtocol$(this, input, cursor);
            }

            public final HttpMessageParser.StateResult parseHeaderLines(ByteString input, int lineStart, ListBuffer<HttpHeader> headers2, int headerCount, Option<Connection> ch, Option<Content$minusLength> clh, Option<Content$minusType> cth, boolean isChunked, boolean e100c, boolean hh) {
                return HttpMessageParser.parseHeaderLines$(this, input, lineStart, headers2, headerCount, ch, clh, cth, isChunked, e100c, hh);
            }

            public final HttpMessageParser.StateResult parseFixedLengthBody(long remainingBodyBytes, boolean isLastMessage, ByteString input, int bodyStart) {
                return HttpMessageParser.parseFixedLengthBody$(this, remainingBodyBytes, isLastMessage, input, bodyStart);
            }

            public final HttpMessageParser.StateResult parseChunk(ByteString input, int offset, boolean isLastMessage, long totalBytesRead) {
                return HttpMessageParser.parseChunk$(this, input, offset, isLastMessage, totalBytesRead);
            }

            public void emit(ParserOutput output) {
                HttpMessageParser.emit$(this, output);
            }

            public final HttpMessageParser.StateResult continue(ByteString input, int offset, Function2<ByteString, Object, HttpMessageParser.StateResult> next) {
                return HttpMessageParser.continue$(this, input, offset, next);
            }

            public final HttpMessageParser.StateResult continue(Function2<ByteString, Object, HttpMessageParser.StateResult> next) {
                return HttpMessageParser.continue$(this, next);
            }

            public final HttpMessageParser.StateResult failMessageStart(String summary) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, summary);
            }

            public final HttpMessageParser.StateResult failMessageStart(String summary, String detail) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, summary, detail);
            }

            public final HttpMessageParser.StateResult failMessageStart(StatusCode status) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, status);
            }

            public final HttpMessageParser.StateResult failMessageStart(StatusCode status, String summary, String detail) {
                return HttpMessageParser.failMessageStart$(this, status, summary, detail);
            }

            public final String failMessageStart$default$3() {
                return HttpMessageParser.failMessageStart$default$3$(this);
            }

            public final HttpMessageParser.StateResult failMessageStart(StatusCode status, ErrorInfo info) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, status, info);
            }

            public final HttpMessageParser.StateResult failEntityStream(String summary) {
                return HttpMessageParser.failEntityStream$((HttpMessageParser)this, summary);
            }

            public final HttpMessageParser.StateResult failEntityStream(String summary, String detail) {
                return HttpMessageParser.failEntityStream$(this, summary, detail);
            }

            public final HttpMessageParser.StateResult failEntityStream(ErrorInfo info) {
                return HttpMessageParser.failEntityStream$((HttpMessageParser)this, info);
            }

            public final HttpMessageParser.StateResult terminate() {
                return HttpMessageParser.terminate$(this);
            }

            public final ContentType contentType(Option<Content$minusType> cth) {
                return HttpMessageParser.contentType$(this, cth);
            }

            public final ParserOutput.StrictEntityCreator<ParserOutput.RequestOutput, UniversalEntity> emptyEntity(Option<Content$minusType> cth) {
                return HttpMessageParser.emptyEntity$(this, cth);
            }

            public final ParserOutput.StrictEntityCreator<ParserOutput.RequestOutput, UniversalEntity> strictEntity(Option<Content$minusType> cth, ByteString input, int bodyStart, int contentLength) {
                return HttpMessageParser.strictEntity$(this, cth, input, bodyStart, contentLength);
            }

            public final <A extends ParserOutput> ParserOutput.StreamedEntityCreator<A, UniversalEntity> defaultEntity(Option<Content$minusType> cth, long contentLength) {
                return HttpMessageParser.defaultEntity$(this, cth, contentLength);
            }

            public final <A extends ParserOutput> ParserOutput.StreamedEntityCreator<A, RequestEntity> chunkedEntity(Option<Content$minusType> cth) {
                return HttpMessageParser.chunkedEntity$(this, cth);
            }

            public final void setCompletionHandling(Function0<Option<ParserOutput.ErrorOutput>> completionHandling) {
                HttpMessageParser.setCompletionHandling$(this, completionHandling);
            }

            public final ListBuffer<HttpHeader> parseHeaderLines$default$3() {
                return HttpMessageParser.parseHeaderLines$default$3$(this);
            }

            public final int parseHeaderLines$default$4() {
                return HttpMessageParser.parseHeaderLines$default$4$(this);
            }

            public final Option<Connection> parseHeaderLines$default$5() {
                return HttpMessageParser.parseHeaderLines$default$5$(this);
            }

            public final Option<Content$minusLength> parseHeaderLines$default$6() {
                return HttpMessageParser.parseHeaderLines$default$6$(this);
            }

            public final Option<Content$minusType> parseHeaderLines$default$7() {
                return HttpMessageParser.parseHeaderLines$default$7$(this);
            }

            public final boolean parseHeaderLines$default$8() {
                return HttpMessageParser.parseHeaderLines$default$8$(this);
            }

            public final boolean parseHeaderLines$default$9() {
                return HttpMessageParser.parseHeaderLines$default$9$(this);
            }

            public final boolean parseHeaderLines$default$10() {
                return HttpMessageParser.parseHeaderLines$default$10$(this);
            }

            public Object akka$http$impl$engine$parsing$HttpMessageParser$$result() {
                return this.akka$http$impl$engine$parsing$HttpMessageParser$$result;
            }

            public void akka$http$impl$engine$parsing$HttpMessageParser$$result_$eq(Object x$1) {
                this.akka$http$impl$engine$parsing$HttpMessageParser$$result = x$1;
            }

            public Function1<ByteString, HttpMessageParser.StateResult> akka$http$impl$engine$parsing$HttpMessageParser$$state() {
                return this.akka$http$impl$engine$parsing$HttpMessageParser$$state;
            }

            public void akka$http$impl$engine$parsing$HttpMessageParser$$state_$eq(Function1<ByteString, HttpMessageParser.StateResult> x$1) {
                this.akka$http$impl$engine$parsing$HttpMessageParser$$state = x$1;
            }

            public HttpProtocol akka$http$impl$engine$parsing$HttpMessageParser$$protocol() {
                return this.akka$http$impl$engine$parsing$HttpMessageParser$$protocol;
            }

            public void akka$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(HttpProtocol x$1) {
                this.akka$http$impl$engine$parsing$HttpMessageParser$$protocol = x$1;
            }

            public Function0<Option<ParserOutput.ErrorOutput>> completionHandling() {
                return this.completionHandling;
            }

            public void completionHandling_$eq(Function0<Option<ParserOutput.ErrorOutput>> x$1) {
                this.completionHandling = x$1;
            }

            public boolean terminated() {
                return this.terminated;
            }

            public void terminated_$eq(boolean x$1) {
                this.terminated = x$1;
            }

            public SSLSession akka$http$impl$engine$parsing$HttpMessageParser$$lastSession() {
                return this.akka$http$impl$engine$parsing$HttpMessageParser$$lastSession;
            }

            public void akka$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(SSLSession x$1) {
                this.akka$http$impl$engine$parsing$HttpMessageParser$$lastSession = x$1;
            }

            public Tls$minusSession$minusInfo akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader() {
                return this.akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
            }

            public void akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(Tls$minusSession$minusInfo x$1) {
                this.akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader = x$1;
            }

            public ParserSettings settings() {
                return this.settings;
            }

            public HttpHeaderParser headerParser() {
                return this.headerParser;
            }

            public boolean isResponseParser() {
                return this.isResponseParser;
            }

            public void onPush() {
                this.handleParserOutput((ParserOutput.RequestOutput)this.parseSessionBytes((TLSProtocol.SessionBytes)this.grab(this.$outer.in())));
            }

            public void onPull() {
                this.handleParserOutput((ParserOutput.RequestOutput)this.doPull());
            }

            public void onUpstreamFinish() {
                if (HttpMessageParser.shouldComplete$(this)) {
                    this.completeStage();
                    return;
                }
                if (this.isAvailable(this.$outer.out())) {
                    this.handleParserOutput((ParserOutput.RequestOutput)this.doPull());
                    return;
                }
            }

            private void handleParserOutput(ParserOutput.RequestOutput output) {
                ParserOutput.RequestOutput requestOutput = output;
                if (ParserOutput$StreamEnd$.MODULE$.equals(requestOutput)) {
                    this.completeStage();
                    return;
                }
                if (ParserOutput$NeedMoreData$.MODULE$.equals(requestOutput)) {
                    this.pull(this.$outer.in());
                    return;
                }
                this.push(this.$outer.out(), requestOutput);
            }

            public HttpMessageParser.StateResult parseMessage(ByteString input2, int offset2) {
                if (offset2 < input2.length()) {
                    int cursor = this.parseMethod(input2, offset2);
                    cursor = this.parseRequestTarget(input2, cursor);
                    if (package$.MODULE$.byteChar(input2, cursor = this.parseProtocol(input2, cursor)) == '\r' && package$.MODULE$.byteChar(input2, cursor + 1) == '\n') {
                        return this.parseHeaderLines(input2, cursor + 2, this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5(), this.parseHeaderLines$default$6(), this.parseHeaderLines$default$7(), this.parseHeaderLines$default$8(), this.parseHeaderLines$default$9(), this.parseHeaderLines$default$10());
                    }
                    if (package$.MODULE$.byteChar(input2, cursor) == '\n') {
                        return this.parseHeaderLines(input2, cursor + 1, this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5(), this.parseHeaderLines$default$6(), this.parseHeaderLines$default$7(), this.parseHeaderLines$default$8(), this.parseHeaderLines$default$9(), this.parseHeaderLines$default$10());
                    }
                    throw this.onBadProtocol(input2.drop(cursor));
                }
                return this.continue((Function2<ByteString, Object, HttpMessageParser.StateResult>)(Function2 & Serializable)(input, offset) -> $anon$1.$anonfun$parseMessage$1(this, input, BoxesRunTime.unboxToInt((Object)offset)));
            }

            private int parseMethod(ByteString input, int cursor) {
                char c = package$.MODULE$.byteChar(input, cursor);
                switch (c) {
                    case 'G': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.GET(), $anon$1.parseMethod$default$2$1(), input, cursor);
                    }
                    case 'P': {
                        char c2 = package$.MODULE$.byteChar(input, cursor + 1);
                        switch (c2) {
                            case 'O': {
                                return this.parseMethod$1(HttpMethods$.MODULE$.POST(), 2, input, cursor);
                            }
                            case 'U': {
                                return this.parseMethod$1(HttpMethods$.MODULE$.PUT(), 2, input, cursor);
                            }
                            case 'A': {
                                return this.parseMethod$1(HttpMethods$.MODULE$.PATCH(), 2, input, cursor);
                            }
                        }
                        return this.parseCustomMethod$1($anon$1.parseCustomMethod$default$1$1(), $anon$1.parseCustomMethod$default$2$1(), input, cursor);
                    }
                    case 'D': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.DELETE(), $anon$1.parseMethod$default$2$1(), input, cursor);
                    }
                    case 'H': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.HEAD(), $anon$1.parseMethod$default$2$1(), input, cursor);
                    }
                    case 'O': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.OPTIONS(), $anon$1.parseMethod$default$2$1(), input, cursor);
                    }
                    case 'T': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.TRACE(), $anon$1.parseMethod$default$2$1(), input, cursor);
                    }
                    case 'C': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.CONNECT(), $anon$1.parseMethod$default$2$1(), input, cursor);
                    }
                    case '\u0016': {
                        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), ErrorInfo$.MODULE$.apply("Unsupported HTTP method", new StringBuilder(128).append("The HTTP method started with 0x16 rather than any known HTTP method").append(this.remoteAddressStr()).append(". ").append("Perhaps this was an HTTPS request sent to an HTTP endpoint?").toString()));
                    }
                }
                return this.parseCustomMethod$1($anon$1.parseCustomMethod$default$1$1(), $anon$1.parseCustomMethod$default$2$1(), input, cursor);
            }

            private UriParser uriParser() {
                return this.uriParser;
            }

            private int parseRequestTarget(ByteString input, int cursor) {
                int uriStart = cursor;
                int uriEndLimit = cursor + this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings.maxUriLength();
                int uriEnd = this.findUriEnd$1($anon$1.findUriEnd$default$1$1(cursor), input, uriEndLimit);
                try {
                    this.uriBytes = input.slice(uriStart, uriEnd);
                    this.uriParser().reset((ParserInput)new ByteStringParserInput(this.uriBytes));
                    this.uri = this.uriParser().parseHttpRequestTarget();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof IllegalUriException) {
                        IllegalUriException illegalUriException = (IllegalUriException)throwable2;
                        ErrorInfo info = illegalUriException.info();
                        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), info);
                    }
                    throw throwable;
                }
                return uriEnd + 1;
            }

            public Nothing$ onBadProtocol(ByteString input) {
                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.HttpVersionNotSupported(), "");
            }

            public HttpMessageParser.StateResult parseEntity(List<HttpHeader> headers2, HttpProtocol protocol, ByteString input, int bodyStart, Option<Content$minusLength> clh, Option<Content$minusType> cth, boolean isChunked, boolean expect100continue, boolean hostHeaderPresent, boolean closeAfterResponseCompletion, SSLSession sslSession) {
                block14: {
                    block13: {
                        if (hostHeaderPresent) break block13;
                        HttpProtocol httpProtocol = protocol;
                        HttpProtocol httpProtocol2 = HttpProtocols$.MODULE$.HTTP$div1$u002E0();
                        if (httpProtocol != null ? !((Object)httpProtocol).equals(httpProtocol2) : httpProtocol2 != null) break block14;
                    }
                    if (!isChunked) {
                        long l;
                        Some some;
                        Content$minusLength content$minusLength;
                        Option<Content$minusLength> option = clh;
                        if (option instanceof Some && (content$minusLength = (Content$minusLength)(some = (Some)option).value()) != null) {
                            long len;
                            l = len = content$minusLength.length();
                        } else if (None$.MODULE$.equals(option)) {
                            l = 0L;
                        } else {
                            throw new MatchError(option);
                        }
                        long contentLength = l;
                        if (contentLength == 0L) {
                            this.emitRequestStart$1(this.emptyEntity(cth), $anon$1.emitRequestStart$default$2$1(headers2), sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion);
                            this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
                            return this.startNewMessage(input, bodyStart);
                        }
                        if (!this.method.isEntityAccepted()) {
                            return this.failMessageStart(StatusCodes$.MODULE$.UnprocessableContent(), new StringBuilder(33).append(this.method.name()).append(" requests must not have an entity").toString(), this.failMessageStart$default$3());
                        }
                        if (contentLength <= (long)(input.size() - bodyStart)) {
                            int cl = (int)contentLength;
                            this.emitRequestStart$1(this.strictEntity(cth, input, bodyStart, cl), $anon$1.emitRequestStart$default$2$1(headers2), sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion);
                            this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
                            return this.startNewMessage(input, bodyStart + cl);
                        }
                        this.emitRequestStart$1(this.defaultEntity(cth, contentLength), $anon$1.emitRequestStart$default$2$1(headers2), sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion);
                        return this.parseFixedLengthBody(contentLength, closeAfterResponseCompletion, input, bodyStart);
                    }
                    if (!this.method.isEntityAccepted()) {
                        return this.failMessageStart(StatusCodes$.MODULE$.UnprocessableContent(), new StringBuilder(33).append(this.method.name()).append(" requests must not have an entity").toString(), this.failMessageStart$default$3());
                    }
                    if (clh.isEmpty()) {
                        this.emitRequestStart$1(this.chunkedEntity(cth), headers2, sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion);
                        return this.parseChunk(input, bodyStart, closeAfterResponseCompletion, 0L);
                    }
                    return this.failMessageStart("A chunked request must not contain a Content-Length header");
                }
                return this.failMessageStart("Request is missing required `Host` header");
            }

            private String remoteAddressStr() {
                Option option = this.inheritedAttributes$1.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map((Function1 & Serializable)x$4 -> x$4.address());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    InetSocketAddress addr = (InetSocketAddress)some.value();
                    return new StringBuilder(7).append(" from ").append(addr.getHostString()).append(":").append(addr.getPort()).toString();
                }
                if (None$.MODULE$.equals(option)) {
                    return "";
                }
                throw new MatchError((Object)option);
            }

            public static final /* synthetic */ HttpMessageParser.StateResult $anonfun$parseMessage$1($anon$1 $this, ByteString input, int offset) {
                return $this.startNewMessage(input, offset);
            }

            private final int parseCustomMethod$1(int ix, StringBuilder sb, ByteString input$1, int cursor$1) {
                while (ix < this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings.maxMethodLength()) {
                    char c = package$.MODULE$.byteChar(input$1, cursor$1 + ix);
                    switch (c) {
                        case ' ': {
                            Option option = (Option)this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings.customMethods().apply((Object)sb.toString());
                            if (option instanceof Some) {
                                HttpMethod m;
                                Some some = (Some)option;
                                this.method = m = (HttpMethod)some.value();
                                return cursor$1 + ix + 1;
                            }
                            if (None$.MODULE$.equals(option)) {
                                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.NotImplemented(), ErrorInfo$.MODULE$.apply("Unsupported HTTP method", sb.toString()));
                            }
                            throw new MatchError((Object)option);
                        }
                    }
                    sb = sb.append(c);
                    ++ix;
                }
                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), ErrorInfo$.MODULE$.apply("Unsupported HTTP method", new StringBuilder(139).append("HTTP method too long (started with '").append(sb.toString()).append("')").append(this.remoteAddressStr()).append(". ").append("Increase `akka.http.server.parsing.max-method-length` to support HTTP methods with more characters.").toString()));
            }

            private static final int parseCustomMethod$default$1$1() {
                return 0;
            }

            private static final StringBuilder parseCustomMethod$default$2$1() {
                return new StringBuilder(16);
            }

            private final int parseMethod$1(HttpMethod meth, int ix, ByteString input$1, int cursor$1) {
                while (true) {
                    if (ix == meth.value().length()) {
                        if (package$.MODULE$.byteChar(input$1, cursor$1 + ix) == ' ') {
                            this.method = meth;
                            return cursor$1 + ix + 1;
                        }
                        return this.parseCustomMethod$1($anon$1.parseCustomMethod$default$1$1(), $anon$1.parseCustomMethod$default$2$1(), input$1, cursor$1);
                    }
                    if (package$.MODULE$.byteChar(input$1, cursor$1 + ix) != meth.value().charAt(ix)) break;
                    ++ix;
                }
                return this.parseCustomMethod$1($anon$1.parseCustomMethod$default$1$1(), $anon$1.parseCustomMethod$default$2$1(), input$1, cursor$1);
            }

            private static final int parseMethod$default$2$1() {
                return 1;
            }

            private final int findUriEnd$1(int ix, ByteString input$2, int uriEndLimit$1) {
                while (true) {
                    if (ix == input$2.length()) {
                        throw NotEnoughDataException$.MODULE$;
                    }
                    if (CharacterClasses$.MODULE$.WSPCRLF().apply((char)input$2.apply(ix))) {
                        return ix;
                    }
                    if (ix >= uriEndLimit$1) break;
                    ++ix;
                }
                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.UriTooLong(), new StringBuilder(54).append("URI length exceeds the configured limit of ").append(this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings.maxUriLength()).append(" characters").append(this.remoteAddressStr()).toString());
            }

            private static final int findUriEnd$default$1$1(int cursor$2) {
                return cursor$2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final void emitRequestStart$1(ParserOutput.EntityCreator createEntity, List headers2, SSLSession sslSession$1, boolean hostHeaderPresent$1, HttpProtocol protocol$1, boolean expect100continue$1, boolean closeAfterResponseCompletion$1) {
                ParserOutput.RequestStart requestStart;
                List list;
                if (this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader) {
                    Raw$minusRequest$minusURI raw$minusRequest$minusURI = new Raw$minusRequest$minusURI(this.uriBytes.decodeString(HttpCharsets$.MODULE$.US$minusASCII().nioCharset()));
                    list = headers2.$colon$colon((Object)raw$minusRequest$minusURI);
                } else {
                    list = headers2;
                }
                List allHeaders0 = list;
                Map attributes = this.settings().includeSslSessionAttribute() ? (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(AttributeKeys$.MODULE$.sslSession()), (Object)SslSessionInfo$.MODULE$.apply(sslSession$1))})) : Predef$.MODULE$.Map().empty();
                HttpMethod httpMethod = this.method;
                HttpMethod httpMethod2 = HttpMethods$.MODULE$.GET();
                if (!(httpMethod != null ? !((Object)httpMethod).equals(httpMethod2) : httpMethod2 != null)) {
                    UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel = Handshake$Server$.MODULE$.websocketUpgrade((List<HttpHeader>)headers2, hostHeaderPresent$1, this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$websocketSettings, this.headerParser().log());
                    UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel2 = (UpgradeToWebSocketLowLevel)OptionVal.Some$.MODULE$.unapply((Object)upgradeToWebSocketLowLevel);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)upgradeToWebSocketLowLevel2)) {
                        UpgradeToWebSocketLowLevel upgrade;
                        UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel3 = upgrade = (UpgradeToWebSocketLowLevel)OptionVal$.MODULE$.get$extension((Object)upgradeToWebSocketLowLevel2);
                        ParserOutput.RequestStart requestStart2 = new ParserOutput.RequestStart(this.method, this.uri, protocol$1, (Map)attributes.updated(AttributeKeys$.MODULE$.webSocketUpgrade(), (Object)upgrade), (List<HttpHeader>)allHeaders0.$colon$colon((Object)upgradeToWebSocketLowLevel3), createEntity, expect100continue$1, closeAfterResponseCompletion$1);
                        requestStart = requestStart2;
                    } else {
                        OptionVal$.MODULE$.None();
                        UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel4 = upgradeToWebSocketLowLevel;
                        if (null != null ? !((Object)null).equals(upgradeToWebSocketLowLevel4) : upgradeToWebSocketLowLevel4 != null) throw new MatchError((Object)new OptionVal((Object)upgradeToWebSocketLowLevel));
                        requestStart = new ParserOutput.RequestStart(this.method, this.uri, protocol$1, attributes, (List<HttpHeader>)allHeaders0, createEntity, expect100continue$1, closeAfterResponseCompletion$1);
                    }
                } else {
                    requestStart = new ParserOutput.RequestStart(this.method, this.uri, protocol$1, attributes, (List<HttpHeader>)allHeaders0, createEntity, expect100continue$1, closeAfterResponseCompletion$1);
                }
                ParserOutput.RequestStart requestStart3 = requestStart;
                this.emit(requestStart3);
            }

            private static final List emitRequestStart$default$2$1(List headers$1) {
                return headers$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inheritedAttributes$1 = inheritedAttributes$1;
                super($outer.shape());
                HttpMessageParser.$init$(this);
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                this.settings = $outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings;
                this.headerParser = $outer.akka$http$impl$engine$parsing$HttpRequestParser$$headerParser.createShallowCopy();
                this.isResponseParser = false;
                this.setHandlers($outer.in(), $outer.out(), this);
                ParserInput x$1 = null;
                Uri.ParsingMode x$2 = $outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings.uriParsingMode();
                Charset x$3 = UriParser$.MODULE$.$lessinit$greater$default$2();
                this.uriParser = new UriParser(x$1, x$3, x$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$parseMessage$1$adapted(akka.http.impl.engine.parsing.HttpRequestParser$$anon$1 akka.util.ByteString java.lang.Object ), $anonfun$remoteAddressStr$1(akka.http.impl.engine.server.HttpAttributes$RemoteAddress )}, serializedLambda);
            }
        };
    }

    public String toString() {
        return "HttpRequestParser";
    }

    public HttpRequestParser(ParserSettings settings, WebSocketSettings websocketSettings, boolean rawRequestUriHeader, HttpHeaderParser headerParser) {
        this.akka$http$impl$engine$parsing$HttpRequestParser$$settings = settings;
        this.akka$http$impl$engine$parsing$HttpRequestParser$$websocketSettings = websocketSettings;
        this.akka$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader = rawRequestUriHeader;
        this.akka$http$impl$engine$parsing$HttpRequestParser$$headerParser = headerParser;
        this.in = Inlet$.MODULE$.apply("HttpRequestParser.in");
        this.out = Outlet$.MODULE$.apply("HttpRequestParser.out");
        this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
    }
}

