/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.annotation.InternalApi;
import akka.http.impl.engine.ws.StreamingCharsetDecoder;
import akka.http.impl.engine.ws.StreamingCharsetDecoderInstance;
import akka.util.ByteString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.collection.mutable.StringBuilder;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Try;
import scala.util.Try$;

@InternalApi
public final class Utf8Decoder$
implements StreamingCharsetDecoder {
    public static final Utf8Decoder$ MODULE$ = new Utf8Decoder$();
    public static final int akka$http$impl$engine$ws$Utf8Decoder$$Utf8Accept;
    public static final int akka$http$impl$engine$ws$Utf8Decoder$$Utf8Reject;
    private static final byte[] characterClasses;
    private static final byte[] states;

    static {
        StreamingCharsetDecoder.$init$(MODULE$);
        akka$http$impl$engine$ws$Utf8Decoder$$Utf8Accept = 0;
        akka$http$impl$engine$ws$Utf8Decoder$$Utf8Reject = 12;
        characterClasses = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
        states = new byte[]{0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    }

    @Override
    public Try<String> decode(ByteString bytes) {
        return StreamingCharsetDecoder.decode$(this, bytes);
    }

    public byte[] characterClasses() {
        return characterClasses;
    }

    public byte[] states() {
        return states;
    }

    @Override
    public StreamingCharsetDecoderInstance create() {
        return new StreamingCharsetDecoderInstance(){
            private int currentCodePoint;
            private int currentState;

            private int currentCodePoint() {
                return this.currentCodePoint;
            }

            private void currentCodePoint_$eq(int x$1) {
                this.currentCodePoint = x$1;
            }

            private int currentState() {
                return this.currentState;
            }

            private void currentState_$eq(int x$1) {
                this.currentState = x$1;
            }

            public Try<String> decode(ByteString bytes, boolean endOfInput) {
                return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    StringBuilder result = new StringBuilder(bytes.size());
                    int length = bytes.size();
                    for (int offset = 0; offset < length; ++offset) {
                        this.step$1(bytes.apply(offset) & 0xFF, result);
                    }
                    if (endOfInput && this.currentState() != Utf8Decoder$.akka$http$impl$engine$ws$Utf8Decoder$$Utf8Accept) {
                        throw this.fail("Truncated UTF-8 input");
                    }
                    return result.toString();
                });
            }

            private Nothing$ fail(String msg) {
                throw new IllegalArgumentException(msg);
            }

            private final void step$1(int n, StringBuilder result$1) {
                byte chClass = Utf8Decoder$.MODULE$.characterClasses()[n];
                this.currentCodePoint_$eq(this.currentState() == Utf8Decoder$.akka$http$impl$engine$ws$Utf8Decoder$$Utf8Accept ? 255 >> chClass & n : 0x3F & n | this.currentCodePoint() << 6);
                this.currentState_$eq(Utf8Decoder$.MODULE$.states()[this.currentState() + chClass]);
                int n2 = this.currentState();
                if (Utf8Decoder$.akka$http$impl$engine$ws$Utf8Decoder$$Utf8Accept == n2) {
                    if (this.currentCodePoint() <= 65535) {
                        result$1.append((char)this.currentCodePoint());
                        return;
                    }
                    result$1.append((char)(55232 + (this.currentCodePoint() >> 10)));
                    result$1.append((char)(56320 + (this.currentCodePoint() & 0x3FF)));
                    return;
                }
                if (Utf8Decoder$.akka$http$impl$engine$ws$Utf8Decoder$$Utf8Reject == n2) {
                    throw this.fail("Invalid UTF-8 input");
                }
            }
            {
                this.currentCodePoint = 0;
                this.currentState = Utf8Decoder$.akka$http$impl$engine$ws$Utf8Decoder$$Utf8Accept;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decode$1(akka.http.impl.engine.ws.Utf8Decoder$$anon$1 akka.util.ByteString boolean )}, serializedLambda);
            }
        };
    }

    private Utf8Decoder$() {
    }
}

