/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.text;

import java.io.Serializable;
import java.util.Objects;

public final class DiffRow
implements Serializable {
    private Tag tag;
    private final String oldLine;
    private final String newLine;

    public DiffRow(Tag tag, String oldLine, String newLine) {
        this.tag = tag;
        this.oldLine = oldLine;
        this.newLine = newLine;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public String getOldLine() {
        return this.oldLine;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.newLine, this.oldLine, this.tag});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiffRow other = (DiffRow)obj;
        if (this.newLine == null ? other.newLine != null : !this.newLine.equals(other.newLine)) {
            return false;
        }
        if (this.oldLine == null ? other.oldLine != null : !this.oldLine.equals(other.oldLine)) {
            return false;
        }
        return !(this.tag == null ? other.tag != null : !this.tag.equals((Object)other.tag));
    }

    public String toString() {
        return "[" + (Object)((Object)this.tag) + "," + this.oldLine + "," + this.newLine + "]";
    }

    public static enum Tag {
        INSERT,
        DELETE,
        CHANGE,
        EQUAL;

    }
}

