/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2;

import akka.annotation.InternalApi;
import akka.http.impl.engine.http2.GenericOutlet;
import akka.stream.stage.OutHandler;
import java.io.Serializable;
import java.util.ArrayDeque;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a4QAD\b\u0001\u001feA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006u\u0001!\ta\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001a\u0001\n\u0003Q\u0005b\u0002(\u0001\u0001\u0004%\ta\u0014\u0005\u0007+\u0002\u0001\u000b\u0015B&\t\u000bY\u0003A\u0011C,\t\u000bi\u0003A\u0011A.\t\u000bq\u0003A\u0011A/\t\u000b}\u0003A\u0011A.\t\u000b\u0001\u0004A\u0011A1\t\u000bA\u0004A\u0011A.\u0003\u001d\t+hMZ3sK\u0012|U\u000f\u001e7fi*\u0011\u0001#E\u0001\u0006QR$\bO\r\u0006\u0003%M\ta!\u001a8hS:,'B\u0001\u000b\u0016\u0003\u0011IW\u000e\u001d7\u000b\u0005Y9\u0012\u0001\u00025uiBT\u0011\u0001G\u0001\u0005C.\\\u0017-\u0006\u0002\u001bcM\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u0011s%D\u0001$\u0015\t!S%A\u0003ti\u0006<WM\u0003\u0002'/\u000511\u000f\u001e:fC6L!\u0001K\u0012\u0003\u0015=+H\u000fS1oI2,'/\u0001\u0004pkRdW\r^\u0002\u0001!\raSfL\u0007\u0002\u001f%\u0011af\u0004\u0002\u000e\u000f\u0016tWM]5d\u001fV$H.\u001a;\u0011\u0005A\nD\u0002\u0001\u0003\u0006e\u0001\u0011\ra\r\u0002\u0002)F\u0011Ag\u000e\t\u00039UJ!AN\u000f\u0003\u000f9{G\u000f[5oOB\u0011A\u0004O\u0005\u0003su\u00111!\u00118z\u0003\u0019a\u0014N\\5u}Q\u0011A(\u0010\t\u0004Y\u0001y\u0003\"B\u0015\u0003\u0001\u0004Y\u0013A\u00022vM\u001a,'/F\u0001A!\r\teiL\u0007\u0002\u0005*\u00111\tR\u0001\u0005kRLGNC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%AC!se\u0006LH)Z9vK\u00069!-\u001e4gKJ\u0004\u0013!C2p[BdW\r^3e+\u0005Y\u0005C\u0001\u000fM\u0013\tiUDA\u0004C_>dW-\u00198\u0002\u001b\r|W\u000e\u001d7fi\u0016$w\fJ3r)\t\u00016\u000b\u0005\u0002\u001d#&\u0011!+\b\u0002\u0005+:LG\u000fC\u0004U\r\u0005\u0005\t\u0019A&\u0002\u0007a$\u0013'\u0001\u0006d_6\u0004H.\u001a;fI\u0002\na\u0001Z8QkNDGC\u0001)Y\u0011\u0015I\u0006\u00021\u00010\u0003\u0011)G.Z7\u0002\r=t\u0007+\u001e7m)\u0005\u0001\u0016\u0001\u00029vg\"$\"\u0001\u00150\t\u000beS\u0001\u0019A\u0018\u0002\u0011\r|W\u000e\u001d7fi\u0016\fAAZ1jYR\u0011\u0001K\u0019\u0005\u0006G2\u0001\r\u0001Z\u0001\u0006G\u0006,8/\u001a\t\u0003K6t!AZ6\u000f\u0005\u001dTW\"\u00015\u000b\u0005%T\u0013A\u0002\u001fs_>$h(C\u0001\u001f\u0013\taW$A\u0004qC\u000e\\\u0017mZ3\n\u00059|'!\u0003+ie><\u0018M\u00197f\u0015\taW$\u0001\u0005uef4E.^:iQ\t\u0001!\u000f\u0005\u0002tm6\tAO\u0003\u0002v/\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005]$(aC%oi\u0016\u0014h.\u00197Ba&\u0004")
@InternalApi
public class BufferedOutlet<T>
implements OutHandler {
    private final GenericOutlet<T> outlet;
    private final ArrayDeque<T> buffer;
    private boolean completed;

    public void onDownstreamFinish() throws Exception {
        OutHandler.onDownstreamFinish$((OutHandler)this);
    }

    public void onDownstreamFinish(Throwable cause) throws Exception {
        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
    }

    public ArrayDeque<T> buffer() {
        return this.buffer;
    }

    public boolean completed() {
        return this.completed;
    }

    public void completed_$eq(boolean x$1) {
        this.completed = x$1;
    }

    public void doPush(T elem) {
        this.outlet.push(elem);
    }

    public void onPull() {
        this.tryFlush();
    }

    public void push(T elem) {
        if (this.outlet.canBePushed() && this.buffer().isEmpty()) {
            this.doPush(elem);
            return;
        }
        this.buffer().addLast(elem);
    }

    public void complete() {
        Predef$.MODULE$.require(!this.completed(), (Function0 & Serializable)() -> "Can only complete once.");
        this.completed_$eq(true);
        if (this.buffer().isEmpty()) {
            this.outlet.complete();
            return;
        }
    }

    public void fail(Throwable cause) {
        this.buffer().clear();
        this.outlet.fail(cause);
    }

    public void tryFlush() {
        if (this.outlet.canBePushed() && !this.buffer().isEmpty()) {
            this.doPush(this.buffer().pop());
        }
        if (this.buffer().isEmpty() && this.completed()) {
            this.outlet.complete();
            return;
        }
    }

    public BufferedOutlet(GenericOutlet<T> outlet) {
        this.outlet = outlet;
        OutHandler.$init$((OutHandler)this);
        this.buffer = new ArrayDeque();
        this.completed = false;
        outlet.setHandler(this);
    }
}

