/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2.framing;

import akka.annotation.InternalApi;
import akka.http.impl.engine.http2.ByteFlag$;
import akka.http.impl.engine.http2.FrameEvent;
import akka.http.impl.engine.http2.Http2Protocol;
import akka.http.impl.engine.http2.Http2Protocol$Flags$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$CONTINUATION$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$DATA$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$GOAWAY$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$HEADERS$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$PING$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$PRIORITY$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$PUSH_PROMISE$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$RST_STREAM$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$SETTINGS$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$WINDOW_UPDATE$;
import akka.http.impl.engine.http2.framing.FrameRenderer;
import akka.http.impl.engine.http2.framing.FrameRenderer$Frame$;
import akka.util.ByteString;
import java.nio.ByteOrder;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;

@InternalApi
public final class FrameRenderer$ {
    public static final FrameRenderer$ MODULE$ = new FrameRenderer$();
    private static final ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public ByteOrder byteOrder() {
        return byteOrder;
    }

    public ByteString render(FrameEvent frame) {
        FrameEvent frameEvent = frame;
        if (frameEvent instanceof FrameEvent.GoAwayFrame) {
            FrameEvent.GoAwayFrame goAwayFrame = (FrameEvent.GoAwayFrame)frameEvent;
            int lastStreamId = goAwayFrame.lastStreamId();
            Http2Protocol.ErrorCode errorCode = goAwayFrame.errorCode();
            ByteString debug = goAwayFrame.debug();
            return FrameRenderer$Frame$.MODULE$.apply(8 + debug.length(), Http2Protocol$FrameType$GOAWAY$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), 0).putInt32(lastStreamId).putInt32(errorCode.id()).put(debug).build();
        }
        if (frameEvent instanceof FrameEvent.DataFrame) {
            FrameEvent.DataFrame dataFrame = (FrameEvent.DataFrame)frameEvent;
            int streamId = dataFrame.streamId();
            boolean endStream = dataFrame.endStream();
            ByteString payload = dataFrame.payload();
            return FrameRenderer$Frame$.MODULE$.apply(payload.length(), Http2Protocol$FrameType$DATA$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), endStream), streamId).put(payload).build();
        }
        if (frameEvent instanceof FrameEvent.HeadersFrame) {
            FrameEvent.HeadersFrame headersFrame = (FrameEvent.HeadersFrame)frameEvent;
            int streamId = headersFrame.streamId();
            boolean endStream = headersFrame.endStream();
            boolean endHeaders = headersFrame.endHeaders();
            ByteString headerBlockFragment = headersFrame.headerBlockFragment();
            Option<FrameEvent.PriorityFrame> prioInfo = headersFrame.priorityInfo();
            return FrameRenderer$Frame$.MODULE$.apply((prioInfo.isDefined() ? 5 : 0) + headerBlockFragment.length(), Http2Protocol$FrameType$HEADERS$.MODULE$, ByteFlag$.MODULE$.$bar$extension(ByteFlag$.MODULE$.$bar$extension(ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), endStream), ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders)), ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.PRIORITY(), prioInfo.isDefined())), streamId).putPriorityInfo(prioInfo).put(headerBlockFragment).build();
        }
        if (frameEvent instanceof FrameEvent.WindowUpdateFrame) {
            FrameEvent.WindowUpdateFrame windowUpdateFrame = (FrameEvent.WindowUpdateFrame)frameEvent;
            int streamId = windowUpdateFrame.streamId();
            int windowSizeIncrement = windowUpdateFrame.windowSizeIncrement();
            return FrameRenderer$Frame$.MODULE$.apply(4, Http2Protocol$FrameType$WINDOW_UPDATE$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId).putInt32(windowSizeIncrement).build();
        }
        if (frameEvent instanceof FrameEvent.ContinuationFrame) {
            FrameEvent.ContinuationFrame continuationFrame = (FrameEvent.ContinuationFrame)frameEvent;
            int streamId = continuationFrame.streamId();
            boolean endHeaders = continuationFrame.endHeaders();
            ByteString payload = continuationFrame.payload();
            return FrameRenderer$Frame$.MODULE$.apply(payload.length(), Http2Protocol$FrameType$CONTINUATION$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders), streamId).put(payload).build();
        }
        if (frameEvent instanceof FrameEvent.SettingsFrame) {
            FrameEvent.SettingsFrame settingsFrame = (FrameEvent.SettingsFrame)frameEvent;
            Seq<FrameEvent.Setting> settings = settingsFrame.settings();
            FrameRenderer.Frame b = FrameRenderer$Frame$.MODULE$.apply(settings.length() * 6, Http2Protocol$FrameType$SETTINGS$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), 0);
            this.renderNext$1(settings, b);
            return b.build();
        }
        if (frameEvent instanceof FrameEvent.SettingsAckFrame) {
            return FrameRenderer$Frame$.MODULE$.apply(0, Http2Protocol$FrameType$SETTINGS$.MODULE$, Http2Protocol$Flags$.MODULE$.ACK(), 0).build();
        }
        if (frameEvent instanceof FrameEvent.PingFrame) {
            FrameEvent.PingFrame pingFrame = (FrameEvent.PingFrame)frameEvent;
            boolean ack = pingFrame.ack();
            ByteString data = pingFrame.data();
            return FrameRenderer$Frame$.MODULE$.apply(data.length(), Http2Protocol$FrameType$PING$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.ACK(), ack), 0).put(data).build();
        }
        if (frameEvent instanceof FrameEvent.RstStreamFrame) {
            FrameEvent.RstStreamFrame rstStreamFrame = (FrameEvent.RstStreamFrame)frameEvent;
            int streamId = rstStreamFrame.streamId();
            Http2Protocol.ErrorCode errorCode = rstStreamFrame.errorCode();
            return FrameRenderer$Frame$.MODULE$.apply(4, Http2Protocol$FrameType$RST_STREAM$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId).putInt32(errorCode.id()).build();
        }
        if (frameEvent instanceof FrameEvent.PushPromiseFrame) {
            FrameEvent.PushPromiseFrame pushPromiseFrame = (FrameEvent.PushPromiseFrame)frameEvent;
            int streamId = pushPromiseFrame.streamId();
            boolean endHeaders = pushPromiseFrame.endHeaders();
            int promisedStreamId = pushPromiseFrame.promisedStreamId();
            ByteString headerBlockFragment = pushPromiseFrame.headerBlockFragment();
            return FrameRenderer$Frame$.MODULE$.apply(4 + headerBlockFragment.length(), Http2Protocol$FrameType$PUSH_PROMISE$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders), streamId).putInt32(promisedStreamId).put(headerBlockFragment).build();
        }
        if (frameEvent instanceof FrameEvent.PriorityFrame) {
            FrameEvent.PriorityFrame priorityFrame = (FrameEvent.PriorityFrame)frameEvent;
            int streamId = priorityFrame.streamId();
            return FrameRenderer$Frame$.MODULE$.apply(5, Http2Protocol$FrameType$PRIORITY$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId).putPriorityInfo(priorityFrame).build();
        }
        throw new IllegalStateException(new StringBuilder(23).append("Unexpected frame type ").append(frame.frameTypeName()).append(".").toString());
    }

    public ByteString renderFrame(Http2Protocol.FrameType tpe, int flags, int streamId, ByteString payload) {
        return FrameRenderer$Frame$.MODULE$.apply(payload.length(), tpe, flags, streamId).put(payload).build();
    }

    private final void renderNext$1(Seq remaining, FrameRenderer.Frame b$1) {
        Option option;
        Seq seq;
        while ((seq = remaining) != null && !(option = package$.MODULE$.$plus$colon().unapply((SeqOps)seq)).isEmpty()) {
            FrameEvent.Setting setting = (FrameEvent.Setting)((Tuple2)option.get())._1();
            Seq remaining2 = (Seq)((Tuple2)option.get())._2();
            if (setting == null) break;
            Http2Protocol.SettingIdentifier id = setting.identifier();
            int value = setting.value();
            b$1.putInt16(id.id());
            b$1.putInt32(value);
            remaining = remaining2;
        }
        if (!Nil$.MODULE$.equals(seq)) {
            throw new MatchError((Object)seq);
        }
    }

    private FrameRenderer$() {
    }
}

