/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core.helpers;

import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandResultDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.AbstractHelperCommandStep;
import liquibase.command.core.helpers.PreCompareCommandStep;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.ObjectChangeFilter;

public class DiffOutputControlCommandStep
extends AbstractHelperCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"diffOutputControl"};
    public static final CommandArgumentDefinition<Boolean> INCLUDE_CATALOG_ARG;
    public static final CommandArgumentDefinition<Boolean> INCLUDE_SCHEMA_ARG;
    public static final CommandArgumentDefinition<Boolean> INCLUDE_TABLESPACE_ARG;
    public static final CommandResultDefinition<DiffOutputControl> DIFF_OUTPUT_CONTROL;

    @Override
    public List<Class<?>> requiredDependencies() {
        return Collections.singletonList(CompareControl.class);
    }

    @Override
    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(DiffOutputControl.class);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        DiffOutputControl diffOutputControl = this.getDiffOutputControl(resultsBuilder);
        resultsBuilder.addResult(DIFF_OUTPUT_CONTROL.getName(), diffOutputControl);
        this.outputBestPracticeMessage();
    }

    private DiffOutputControl getDiffOutputControl(CommandResultsBuilder resultsBuilder) {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        CompareControl compareControl = (CompareControl)resultsBuilder.getResult(PreCompareCommandStep.COMPARE_CONTROL_RESULT.getName());
        ObjectChangeFilter objectChangeFilter = (ObjectChangeFilter)resultsBuilder.getResult(PreCompareCommandStep.OBJECT_CHANGE_FILTER_RESULT.getName());
        Boolean includeCatalog = commandScope.getArgumentValue(INCLUDE_CATALOG_ARG);
        Boolean includeSchema = commandScope.getArgumentValue(INCLUDE_SCHEMA_ARG);
        Boolean includeTablespace = commandScope.getArgumentValue(INCLUDE_TABLESPACE_ARG);
        this.addMdcProperties(includeCatalog, includeSchema, includeTablespace);
        DiffOutputControl diffOutputControl = new DiffOutputControl(includeCatalog, includeSchema, includeTablespace, compareControl.getSchemaComparisons());
        for (CompareControl.SchemaComparison schema : compareControl.getSchemaComparisons()) {
            diffOutputControl.addIncludedSchema(schema.getReferenceSchema());
            diffOutputControl.addIncludedSchema(schema.getComparisonSchema());
        }
        if (objectChangeFilter != null) {
            diffOutputControl.setObjectChangeFilter(objectChangeFilter);
        }
        return diffOutputControl;
    }

    private void addMdcProperties(Boolean includeCatalog, Boolean includeSchema, Boolean includeTablespace) {
        Scope.getCurrentScope().addMdcValue("includeCatalog", String.valueOf(includeCatalog));
        Scope.getCurrentScope().addMdcValue("includeSchema", String.valueOf(includeSchema));
        Scope.getCurrentScope().addMdcValue("includeTablespace", String.valueOf(includeTablespace));
    }

    protected void outputBestPracticeMessage() {
        Scope.getCurrentScope().getUI().sendMessage("BEST PRACTICE: The changelog generated by diffChangeLog/generateChangeLog should be inspected for correctness and completeness before being deployed. Some database objects and their dependencies cannot be represented automatically, and they may need to be manually updated before being deployed.");
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{COMMAND_NAME});
        INCLUDE_CATALOG_ARG = builder.argument("includeCatalog", Boolean.class).defaultValue(false).description("If true, the catalog will be included in generated changeSets. Defaults to false.").build();
        INCLUDE_SCHEMA_ARG = builder.argument("includeSchema", Boolean.class).defaultValue(false).description("If true, the schema will be included in generated changeSets. Defaults to false.").build();
        INCLUDE_TABLESPACE_ARG = builder.argument("includeTablespace", Boolean.class).defaultValue(false).description("Include the tablespace attribute in the changelog. Defaults to false.").build();
        DIFF_OUTPUT_CONTROL = builder.result("diffOutputControl", DiffOutputControl.class).build();
    }
}

