/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.raft;

import java.util.Objects;

public final class RaftChannelConfiguration {
    private final RaftLogMode logMode;

    private RaftChannelConfiguration(RaftLogMode logMode) {
        this.logMode = logMode;
    }

    public RaftLogMode logMode() {
        return this.logMode;
    }

    public String toString() {
        return "RaftChannelConfiguration{logMode=" + this.logMode + "}";
    }

    public static enum RaftLogMode {
        VOLATILE,
        PERSISTENT;

    }

    public static class Builder {
        private RaftLogMode logMode = RaftLogMode.PERSISTENT;

        public Builder logMode(RaftLogMode logMode) {
            this.logMode = Objects.requireNonNull(logMode);
            return this;
        }

        public RaftChannelConfiguration build() {
            return new RaftChannelConfiguration(this.logMode);
        }
    }
}

