/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.dataconversion.MediaType;

public class ContentTypeConfiguration
extends ConfigurationElement<ContentTypeConfiguration> {
    public static final String DEFAULT_MEDIA_TYPE = "application/x-java-object";
    public static final AttributeDefinition<String> MEDIA_TYPE = AttributeDefinition.builder((String)"media-type", null, String.class).immutable().build();
    private final MediaType parsed;

    ContentTypeConfiguration(Enum<?> element, AttributeSet attributes, MediaType parsed) {
        super(element, attributes, new ConfigurationElement[0]);
        this.parsed = parsed;
    }

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ContentTypeConfiguration.class, new AttributeDefinition[]{MEDIA_TYPE});
    }

    public MediaType mediaType() {
        return this.parsed;
    }

    public void mediaType(MediaType mediaType) {
        this.attributes.attribute(MEDIA_TYPE).set((Object)mediaType.toString());
    }

    public boolean isMediaTypeChanged() {
        return this.attributes.attribute(MEDIA_TYPE).isModified();
    }

    public boolean isEncodingChanged() {
        return this.attributes.attribute(MEDIA_TYPE).isModified();
    }

    public boolean isObjectStorage() {
        String mediaType = (String)this.attributes.attribute(MEDIA_TYPE).get();
        return mediaType != null && MediaType.fromString((String)mediaType).match(MediaType.APPLICATION_OBJECT);
    }

    public boolean isProtobufStorage() {
        String mediaType = (String)this.attributes.attribute(MEDIA_TYPE).get();
        return mediaType != null && MediaType.fromString((String)mediaType).match(MediaType.APPLICATION_PROTOSTREAM);
    }
}

