/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.cache;

import io.github.resilience4j.core.RegistryStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.cache.Cache;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;

public class CacheRegistryStore<E>
implements RegistryStore<E> {
    private final Cache<String, E> cacheStore;

    public CacheRegistryStore(Cache<String, E> cacheStore) {
        this.cacheStore = cacheStore;
    }

    public E computeIfAbsent(String key, Function<? super String, ? extends E> mappingFunction) {
        try {
            return (E)this.cacheStore.invoke((Object)key, new AtomicComputeProcessor(), new Object[]{mappingFunction});
        }
        catch (EntryProcessorException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public E putIfAbsent(String key, E value) {
        return (E)this.computeIfAbsent(key, k -> value);
    }

    public Optional<E> find(String key) {
        return Optional.ofNullable(this.cacheStore.get((Object)key));
    }

    public Optional<E> remove(String name) {
        return Optional.ofNullable(this.cacheStore.getAndRemove((Object)name));
    }

    public Optional<E> replace(String name, E newEntry) {
        return Optional.ofNullable(this.cacheStore.getAndReplace((Object)name, newEntry));
    }

    public Collection<E> values() {
        ArrayList values = new ArrayList();
        this.cacheStore.iterator().forEachRemaining(iter -> values.add(iter.getValue()));
        return values;
    }

    static class AtomicComputeProcessor<String, E>
    implements EntryProcessor<String, E, E> {
        AtomicComputeProcessor() {
        }

        public E process(MutableEntry<String, E> entry, Object ... arguments) throws EntryProcessorException {
            Function mappingFunction = (Function)arguments[0];
            Object oldValue = entry.getValue();
            if (oldValue != null) {
                return (E)oldValue;
            }
            Object newValue = mappingFunction.apply(entry.getKey());
            if (newValue != null) {
                entry.setValue(newValue);
                return (E)newValue;
            }
            return (E)oldValue;
        }
    }
}

