/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.statetransfer;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.statetransfer.AbstractStateTransferCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.util.ByteString;

public class StateTransferCancelCommand
extends AbstractStateTransferCommand {
    public static final byte COMMAND_ID = 117;

    public StateTransferCancelCommand() {
        this(null);
    }

    public StateTransferCancelCommand(ByteString cacheName) {
        super((byte)117, cacheName);
    }

    public StateTransferCancelCommand(ByteString cacheName, int topologyId, IntSet segments) {
        super((byte)117, cacheName, topologyId, segments);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        StateProvider stateProvider = registry.getStateTransferManager().getStateProvider();
        stateProvider.cancelOutboundTransfer(this.origin, this.topologyId, this.segments);
        return CompletableFutures.completedNull();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public String toString() {
        return "StateTransferCancelCommand{topologyId=" + this.topologyId + ", segments=" + this.segments + ", cacheName=" + this.cacheName + "}";
    }
}

