/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.xebialabs.deployit.plugin.stitch.configuration.XldConfigWithFallback;
import com.xebialabs.deployit.plugin.stitch.model.Processor;
import com.xebialabs.deployit.plugin.stitch.model.specification.Macro;
import com.xebialabs.deployit.plugin.stitch.service.CacheService;
import com.xebialabs.deployit.plugin.stitch.service.LRUCache$;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;

@Component
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001B\u000b\u0017\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006k\u0001!\tA\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019q\u0004\u0001)A\u0005w!9q\b\u0001b\u0001\n\u0013Q\u0004B\u0002!\u0001A\u0003%1\bC\u0004B\u0001\t\u0007I\u0011\u0002\u001e\t\r\t\u0003\u0001\u0015!\u0003<\u0011\u001d\u0019\u0005A1A\u0005\n\u0011Ca\u0001\u0013\u0001!\u0002\u0013)\u0005bB%\u0001\u0005\u0004%IA\u0013\u0005\u0007S\u0002\u0001\u000b\u0011B&\t\u000f)\u0004!\u0019!C\u0005W\"9\u0011Q\u0001\u0001!\u0002\u0013a\u0007bBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\ty\u0002\u0001C!\u0003CAq!a\u000b\u0001\t\u0003\ni\u0003C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B\t\tR*Y2s_\u000e\u000b7\r[3TKJ4\u0018nY3\u000b\u0005]A\u0012aB:feZL7-\u001a\u0006\u00033i\taa\u001d;ji\u000eD'BA\u000e\u001d\u0003\u0019\u0001H.^4j]*\u0011QDH\u0001\tI\u0016\u0004Hn\\=ji*\u0011q\u0004I\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!I\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,Y5\ta#\u0003\u0002.-\ta1)Y2iKN+'O^5dK\u0006)\u0002\u0010\u001c3D_:4\u0017nZ,ji\"4\u0015\r\u001c7cC\u000e\\\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0019\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011A'\r\u0002\u001612$7i\u001c8gS\u001e<\u0016\u000e\u001e5GC2d'-Y2l\u0003\u0019a\u0014N\\5u}Q\u0011q\u0007\u000f\t\u0003W\u0001AQA\f\u0002A\u0002=\n\u0001#\\1de>\u001cX*\u0019=F]R\u0014\u0018.Z:\u0016\u0003m\u0002\"!\n\u001f\n\u0005u2#aA%oi\u0006\tR.Y2s_Nl\u0015\r_#oiJLWm\u001d\u0011\u000235\f7M]8Qe>\u001cWm]:peNl\u0015\r_#oiJLWm]\u0001\u001b[\u0006\u001c'o\u001c)s_\u000e,7o]8sg6\u000b\u00070\u00128ue&,7\u000fI\u0001\u0010S:LG/[1m\u0007\u0006\u0004\u0018mY5us\u0006\u0001\u0012N\\5uS\u0006d7)\u00199bG&$\u0018\u0010I\u0001\u000bY>\fGMR1di>\u0014X#A#\u0011\u0005\u00152\u0015BA$'\u0005\u00151En\\1u\u0003-aw.\u00193GC\u000e$xN\u001d\u0011\u0002\u00155\f7M]8DC\u000eDW-F\u0001L!\u0011a\u0015kU1\u000e\u00035S!AT(\u0002\u000f5,H/\u00192mK*\u0011\u0001KJ\u0001\u000bG>dG.Z2uS>t\u0017B\u0001*N\u0005\ri\u0015\r\u001d\t\u0005KQ3f+\u0003\u0002VM\t1A+\u001e9mKJ\u0002\"a\u00160\u000f\u0005ac\u0006CA-'\u001b\u0005Q&BA.#\u0003\u0019a$o\\8u}%\u0011QLJ\u0001\u0007!J,G-\u001a4\n\u0005}\u0003'AB*ue&twM\u0003\u0002^MA\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u000egB,7-\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u0019D\u0012!B7pI\u0016d\u0017B\u00015d\u0005\u0015i\u0015m\u0019:p\u0003-i\u0017m\u0019:p\u0007\u0006\u001c\u0007.\u001a\u0011\u0002)5\f7M]8Qe>\u001cWm]:peN\u001c\u0015m\u00195f+\u0005a\u0007\u0003\u0002'R[V\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\tU$\u0018\u000e\u001c\u0006\u0002e\u0006!!.\u0019<b\u0013\t!xN\u0001\u0003V+&#\u0005c\u0001<|}:\u0011q/\u001f\b\u00033bL\u0011aJ\u0005\u0003u\u001a\nq\u0001]1dW\u0006<W-\u0003\u0002}{\n!A*[:u\u0015\tQh\u0005E\u0002\u0000\u0003\u0003i\u0011!Z\u0005\u0004\u0003\u0007)'!\u0003)s_\u000e,7o]8s\u0003Ui\u0017m\u0019:p!J|7-Z:t_J\u001c8)Y2iK\u0002\n!BZ3uG\"l\u0015m\u0019:p)\u0011\tY!!\u0005\u0011\t\u0015\ni!Y\u0005\u0004\u0003\u001f1#AB(qi&|g\u000e\u0003\u0004\u0002\u0014=\u0001\raU\u0001\t[\u0006\u001c'o\\&fs\u0006A\u0011\r\u001a3NC\u000e\u0014x\u000e\u0006\u0004\u0002\f\u0005e\u00111\u0004\u0005\u0007\u0003'\u0001\u0002\u0019A*\t\u000f\u0005u\u0001\u00031\u0001\u0002\f\u0005AA\u000f[3NC\u000e\u0014x.A\u0006sK6|g/Z'bGJ|G\u0003BA\u0012\u0003S\u00012!JA\u0013\u0013\r\t9C\n\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u0014E\u0001\raU\u0001\u0015M\u0016$8\r['bGJ|\u0007K]8dKN\u001cxN]:\u0015\t\u0005=\u0012\u0011\u0007\t\u0005K\u00055Q\u000f\u0003\u0004\u00024I\u0001\r!\\\u0001\u0004W\u0016L\u0018AE1eI6\u000b7M]8Qe>\u001cWm]:peN$R!^A\u001d\u0003wAa!a\r\u0014\u0001\u0004i\u0007BBA\u001f'\u0001\u0007Q/A\bnC\u000e\u0014x\u000e\u0015:pG\u0016\u001c8o\u001c:t\u0003U\u0011X-\\8wK6\u000b7M]8Qe>\u001cWm]:peN$B!a\t\u0002D!1\u00111\u0007\u000bA\u00025D3\u0001AA$!\u0011\tI%a\u0018\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\n!\"\u00198o_R\fG/[8o\u0015\u0011\t\t&a\u0015\u0002\u000f\u0019\f7\r^8ss*!\u0011QKA,\u0003\u0015\u0011W-\u00198t\u0015\u0011\tI&a\u0017\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\u0018\u0002\u0007=\u0014x-\u0003\u0003\u0002b\u0005-#!C!vi><\u0018N]3eQ\r\u0001\u0011Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)!\u00111NA,\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003_\nIGA\u0005D_6\u0004xN\\3oi\u0002")
public class MacroCacheService
implements CacheService {
    private final int macrosMaxEntries;
    private final int macroProcessorsMaxEntries;
    private final int initialCapacity;
    private final float loadFactor;
    private final Map<Tuple2<String, String>, Macro> macroCache;
    private final Map<UUID, List<Processor>> macroProcessorsCache;

    private int macrosMaxEntries() {
        return this.macrosMaxEntries;
    }

    private int macroProcessorsMaxEntries() {
        return this.macroProcessorsMaxEntries;
    }

    private int initialCapacity() {
        return this.initialCapacity;
    }

    private float loadFactor() {
        return this.loadFactor;
    }

    private Map<Tuple2<String, String>, Macro> macroCache() {
        return this.macroCache;
    }

    private Map<UUID, List<Processor>> macroProcessorsCache() {
        return this.macroProcessorsCache;
    }

    @Override
    public Option<Macro> fetchMacro(Tuple2<String, String> macroKey) {
        return this.macroCache().get(macroKey);
    }

    @Override
    public Option<Macro> addMacro(Tuple2<String, String> macroKey, Option<Macro> theMacro) {
        theMacro.map((Function1 & Serializable)m -> (Map)this.macroCache().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)macroKey), m)));
        return theMacro;
    }

    @Override
    public void removeMacro(Tuple2<String, String> macroKey) {
        this.macroCache().remove(macroKey);
    }

    @Override
    public Option<List<Processor>> fetchMacroProcessors(UUID key) {
        return this.macroProcessorsCache().get((Object)key);
    }

    @Override
    public List<Processor> addMacroProcessors(UUID key, List<Processor> macroProcessors) {
        this.macroProcessorsCache().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), macroProcessors));
        return macroProcessors;
    }

    @Override
    public void removeMacroProcessors(UUID key) {
        this.macroProcessorsCache().remove((Object)key);
    }

    public MacroCacheService(XldConfigWithFallback xldConfigWithFallback) {
        this.macrosMaxEntries = xldConfigWithFallback.xldConfig().getInt("xl.stitch.cache.macros");
        this.macroProcessorsMaxEntries = xldConfigWithFallback.xldConfig().getInt("xl.stitch.cache.macroProcessors");
        this.initialCapacity = xldConfigWithFallback.xldConfig().getInt("xl.stitch.cache.initialCapacity");
        this.loadFactor = (float)xldConfigWithFallback.xldConfig().getDouble("xl.stitch.cache.loadFactor");
        this.macroCache = LRUCache$.MODULE$.apply(this.macrosMaxEntries(), this.initialCapacity(), this.loadFactor());
        this.macroProcessorsCache = LRUCache$.MODULE$.apply(this.macroProcessorsMaxEntries(), this.initialCapacity(), this.loadFactor());
    }
}

