/*
 * Decompiled with CFR 0.152.
 */
package io.altoo.serialization.kryo.scala;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.unsafe.UnsafeInput;
import com.esotericsoftware.kryo.unsafe.UnsafeOutput;
import io.altoo.serialization.kryo.scala.ReflectionHelper$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-d!B\f\u0019\u0001i\u0011\u0003\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011A\u0015\t\u0011M\u0002!\u0011!Q\u0001\n)B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001BC\u0002\u0013\u0005Q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00037\u0011!a\u0004A!b\u0001\n\u0003i\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\t\u0003!Q1A\u0005\u0002uB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"AQ\n\u0001B\u0001B\u0003%a\nC\u0003W\u0001\u0011\u0005q\u000bC\u0003c\u0001\u0011\u00051\rC\u0003c\u0001\u0011\u0005q\u000eC\u0003}\u0001\u0011\u0005Q\u0010\u0003\u0004}\u0001\u0011\u0005\u00111\u0007\u0005\n\u0003\u0007\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"!\u0015\u0001A\u0003%\u0011q\t\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\tY\u0006\u0001C\u0005\u0003;Bq!a\u0017\u0001\t\u0013\t9GA\u000bLef|7+\u001a:jC2L'0\u001a:CC\u000e\\WM\u001c3\u000b\u0005eQ\u0012!B:dC2\f'BA\u000e\u001d\u0003\u0011Y'/_8\u000b\u0005uq\u0012!D:fe&\fG.\u001b>bi&|gN\u0003\u0002 A\u0005)\u0011\r\u001c;p_*\t\u0011%\u0001\u0002j_N\u0011\u0001a\t\t\u0003I\u0019j\u0011!\n\u0006\u00023%\u0011q%\n\u0002\u0007\u0003:L(+\u001a4\u0004\u0001U\t!\u0006\u0005\u0002,c5\tAF\u0003\u0002\u001c[)\u0011afL\u0001\u0011KN|G/\u001a:jGN|g\r^<be\u0016T\u0011\u0001M\u0001\u0004G>l\u0017B\u0001\u001a-\u0005\u0011Y%/_8\u0002\u000b-\u0014\u0018p\u001c\u0011\u0002\u0015\t,hMZ3s'&TX-F\u00017!\t!s'\u0003\u00029K\t\u0019\u0011J\u001c;\u0002\u0017\t,hMZ3s'&TX\rI\u0001\u000e[\u0006D()\u001e4gKJ\u001c\u0016N_3\u0002\u001d5\f\u0007PQ;gM\u0016\u00148+\u001b>fA\u0005YQo]3NC:Lg-Z:u+\u0005q\u0004C\u0001\u0013@\u0013\t\u0001UEA\u0004C_>dW-\u00198\u0002\u0019U\u001cX-T1oS\u001a,7\u000f\u001e\u0011\u0002\u0013U\u001cX-\u00168tC\u001a,\u0017AC;tKVs7/\u00194fA\u0005\u0019An\\4\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015!B:mMRR'\"\u0001&\u0002\u0007=\u0014x-\u0003\u0002M\u000f\n1Aj\\4hKJ\f1b\u00197bgNdu.\u00193feB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0005Y\u0006twMC\u0001T\u0003\u0011Q\u0017M^1\n\u0005U\u0003&aC\"mCN\u001cHj\\1eKJ\fa\u0001P5oSRtDC\u0002-^=~\u0003\u0017\rF\u0002Z7r\u0003\"A\u0017\u0001\u000e\u0003aAQ\u0001R\u0007A\u0002\u0015CQ!T\u0007A\u00029CQaG\u0007A\u0002)BQ\u0001N\u0007A\u0002YBQAO\u0007A\u0002YBQ\u0001P\u0007A\u0002yBQAQ\u0007A\u0002y\n\u0001\u0002^8CS:\f'/\u001f\u000b\u0003I*\u00042\u0001J3h\u0013\t1WEA\u0003BeJ\f\u0017\u0010\u0005\u0002%Q&\u0011\u0011.\n\u0002\u0005\u0005f$X\rC\u0003l\u001d\u0001\u0007A.A\u0002pE*\u0004\"\u0001J7\n\u00059,#aA!osR\u0019\u0001o\u001d;\u0011\u0005\u0011\n\u0018B\u0001:&\u0005\u0011)f.\u001b;\t\u000b-|\u0001\u0019\u00017\t\u000bU|\u0001\u0019\u0001<\u0002\u0007\t,h\r\u0005\u0002xu6\t\u0001P\u0003\u0002z%\u0006\u0019a.[8\n\u0005mD(A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006QaM]8n\u0005&t\u0017M]=\u0015\t\rr\u0018\u0011\u0001\u0005\u0006\u007fB\u0001\r\u0001Z\u0001\u0006Ef$Xm\u001d\u0005\b\u0003\u0007\u0001\u0002\u0019AA\u0003\u0003\u0015\u0019G.\u0019>{!\u0015!\u0013qAA\u0006\u0013\r\tI!\n\u0002\u0007\u001fB$\u0018n\u001c81\t\u00055\u0011q\u0005\t\u0007\u0003\u001f\ti\"a\t\u000f\t\u0005E\u0011\u0011\u0004\t\u0004\u0003')SBAA\u000b\u0015\r\t9\u0002K\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005mQ%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tCA\u0003DY\u0006\u001c8OC\u0002\u0002\u001c\u0015\u0002B!!\n\u0002(1\u0001A\u0001DA\u0015\u0003\u0003\t\t\u0011!A\u0003\u0002\u0005-\"\u0001\u0003\u0013r[\u0006\u00148\u000eJ\u0019\u0012\u0007\u00055B\u000eE\u0002%\u0003_I1!!\r&\u0005\u001dqu\u000e\u001e5j]\u001e$RaIA\u001b\u0003oAQ!^\tA\u0002YDq!!\u000f\u0012\u0001\u0004\tY$\u0001\u0005nC:Lg-Z:u!\u0015!\u0013qAA\u001f!\u0011\ty!a\u0010\n\t\u0005\u0005\u0013\u0011\u0005\u0002\u0007'R\u0014\u0018N\\4\u0002\r=,H\u000f];u+\t\t9\u0005\u0005\u0003\u0002J\u00055SBAA&\u0015\t\tC&\u0003\u0003\u0002P\u0005-#AB(viB,H/A\u0004pkR\u0004X\u000f\u001e\u0011\u0002\u0013\u001d,GoT;uaV$H\u0003BA$\u0003/Ba!!\u0017\u0015\u0001\u00041\u0018A\u00022vM\u001a,'/\u0001\u0005hKRLe\u000e];u)\u0011\ty&!\u001a\u0011\t\u0005%\u0013\u0011M\u0005\u0005\u0003G\nYEA\u0003J]B,H\u000fC\u0003\u0000+\u0001\u0007A\r\u0006\u0003\u0002`\u0005%\u0004BBA--\u0001\u0007a\u000f")
public class KryoSerializerBackend {
    private final Kryo kryo;
    private final int bufferSize;
    private final int maxBufferSize;
    private final boolean useManifest;
    private final boolean useUnsafe;
    private final Logger log;
    private final ClassLoader classLoader;
    private final Output output;

    public Kryo kryo() {
        return this.kryo;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public int maxBufferSize() {
        return this.maxBufferSize;
    }

    public boolean useManifest() {
        return this.useManifest;
    }

    public boolean useUnsafe() {
        return this.useUnsafe;
    }

    public byte[] toBinary(Object obj) {
        byte[] byArray;
        Output buffer = this.output();
        try {
            try {
                if (this.useManifest()) {
                    this.kryo().writeObject(buffer, obj);
                } else {
                    this.kryo().writeClassAndObject(buffer, obj);
                }
                byArray = buffer.toBytes();
            }
            catch (Throwable throwable) {
                if (throwable instanceof StackOverflowError) {
                    StackOverflowError stackOverflowError = (StackOverflowError)throwable;
                    if (!this.kryo().getReferences()) {
                        this.log.error(new StringBuilder(64).append("Could not serialize class with potentially circular references: ").append(this.classLoader).toString(), (Throwable)stackOverflowError);
                        throw new RuntimeException(new StringBuilder(62).append("Could not serialize class with potential circular references: ").append(obj).toString());
                    }
                }
                throw throwable;
            }
        }
        finally {
            buffer.reset();
        }
        return byArray;
    }

    public void toBinary(Object obj, ByteBuffer buf) {
        Output buffer = this.getOutput(buf);
        try {
            if (this.useManifest()) {
                this.kryo().writeObject(buffer, obj);
            } else {
                this.kryo().writeClassAndObject(buffer, obj);
            }
            buffer.toBytes();
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof StackOverflowError) {
                StackOverflowError stackOverflowError = (StackOverflowError)throwable;
                if (!this.kryo().getReferences()) {
                    this.log.error(new StringBuilder(64).append("Could not serialize class with potentially circular references: ").append(obj).toString(), (Throwable)stackOverflowError);
                    throw new RuntimeException(new StringBuilder(62).append("Could not serialize class with potential circular references: ").append(obj).toString());
                }
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object fromBinary(byte[] bytes, Option<Class<?>> clazz) {
        try (Input buffer = this.getInput(bytes);){
            Object object;
            if (this.useManifest()) {
                if (!(clazz instanceof Some)) throw new RuntimeException("Object of unknown class cannot be deserialized");
                Class c = (Class)((Some)clazz).value();
                object = this.kryo().readObject(buffer, c);
                return object;
            } else {
                object = this.kryo().readClassAndObject(buffer);
            }
            return object;
        }
    }

    public Object fromBinary(ByteBuffer buf, Option<String> manifest) {
        Input buffer = this.getInput(buf);
        if (this.useManifest()) {
            Option clazz = manifest.flatMap((Function1 & Serializable)x$1 -> ReflectionHelper$.MODULE$.getClassFor((String)x$1, $this.classLoader).toOption());
            if (clazz instanceof Some) {
                Class c = (Class)((Some)clazz).value();
                return this.kryo().readObject(buffer, c);
            }
            throw new RuntimeException("Object of unknown class cannot be deserialized");
        }
        return this.kryo().readClassAndObject(buffer);
    }

    private Output output() {
        return this.output;
    }

    private Output getOutput(ByteBuffer buffer) {
        return new ByteBufferOutput(buffer);
    }

    private Input getInput(byte[] bytes) {
        if (this.useUnsafe()) {
            return new UnsafeInput(bytes);
        }
        return new Input(bytes);
    }

    private Input getInput(ByteBuffer buffer) {
        return new ByteBufferInput(buffer);
    }

    public KryoSerializerBackend(Kryo kryo, int bufferSize, int maxBufferSize, boolean useManifest, boolean useUnsafe, Logger log, ClassLoader classLoader) {
        this.kryo = kryo;
        this.bufferSize = bufferSize;
        this.maxBufferSize = maxBufferSize;
        this.useManifest = useManifest;
        this.useUnsafe = useUnsafe;
        this.log = log;
        this.classLoader = classLoader;
        this.output = useUnsafe ? new UnsafeOutput(bufferSize, maxBufferSize) : new Output(bufferSize, maxBufferSize);
    }
}

