/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.internal;

import java.lang.reflect.Member;
import java.util.EnumSet;
import org.hibernate.MappingException;
import org.hibernate.PropertyValueException;
import org.hibernate.annotations.TenantId;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.descriptor.java.JavaType;

public class TenantIdGeneration
implements BeforeExecutionGenerator {
    private final String entityName;
    private final String propertyName;
    private final Class<?> propertyType;

    public TenantIdGeneration(TenantId annotation, Member member, GeneratorCreationContext context) {
        this.entityName = context.getPersistentClass() == null ? member.getDeclaringClass().getName() : context.getPersistentClass().getEntityName();
        this.propertyName = context.getProperty().getName();
        this.propertyType = ReflectHelper.getPropertyType(member);
    }

    @Override
    public EnumSet<EventType> getEventTypes() {
        return EventTypeSets.INSERT_ONLY;
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
        SessionFactoryImplementor sessionFactory = session.getSessionFactory();
        JavaType descriptor = sessionFactory.getTypeConfiguration().getJavaTypeRegistry().findDescriptor(this.propertyType);
        if (descriptor == null) {
            throw new MappingException("unsupported tenant id property type: " + this.propertyType.getName());
        }
        String tenantId = session.getTenantIdentifier();
        if (currentValue != null) {
            CurrentTenantIdentifierResolver resolver = sessionFactory.getCurrentTenantIdentifierResolver();
            if (resolver != null && resolver.isRoot(tenantId)) {
                return currentValue;
            }
            String currentTenantId = descriptor.toString(currentValue);
            if (!currentTenantId.equals(tenantId)) {
                throw new PropertyValueException("assigned tenant id differs from current tenant id: " + currentTenantId + "!=" + tenantId, this.entityName, this.propertyName);
            }
        }
        return tenantId == null ? null : descriptor.fromString(tenantId);
    }
}

