/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Timer;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.transport.RequestReplySenderContext;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.netty.Metrics;
import reactor.netty.ReactorNetty;
import reactor.netty.http.client.AbstractHttpClientMetricsHandler;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.http.client.HttpClientObservations;
import reactor.netty.http.client.MicrometerHttpClientMetricsRecorder;
import reactor.netty.observability.ReactorNettyHandlerContext;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

final class MicrometerHttpClientMetricsHandler
extends AbstractHttpClientMetricsHandler {
    final MicrometerHttpClientMetricsRecorder recorder;
    ResponseTimeHandlerContext responseTimeHandlerContext;
    Observation responseTimeObservation;
    ContextView parentContextView;

    MicrometerHttpClientMetricsHandler(MicrometerHttpClientMetricsRecorder recorder, SocketAddress remoteAddress, @Nullable SocketAddress proxyAddress, @Nullable Function<String, String> uriTagValue) {
        super(remoteAddress, proxyAddress, uriTagValue);
        this.recorder = recorder;
    }

    MicrometerHttpClientMetricsHandler(MicrometerHttpClientMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
        this.responseTimeHandlerContext = copy.responseTimeHandlerContext;
        this.responseTimeObservation = copy.responseTimeObservation;
        this.parentContextView = copy.parentContextView;
    }

    @Override
    protected HttpClientMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordRead(Channel channel, SocketAddress address) {
        if (this.proxyAddress == null) {
            this.recorder().recordDataReceivedTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
            this.recorder().recordDataReceived(address, this.path, this.dataReceived);
        } else {
            this.recorder().recordDataReceivedTime(address, this.proxyAddress, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
            this.recorder().recordDataReceived(address, this.proxyAddress, this.path, this.dataReceived);
        }
        this.responseTimeObservation.stop();
        ReactorNetty.setChannelContext((Channel)channel, (ContextView)this.parentContextView);
    }

    @Override
    protected void reset() {
        super.reset();
        this.responseTimeHandlerContext = null;
        this.responseTimeObservation = null;
        this.parentContextView = null;
    }

    @Override
    protected void startRead(HttpResponse msg) {
        super.startRead(msg);
        this.responseTimeHandlerContext.setResponse(msg);
        this.responseTimeHandlerContext.status = this.status;
    }

    @Override
    protected void startWrite(HttpRequest msg, Channel channel, SocketAddress address) {
        super.startWrite(msg, channel, address);
        this.responseTimeHandlerContext = new ResponseTimeHandlerContext(this.recorder, msg, this.path, address, this.proxyAddress);
        this.responseTimeObservation = Observation.createNotStarted((String)(this.recorder.name() + ".response.time"), (Supplier)this.responseTimeHandlerContext, (ObservationRegistry)Metrics.OBSERVATION_REGISTRY);
        this.parentContextView = Metrics.updateChannelContext((Channel)channel, (Observation)this.responseTimeObservation);
        this.responseTimeObservation.start();
    }

    static final class ResponseTimeHandlerContext
    extends RequestReplySenderContext<HttpRequest, HttpResponse>
    implements ReactorNettyHandlerContext,
    Supplier<Observation.Context> {
        static final String HTTP_PREFIX = "http ";
        static final String TYPE = "client";
        final String method;
        final String netPeerName;
        final String netPeerPort;
        final String path;
        final String proxyAddress;
        final MicrometerHttpClientMetricsRecorder recorder;
        String status = "UNKNOWN";

        ResponseTimeHandlerContext(MicrometerHttpClientMetricsRecorder recorder, HttpRequest request, String path, SocketAddress remoteAddress, SocketAddress proxyAddress) {
            super((carrier, key, value) -> Objects.requireNonNull(carrier).headers().set(key, (Object)value));
            this.recorder = recorder;
            this.method = request.method().name();
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)remoteAddress;
                this.netPeerName = address.getHostString();
                this.netPeerPort = address.getPort() + "";
            } else {
                this.netPeerName = remoteAddress.toString();
                this.netPeerPort = "";
            }
            this.path = path;
            this.proxyAddress = Metrics.formatSocketAddress((SocketAddress)proxyAddress);
            this.setCarrier(request);
            this.setContextualName(HTTP_PREFIX + this.method);
        }

        @Override
        public Observation.Context get() {
            return this;
        }

        public Timer getTimer() {
            if (this.proxyAddress == null) {
                return this.recorder.getResponseTimeTimer(this.getName(), this.netPeerName + ":" + this.netPeerPort, this.path, this.method, this.status);
            }
            return this.recorder.getResponseTimeTimer(this.getName(), this.netPeerName + ":" + this.netPeerPort, this.proxyAddress, this.path, this.method, this.status);
        }

        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of((String[])new String[]{HttpClientObservations.ResponseTimeHighCardinalityTags.REACTOR_NETTY_TYPE.asString(), TYPE, HttpClientObservations.ResponseTimeHighCardinalityTags.HTTP_URL.asString(), this.path, HttpClientObservations.ResponseTimeHighCardinalityTags.HTTP_STATUS_CODE.asString(), this.status, HttpClientObservations.ResponseTimeHighCardinalityTags.NET_PEER_NAME.asString(), this.netPeerName, HttpClientObservations.ResponseTimeHighCardinalityTags.NET_PEER_PORT.asString(), this.netPeerPort});
        }

        public KeyValues getLowCardinalityKeyValues() {
            if (this.proxyAddress == null) {
                return KeyValues.of((String[])new String[]{HttpClientObservations.ResponseTimeLowCardinalityTags.METHOD.asString(), this.method, HttpClientObservations.ResponseTimeLowCardinalityTags.REMOTE_ADDRESS.asString(), this.netPeerName + ":" + this.netPeerPort, HttpClientObservations.ResponseTimeLowCardinalityTags.STATUS.asString(), this.status, HttpClientObservations.ResponseTimeLowCardinalityTags.URI.asString(), this.path});
            }
            return KeyValues.of((String[])new String[]{HttpClientObservations.ResponseTimeLowCardinalityTags.METHOD.asString(), this.method, HttpClientObservations.ResponseTimeLowCardinalityTags.REMOTE_ADDRESS.asString(), this.netPeerName + ":" + this.netPeerPort, HttpClientObservations.ResponseTimeLowCardinalityTags.PROXY_ADDRESS.asString(), this.proxyAddress, HttpClientObservations.ResponseTimeLowCardinalityTags.STATUS.asString(), this.status, HttpClientObservations.ResponseTimeLowCardinalityTags.URI.asString(), this.path});
        }
    }
}

