/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class SelfRenderingSqmFunction<T>
extends SqmFunction<T> {
    private final ReturnableType<T> impliedResultType;
    private final ArgumentsValidator argumentsValidator;
    private final FunctionReturnTypeResolver returnTypeResolver;
    private final FunctionRenderingSupport renderingSupport;
    private ReturnableType<?> resultType;

    public SelfRenderingSqmFunction(SqmFunctionDescriptor descriptor, FunctionRenderingSupport renderingSupport, List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(name, descriptor, impliedResultType, arguments, nodeBuilder);
        this.renderingSupport = renderingSupport;
        this.impliedResultType = impliedResultType;
        this.argumentsValidator = argumentsValidator;
        this.returnTypeResolver = returnTypeResolver;
    }

    @Override
    public SelfRenderingSqmFunction<T> copy(SqmCopyContext context) {
        SelfRenderingSqmFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
        for (SqmTypedNode<?> argument : this.getArguments()) {
            arguments.add(argument.copy(context));
        }
        SelfRenderingSqmFunction<T> expression = context.registerCopy(this, new SelfRenderingSqmFunction<T>(this.getFunctionDescriptor(), this.getRenderingSupport(), arguments, this.getImpliedResultType(), this.getArgumentsValidator(), this.getReturnTypeResolver(), this.nodeBuilder(), this.getFunctionName()));
        this.copyTo(expression, context);
        return expression;
    }

    public FunctionRenderingSupport getRenderingSupport() {
        return this.renderingSupport;
    }

    protected ReturnableType<T> getImpliedResultType() {
        return this.impliedResultType;
    }

    protected ArgumentsValidator getArgumentsValidator() {
        return this.argumentsValidator;
    }

    protected FunctionReturnTypeResolver getReturnTypeResolver() {
        return this.returnTypeResolver;
    }

    protected List<SqlAstNode> resolveSqlAstArguments(List<? extends SqmTypedNode<?>> sqmArguments, SqmToSqlAstConverter walker) {
        if (sqmArguments == null || sqmArguments.isEmpty()) {
            return Collections.emptyList();
        }
        FunctionArgumentTypeResolver argumentTypeResolver = this.getFunctionDescriptor() instanceof AbstractSqmFunctionDescriptor ? ((AbstractSqmFunctionDescriptor)this.getFunctionDescriptor()).getArgumentTypeResolver() : null;
        if (argumentTypeResolver == null) {
            ArrayList<SqlAstNode> sqlAstArguments = new ArrayList<SqlAstNode>(sqmArguments.size());
            for (int i = 0; i < sqmArguments.size(); ++i) {
                sqlAstArguments.add((SqlAstNode)sqmArguments.get(i).accept(walker));
            }
            return sqlAstArguments;
        }
        FunctionArgumentTypeResolverTypeAccess typeAccess = new FunctionArgumentTypeResolverTypeAccess(walker, this, argumentTypeResolver);
        ArrayList<SqlAstNode> sqlAstArguments = new ArrayList<SqlAstNode>(sqmArguments.size());
        for (int i = 0; i < sqmArguments.size(); ++i) {
            typeAccess.argumentIndex = i;
            sqlAstArguments.add((SqlAstNode)walker.visitWithInferredType(sqmArguments.get(i), typeAccess));
        }
        return sqlAstArguments;
    }

    @Override
    public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
        ReturnableType<?> resultType = this.resolveResultType(walker.getCreationContext().getMappingMetamodel().getTypeConfiguration());
        List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
        if (this.argumentsValidator != null) {
            this.argumentsValidator.validateSqlTypes(arguments, this.getFunctionName());
        }
        return new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), arguments, resultType, resultType == null ? null : this.getMappingModelExpressible(walker, resultType, arguments));
    }

    @Override
    public SqmExpressible<T> getNodeType() {
        SqmExpressible nodeType = super.getNodeType();
        if (nodeType == null) {
            nodeType = this.resolveResultType(this.nodeBuilder().getTypeConfiguration());
        }
        return nodeType;
    }

    protected ReturnableType<?> resolveResultType(TypeConfiguration typeConfiguration) {
        if (this.resultType == null) {
            this.resultType = this.returnTypeResolver.resolveFunctionReturnType(this.impliedResultType, this.getArguments(), typeConfiguration);
            this.setExpressibleType(this.resultType);
        }
        return this.resultType;
    }

    @Deprecated(forRemoval=true)
    protected MappingModelExpressible<?> getMappingModelExpressible(SqmToSqlAstConverter walker, ReturnableType<?> resultType) {
        return this.getMappingModelExpressible(walker, resultType, this.resolveSqlAstArguments(this.getArguments(), walker));
    }

    protected MappingModelExpressible<?> getMappingModelExpressible(SqmToSqlAstConverter walker, ReturnableType<?> resultType, List<SqlAstNode> arguments) {
        MappingModelExpressible mapping = resultType instanceof MappingModelExpressible ? (MappingModelExpressible)((Object)resultType) : this.returnTypeResolver.resolveFunctionReturnType(() -> {
            try {
                MappingMetamodelImplementor domainModel = walker.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel();
                return (BasicValuedMapping)domainModel.resolveMappingExpressible(this.getNodeType(), walker.getFromClauseAccess()::getTableGroup);
            }
            catch (Exception e) {
                return null;
            }
        }, arguments);
        return mapping;
    }

    private static class FunctionArgumentTypeResolverTypeAccess
    implements Supplier<MappingModelExpressible<?>> {
        private final SqmToSqlAstConverter converter;
        private final SqmFunction<?> function;
        private final FunctionArgumentTypeResolver argumentTypeResolver;
        private int argumentIndex;

        public FunctionArgumentTypeResolverTypeAccess(SqmToSqlAstConverter converter, SqmFunction<?> function, FunctionArgumentTypeResolver argumentTypeResolver) {
            this.converter = converter;
            this.function = function;
            this.argumentTypeResolver = argumentTypeResolver;
        }

        @Override
        public MappingModelExpressible<?> get() {
            return this.argumentTypeResolver.resolveFunctionArgumentType(this.function, this.argumentIndex, this.converter);
        }
    }
}

