/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import org.dbunit.util.concurrent.BoundedChannel;
import org.dbunit.util.concurrent.LinkedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronousChannel
implements BoundedChannel {
    private static final Logger logger = LoggerFactory.getLogger(SynchronousChannel.class);
    protected static final Object CANCELLED = new Object();
    protected final Queue waitingPuts = new Queue();
    protected final Queue waitingTakes = new Queue();

    @Override
    public int capacity() {
        logger.debug("capacity() - start");
        return 0;
    }

    @Override
    public Object peek() {
        logger.debug("peek() - start");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object x) throws InterruptedException {
        Object object;
        LinkedNode item;
        logger.debug("put(x={}) - start", x);
        if (x == null) {
            throw new IllegalArgumentException();
        }
        while (true) {
            LinkedNode slot;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            item = null;
            object = this;
            synchronized (object) {
                slot = this.waitingTakes.deq();
                if (slot == null) {
                    item = new LinkedNode(x);
                    this.waitingPuts.enq(item);
                }
            }
            if (slot == null) break;
            object = slot;
            synchronized (object) {
                if (slot.value != CANCELLED) {
                    slot.value = x;
                    slot.notify();
                    return;
                }
            }
        }
        object = item;
        synchronized (object) {
            try {
                while (item.value != null) {
                    item.wait();
                }
                return;
            }
            catch (InterruptedException ie) {
                if (item.value == null) {
                    Thread.currentThread().interrupt();
                    return;
                }
                item.value = CANCELLED;
                throw ie;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object take() throws InterruptedException {
        Object x;
        Object object;
        LinkedNode slot;
        logger.debug("take() - start");
        while (true) {
            LinkedNode item;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            slot = null;
            object = this;
            synchronized (object) {
                item = this.waitingPuts.deq();
                if (item == null) {
                    slot = new LinkedNode();
                    this.waitingTakes.enq(slot);
                }
            }
            if (item == null) break;
            object = item;
            synchronized (object) {
                x = item.value;
                if (x != CANCELLED) {
                    item.value = null;
                    item.next = null;
                    item.notify();
                    return x;
                }
            }
        }
        object = slot;
        synchronized (object) {
            try {
                while (true) {
                    if ((x = slot.value) != null) {
                        slot.value = null;
                        slot.next = null;
                        return x;
                    }
                    slot.wait();
                }
            }
            catch (InterruptedException ie) {
                Object x2 = slot.value;
                if (x2 != null) {
                    slot.value = null;
                    slot.next = null;
                    Thread.currentThread().interrupt();
                    return x2;
                }
                slot.value = CANCELLED;
                throw ie;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Object x, long msecs) throws InterruptedException {
        LinkedNode item;
        if (logger.isDebugEnabled()) {
            logger.debug("offer(x={}, msecs={}) - start", x, (Object)String.valueOf(msecs));
        }
        if (x == null) {
            throw new IllegalArgumentException();
        }
        long waitTime = msecs;
        long startTime = 0L;
        do {
            LinkedNode slot;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            item = null;
            Object object = this;
            synchronized (object) {
                slot = this.waitingTakes.deq();
                if (slot == null) {
                    if (waitTime <= 0L) {
                        return false;
                    }
                    item = new LinkedNode(x);
                    this.waitingPuts.enq(item);
                }
            }
            if (slot != null) {
                object = slot;
                synchronized (object) {
                    if (slot.value != CANCELLED) {
                        slot.value = x;
                        slot.notify();
                        return true;
                    }
                }
            }
            long now = System.currentTimeMillis();
            if (startTime == 0L) {
                startTime = now;
                continue;
            }
            waitTime = msecs - (now - startTime);
        } while (item == null);
        LinkedNode linkedNode = item;
        synchronized (linkedNode) {
            try {
                while (true) {
                    if (item.value == null) {
                        return true;
                    }
                    if (waitTime <= 0L) {
                        item.value = CANCELLED;
                        return false;
                    }
                    item.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - startTime);
                }
            }
            catch (InterruptedException ie) {
                if (item.value == null) {
                    Thread.currentThread().interrupt();
                    return true;
                }
                item.value = CANCELLED;
                throw ie;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object poll(long msecs) throws InterruptedException {
        LinkedNode slot;
        if (logger.isDebugEnabled()) {
            logger.debug("poll(msecs={}) - start", (Object)String.valueOf(msecs));
        }
        long waitTime = msecs;
        long startTime = 0L;
        do {
            LinkedNode item;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            slot = null;
            Object object = this;
            synchronized (object) {
                item = this.waitingPuts.deq();
                if (item == null) {
                    if (waitTime <= 0L) {
                        return null;
                    }
                    slot = new LinkedNode();
                    this.waitingTakes.enq(slot);
                }
            }
            if (item != null) {
                object = item;
                synchronized (object) {
                    Object x = item.value;
                    if (x != CANCELLED) {
                        item.value = null;
                        item.next = null;
                        item.notify();
                        return x;
                    }
                }
            }
            long now = System.currentTimeMillis();
            if (startTime == 0L) {
                startTime = now;
                continue;
            }
            waitTime = msecs - (now - startTime);
        } while (slot == null);
        LinkedNode linkedNode = slot;
        synchronized (linkedNode) {
            try {
                while (true) {
                    Object x;
                    if ((x = slot.value) != null) {
                        slot.value = null;
                        slot.next = null;
                        return x;
                    }
                    if (waitTime <= 0L) {
                        slot.value = CANCELLED;
                        return null;
                    }
                    slot.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - startTime);
                }
            }
            catch (InterruptedException ie) {
                Object x = slot.value;
                if (x != null) {
                    slot.value = null;
                    slot.next = null;
                    Thread.currentThread().interrupt();
                    return x;
                }
                slot.value = CANCELLED;
                throw ie;
            }
        }
    }

    protected static class Queue {
        private static final Logger logger = LoggerFactory.getLogger(Queue.class);
        protected LinkedNode head;
        protected LinkedNode last;

        protected Queue() {
        }

        protected void enq(LinkedNode p) {
            logger.debug("enq(p={}) - start", (Object)p);
            this.last = this.last == null ? (this.head = p) : (this.last.next = p);
        }

        protected LinkedNode deq() {
            logger.debug("deq() - start");
            LinkedNode p = this.head;
            if (p != null && (this.head = p.next) == null) {
                this.last = null;
            }
            return p;
        }
    }
}

