/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.incubator.codec.quic.QLogConfiguration;
import io.netty.incubator.codec.quic.Quic;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicChannelConfig;
import io.netty.incubator.codec.quic.QuicClientSessionCache;
import io.netty.incubator.codec.quic.QuicClosedChannelException;
import io.netty.incubator.codec.quic.QuicConnectionAddress;
import io.netty.incubator.codec.quic.QuicConnectionCloseEvent;
import io.netty.incubator.codec.quic.QuicConnectionEvent;
import io.netty.incubator.codec.quic.QuicConnectionStats;
import io.netty.incubator.codec.quic.QuicDatagramExtensionEvent;
import io.netty.incubator.codec.quic.QuicSslEngine;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicStreamIdGenerator;
import io.netty.incubator.codec.quic.QuicStreamLimitChangedEvent;
import io.netty.incubator.codec.quic.QuicStreamType;
import io.netty.incubator.codec.quic.QuicTransportParameters;
import io.netty.incubator.codec.quic.Quiche;
import io.netty.incubator.codec.quic.QuicheQuicChannelConfig;
import io.netty.incubator.codec.quic.QuicheQuicConnection;
import io.netty.incubator.codec.quic.QuicheQuicConnectionStats;
import io.netty.incubator.codec.quic.QuicheQuicSslEngine;
import io.netty.incubator.codec.quic.QuicheQuicStreamChannel;
import io.netty.incubator.codec.quic.QuicheRecvInfo;
import io.netty.incubator.codec.quic.QuicheSendInfo;
import io.netty.incubator.codec.quic.SegmentedDatagramPacketAllocator;
import io.netty.incubator.codec.quic.SockaddrIn;
import io.netty.incubator.codec.quic.SslEarlyDataReadyEvent;
import io.netty.util.AttributeKey;
import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;

final class QuicheQuicChannel
extends AbstractChannel
implements QuicChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(QuicheQuicChannel.class);
    private static final String QLOG_FILE_EXTENSION = ".qlog";
    private final ChannelFutureListener continueSendingListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture channelFuture) {
            if (QuicheQuicChannel.this.connectionSend()) {
                QuicheQuicChannel.this.flushParent();
            }
        }
    };
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private final long[] readableStreams = new long[128];
    private final long[] writableStreams = new long[128];
    private final LongObjectMap<QuicheQuicStreamChannel> streams = new LongObjectHashMap();
    private final QuicheQuicChannelConfig config = new QuicheQuicChannelConfig(this);
    private final boolean server;
    private final QuicStreamIdGenerator idGenerator;
    private final ChannelHandler streamHandler;
    private final Map.Entry<ChannelOption<?>, Object>[] streamOptionsArray;
    private final Map.Entry<AttributeKey<?>, Object>[] streamAttrsArray;
    private final TimeoutHandler timeoutHandler;
    private Executor sslTaskExecutor;
    private boolean inFireChannelReadCompleteQueue;
    private boolean fireChannelReadCompletePending;
    private ByteBuf finBuffer;
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private QuicConnectionAddress connectAddress;
    private ByteBuffer key;
    private CloseData closeData;
    private QuicConnectionCloseEvent connectionCloseEvent;
    private QuicConnectionStats statsAtClose;
    private InetSocketAddress local;
    private InetSocketAddress remote;
    private boolean supportsDatagram;
    private boolean recvDatagramPending;
    private boolean datagramReadable;
    private boolean recvStreamPending;
    private boolean streamReadable;
    private boolean handshakeCompletionNotified;
    private boolean earlyDataReadyNotified;
    private int reantranceGuard = 0;
    private static final int IN_RECV = 2;
    private static final int IN_CONNECTION_SEND = 4;
    private static final int IN_HANDLE_WRITABLE_STREAMS = 8;
    private static final int IN_FORCE_CLOSE = 16;
    private static final int CLOSED = 0;
    private static final int OPEN = 1;
    private static final int ACTIVE = 2;
    private volatile int state;
    private volatile boolean timedOut;
    private volatile String traceId;
    private volatile QuicheQuicConnection connection;
    private volatile QuicConnectionAddress remoteIdAddr;
    private volatile QuicConnectionAddress localIdAdrr;
    private static final AtomicLongFieldUpdater<QuicheQuicChannel> UNI_STREAMS_LEFT_UPDATER = AtomicLongFieldUpdater.newUpdater(QuicheQuicChannel.class, "uniStreamsLeft");
    private volatile long uniStreamsLeft;
    private static final AtomicLongFieldUpdater<QuicheQuicChannel> BIDI_STREAMS_LEFT_UPDATER = AtomicLongFieldUpdater.newUpdater(QuicheQuicChannel.class, "bidiStreamsLeft");
    private volatile long bidiStreamsLeft;

    private QuicheQuicChannel(Channel parent, boolean server, ByteBuffer key, InetSocketAddress local, InetSocketAddress remote, boolean supportsDatagram, ChannelHandler streamHandler, Map.Entry<ChannelOption<?>, Object>[] streamOptionsArray, Map.Entry<AttributeKey<?>, Object>[] streamAttrsArray, Consumer<QuicheQuicChannel> timeoutTask, Executor sslTaskExecutor) {
        super(parent);
        this.server = server;
        this.idGenerator = new QuicStreamIdGenerator(server);
        this.key = key;
        this.state = 1;
        this.supportsDatagram = supportsDatagram;
        this.local = local;
        this.remote = remote;
        this.streamHandler = streamHandler;
        this.streamOptionsArray = streamOptionsArray;
        this.streamAttrsArray = streamAttrsArray;
        this.timeoutHandler = new TimeoutHandler(timeoutTask);
        this.sslTaskExecutor = sslTaskExecutor == null ? ImmediateExecutor.INSTANCE : sslTaskExecutor;
    }

    static QuicheQuicChannel forClient(Channel parent, InetSocketAddress local, InetSocketAddress remote, ChannelHandler streamHandler, Map.Entry<ChannelOption<?>, Object>[] streamOptionsArray, Map.Entry<AttributeKey<?>, Object>[] streamAttrsArray) {
        return new QuicheQuicChannel(parent, false, null, local, remote, false, streamHandler, streamOptionsArray, streamAttrsArray, null, null);
    }

    static QuicheQuicChannel forServer(Channel parent, ByteBuffer key, InetSocketAddress local, InetSocketAddress remote, boolean supportsDatagram, ChannelHandler streamHandler, Map.Entry<ChannelOption<?>, Object>[] streamOptionsArray, Map.Entry<AttributeKey<?>, Object>[] streamAttrsArray, Consumer<QuicheQuicChannel> timeoutTask, Executor sslTaskExecutor) {
        return new QuicheQuicChannel(parent, true, key, local, remote, supportsDatagram, streamHandler, streamOptionsArray, streamAttrsArray, timeoutTask, sslTaskExecutor);
    }

    @Override
    public boolean isTimedOut() {
        return this.timedOut;
    }

    @Override
    public SSLEngine sslEngine() {
        QuicheQuicConnection connection = this.connection;
        return connection == null ? null : connection.engine();
    }

    private void notifyAboutHandshakeCompletionIfNeeded(SSLHandshakeException cause) {
        if (this.handshakeCompletionNotified) {
            return;
        }
        if (cause != null) {
            this.pipeline().fireUserEventTriggered((Object)new SslHandshakeCompletionEvent((Throwable)cause));
            return;
        }
        QuicheQuicConnection connection = this.connection;
        if (connection == null) {
            return;
        }
        switch (connection.engine().getHandshakeStatus()) {
            case NOT_HANDSHAKING: 
            case FINISHED: {
                this.handshakeCompletionNotified = true;
                String sniHostname = connection.engine().sniHostname;
                if (sniHostname != null) {
                    connection.engine().sniHostname = null;
                    this.pipeline().fireUserEventTriggered((Object)new SniCompletionEvent(sniHostname));
                }
                this.pipeline().fireUserEventTriggered((Object)SslHandshakeCompletionEvent.SUCCESS);
                break;
            }
        }
    }

    @Override
    public long peerAllowedStreams(QuicStreamType type) {
        switch (type) {
            case BIDIRECTIONAL: {
                return this.bidiStreamsLeft;
            }
            case UNIDIRECTIONAL: {
                return this.uniStreamsLeft;
            }
        }
        return 0L;
    }

    void attachQuicheConnection(QuicheQuicConnection connection) {
        this.connection = connection;
        byte[] traceId = Quiche.quiche_conn_trace_id(connection.address());
        if (traceId != null) {
            this.traceId = new String(traceId);
        }
        connection.initInfo(this.local, this.remote);
        QLogConfiguration configuration = this.config.getQLogConfiguration();
        if (configuration != null) {
            String fileName;
            File file = new File(configuration.path());
            if (file.isDirectory()) {
                file.mkdir();
                fileName = this.traceId != null ? configuration.path() + File.separatorChar + this.traceId + "-" + this.id().asShortText() + QLOG_FILE_EXTENSION : configuration.path() + File.separatorChar + this.id().asShortText() + QLOG_FILE_EXTENSION;
            } else {
                fileName = configuration.path();
            }
            if (!Quiche.quiche_conn_set_qlog_path(connection.address(), fileName, configuration.logTitle(), configuration.logDescription())) {
                logger.info("Unable to create qlog file: {} ", (Object)fileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(Function<QuicChannel, ? extends QuicSslEngine> engineProvider, Executor sslTaskExecutor, long configAddr, int localConnIdLength, boolean supportsDatagram, ByteBuffer fromSockaddrMemory, ByteBuffer toSockaddrMemory) throws Exception {
        assert (this.connection == null);
        assert (this.traceId == null);
        assert (this.key == null);
        this.sslTaskExecutor = sslTaskExecutor;
        QuicConnectionAddress address = this.connectAddress;
        if (address == QuicConnectionAddress.EPHEMERAL) {
            address = QuicConnectionAddress.random(localConnIdLength);
        } else if (address.connId.remaining() != localConnIdLength) {
            this.failConnectPromiseAndThrow(new IllegalArgumentException("connectionAddress has length " + address.connId.remaining() + " instead of " + localConnIdLength));
        }
        QuicSslEngine engine = engineProvider.apply(this);
        if (!(engine instanceof QuicheQuicSslEngine)) {
            this.failConnectPromiseAndThrow(new IllegalArgumentException("QuicSslEngine is not of type " + QuicheQuicSslEngine.class.getSimpleName()));
            return;
        }
        if (!engine.getUseClientMode()) {
            this.failConnectPromiseAndThrow(new IllegalArgumentException("QuicSslEngine is not create in client mode"));
        }
        QuicheQuicSslEngine quicheEngine = (QuicheQuicSslEngine)engine;
        ByteBuffer connectId = address.connId.duplicate();
        ByteBuf idBuffer = this.alloc().directBuffer(connectId.remaining()).writeBytes(connectId.duplicate());
        try {
            byte[] sessionBytes;
            int fromSockaddrLen = SockaddrIn.setAddress(fromSockaddrMemory, this.local);
            int toSockaddrLen = SockaddrIn.setAddress(toSockaddrMemory, this.remote);
            QuicheQuicConnection connection = quicheEngine.createConnection(ssl -> Quiche.quiche_conn_new_with_tls(Quiche.readerMemoryAddress(idBuffer), idBuffer.readableBytes(), -1L, -1, Quiche.memoryAddressWithPosition(fromSockaddrMemory), fromSockaddrLen, Quiche.memoryAddressWithPosition(toSockaddrMemory), toSockaddrLen, configAddr, ssl, false));
            if (connection == null) {
                this.failConnectPromiseAndThrow(new ConnectException());
                return;
            }
            this.attachQuicheConnection(connection);
            QuicClientSessionCache sessionCache = quicheEngine.ctx.getSessionCache();
            if (sessionCache != null && (sessionBytes = sessionCache.getSession(quicheEngine.getSession().getPeerHost(), quicheEngine.getSession().getPeerPort())) != null) {
                Quiche.quiche_conn_set_session(connection.address(), sessionBytes);
            }
            this.supportsDatagram = supportsDatagram;
            this.key = connectId;
        }
        finally {
            idBuffer.release();
        }
    }

    private void failConnectPromiseAndThrow(Exception e) throws Exception {
        this.tryFailConnectPromise(e);
        throw e;
    }

    private boolean tryFailConnectPromise(Exception e) {
        ChannelPromise promise = this.connectPromise;
        if (promise != null) {
            this.connectPromise = null;
            promise.tryFailure((Throwable)e);
            return true;
        }
        return false;
    }

    ByteBuffer key() {
        return this.key;
    }

    private boolean closeAllIfConnectionClosed() {
        if (this.connection.isClosed()) {
            this.forceClose();
            return true;
        }
        return false;
    }

    boolean markInFireChannelReadCompleteQueue() {
        if (this.inFireChannelReadCompleteQueue) {
            return false;
        }
        this.inFireChannelReadCompleteQueue = true;
        return true;
    }

    private void failPendingConnectPromise() {
        ChannelPromise promise = this.connectPromise;
        if (promise != null) {
            this.connectPromise = null;
            promise.tryFailure((Throwable)new QuicClosedChannelException(this.connectionCloseEvent));
        }
    }

    void forceClose() {
        if (this.isConnDestroyed() || (this.reantranceGuard & 0x10) != 0) {
            return;
        }
        this.reantranceGuard |= 0x10;
        QuicheQuicConnection conn = this.connection;
        this.unsafe().close(this.voidPromise());
        this.statsAtClose = this.collectStats0(conn, (Promise<QuicConnectionStats>)this.eventLoop().newPromise());
        try {
            this.failPendingConnectPromise();
            this.state = 0;
            this.timedOut = Quiche.quiche_conn_is_timed_out(conn.address());
            this.closeStreams();
            if (this.finBuffer != null) {
                this.finBuffer.release();
                this.finBuffer = null;
            }
            this.state = 0;
            this.timeoutHandler.cancel();
        }
        finally {
            this.flushParent();
            this.connection = null;
            conn.free();
        }
    }

    protected DefaultChannelPipeline newChannelPipeline() {
        return new DefaultChannelPipeline(this){

            protected void onUnhandledInboundMessage(ChannelHandlerContext ctx, Object msg) {
                if (msg instanceof QuicStreamChannel) {
                    QuicStreamChannel channel = (QuicStreamChannel)msg;
                    Quic.setupChannel((Channel)channel, QuicheQuicChannel.this.streamOptionsArray, QuicheQuicChannel.this.streamAttrsArray, QuicheQuicChannel.this.streamHandler, logger);
                    ctx.channel().eventLoop().register((Channel)channel);
                } else {
                    super.onUnhandledInboundMessage(ctx, msg);
                }
            }
        };
    }

    @Override
    public QuicChannel flush() {
        super.flush();
        return this;
    }

    @Override
    public QuicChannel read() {
        super.read();
        return this;
    }

    @Override
    public Future<QuicStreamChannel> createStream(QuicStreamType type, ChannelHandler handler, Promise<QuicStreamChannel> promise) {
        if (this.eventLoop().inEventLoop()) {
            ((QuicChannelUnsafe)this.unsafe()).connectStream(type, handler, promise);
        } else {
            this.eventLoop().execute(() -> ((QuicChannelUnsafe)this.unsafe()).connectStream(type, handler, promise));
        }
        return promise;
    }

    @Override
    public ChannelFuture close(boolean applicationClose, int error, ByteBuf reason, ChannelPromise promise) {
        if (this.eventLoop().inEventLoop()) {
            this.close0(applicationClose, error, reason, promise);
        } else {
            this.eventLoop().execute(() -> this.close0(applicationClose, error, reason, promise));
        }
        return promise;
    }

    private void close0(boolean applicationClose, int error, ByteBuf reason, ChannelPromise promise) {
        if (this.closeData == null) {
            if (!reason.hasMemoryAddress()) {
                ByteBuf copy = this.alloc().directBuffer(reason.readableBytes()).writeBytes(reason);
                reason.release();
                reason = copy;
            }
            this.closeData = new CloseData(applicationClose, error, reason);
            promise.addListener((GenericFutureListener)this.closeData);
        } else {
            reason.release();
        }
        this.close(promise);
    }

    public String toString() {
        String traceId = this.traceId;
        if (traceId == null) {
            return "()" + super.toString();
        }
        return '(' + traceId + ')' + super.toString();
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new QuicChannelUnsafe();
    }

    protected boolean isCompatible(EventLoop eventLoop) {
        return this.parent().eventLoop() == eventLoop;
    }

    protected SocketAddress localAddress0() {
        return this.localIdAdrr;
    }

    protected SocketAddress remoteAddress0() {
        return this.remoteIdAddr;
    }

    protected void doBind(SocketAddress socketAddress) {
        throw new UnsupportedOperationException();
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    protected void doClose() throws Exception {
        ByteBuf reason;
        int err;
        boolean app;
        this.state = 0;
        if (this.closeData == null) {
            app = false;
            err = 0;
            reason = Unpooled.EMPTY_BUFFER;
        } else {
            app = this.closeData.applicationClose;
            err = this.closeData.err;
            reason = this.closeData.reason;
            this.closeData = null;
        }
        boolean written = this.connectionSend();
        this.failPendingConnectPromise();
        Quiche.throwIfError(Quiche.quiche_conn_close(this.connectionAddressChecked(), app, err, Quiche.readerMemoryAddress(reason), reason.readableBytes()));
        if (written |= this.connectionSend()) {
            this.forceFlushParent();
        }
    }

    protected void doBeginRead() {
        this.recvDatagramPending = true;
        this.recvStreamPending = true;
        if (this.datagramReadable || this.streamReadable) {
            ((QuicChannelUnsafe)this.unsafe()).recv();
        }
    }

    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof ByteBuf) {
            return msg;
        }
        throw new UnsupportedOperationException("Unsupported message type: " + StringUtil.simpleClassName((Object)msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        if (!this.supportsDatagram) {
            throw new UnsupportedOperationException("Datagram extension is not supported");
        }
        boolean sendSomething = false;
        boolean retry = false;
        try {
            while (true) {
                int res;
                ByteBuf buffer;
                if ((buffer = (ByteBuf)channelOutboundBuffer.current()) == null) {
                    return;
                }
                int readable = buffer.readableBytes();
                if (readable == 0) {
                    channelOutboundBuffer.remove();
                    continue;
                }
                if (!buffer.isDirect() || buffer.nioBufferCount() > 1) {
                    ByteBuf tmpBuffer = this.alloc().directBuffer(readable);
                    try {
                        tmpBuffer.writeBytes(buffer, buffer.readerIndex(), readable);
                        res = this.sendDatagram(tmpBuffer);
                    }
                    finally {
                        tmpBuffer.release();
                    }
                } else {
                    res = this.sendDatagram(buffer);
                }
                if (res >= 0) {
                    channelOutboundBuffer.remove();
                    sendSomething = true;
                    retry = false;
                    continue;
                }
                if (res == Quiche.QUICHE_ERR_BUFFER_TOO_SHORT) {
                    retry = false;
                    channelOutboundBuffer.remove((Throwable)Quiche.newException(res));
                    continue;
                }
                if (res == Quiche.QUICHE_ERR_INVALID_STATE) {
                    throw new UnsupportedOperationException("Remote peer does not support Datagram extension", Quiche.newException(res));
                }
                if (!Quiche.throwIfError(res)) continue;
                if (retry) {
                    while (channelOutboundBuffer.remove()) {
                    }
                    return;
                }
                sendSomething = false;
                if (this.connectionSend()) {
                    this.forceFlushParent();
                }
                retry = true;
            }
        }
        finally {
            if (sendSomething && this.connectionSend()) {
                this.flushParent();
            }
        }
    }

    private int sendDatagram(ByteBuf buf) throws ClosedChannelException {
        return Quiche.quiche_conn_dgram_send(this.connectionAddressChecked(), Quiche.readerMemoryAddress(buf), buf.readableBytes());
    }

    @Override
    public QuicChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return this.state >= 1;
    }

    public boolean isActive() {
        return this.state == 2;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    private void flushParent() {
        if (!this.inFireChannelReadCompleteQueue) {
            this.forceFlushParent();
        }
    }

    private void forceFlushParent() {
        this.parent().flush();
    }

    private long connectionAddressChecked() throws ClosedChannelException {
        if (this.isConnDestroyed()) {
            throw new ClosedChannelException();
        }
        return this.connection.address();
    }

    boolean freeIfClosed() {
        if (this.isConnDestroyed()) {
            return true;
        }
        return this.closeAllIfConnectionClosed();
    }

    private void closeStreams() {
        for (QuicheQuicStreamChannel stream : this.streams.values().toArray(new QuicheQuicStreamChannel[0])) {
            stream.unsafe().close(this.voidPromise());
        }
        this.streams.clear();
    }

    void streamPriority(long streamId, byte priority, boolean incremental) throws Exception {
        Quiche.throwIfError(Quiche.quiche_conn_stream_priority(this.connectionAddressChecked(), streamId, priority, incremental));
    }

    void streamClosed(long streamId) {
        this.streams.remove(streamId);
    }

    boolean isStreamLocalCreated(long streamId) {
        return (streamId & 1L) == (long)(this.server ? 1 : 0);
    }

    QuicStreamType streamType(long streamId) {
        return (streamId & 2L) == 0L ? QuicStreamType.BIDIRECTIONAL : QuicStreamType.UNIDIRECTIONAL;
    }

    void streamShutdown(long streamId, boolean read, boolean write, int err, ChannelPromise promise) {
        long connectionAddress;
        try {
            connectionAddress = this.connectionAddressChecked();
        }
        catch (ClosedChannelException e) {
            promise.setFailure((Throwable)e);
            return;
        }
        int res = 0;
        if (read) {
            res |= Quiche.quiche_conn_stream_shutdown(connectionAddress, streamId, Quiche.QUICHE_SHUTDOWN_READ, err);
        }
        if (write) {
            res |= Quiche.quiche_conn_stream_shutdown(connectionAddress, streamId, Quiche.QUICHE_SHUTDOWN_WRITE, err);
        }
        if (this.connectionSend()) {
            this.forceFlushParent();
        }
        Quiche.notifyPromise(res, promise);
    }

    void streamSendFin(long streamId) throws Exception {
        try {
            Quiche.throwIfError(this.streamSend0(streamId, Unpooled.EMPTY_BUFFER, true));
        }
        finally {
            if (this.connectionSend()) {
                this.flushParent();
            }
        }
    }

    int streamSend(long streamId, ByteBuf buffer, boolean fin) throws ClosedChannelException {
        if (buffer.nioBufferCount() == 1) {
            return this.streamSend0(streamId, buffer, fin);
        }
        ByteBuffer[] nioBuffers = buffer.nioBuffers();
        int lastIdx = nioBuffers.length - 1;
        int res = 0;
        for (int i = 0; i < lastIdx; ++i) {
            ByteBuffer nioBuffer = nioBuffers[i];
            while (nioBuffer.hasRemaining()) {
                int localRes = this.streamSend(streamId, nioBuffer, false);
                if (localRes <= 0) {
                    return res;
                }
                res += localRes;
                nioBuffer.position(nioBuffer.position() + localRes);
            }
        }
        int localRes = this.streamSend(streamId, nioBuffers[lastIdx], fin);
        if (localRes > 0) {
            res += localRes;
        }
        return res;
    }

    void connectionSendAndFlush() {
        if (this.inFireChannelReadCompleteQueue || (this.reantranceGuard & 8) != 0) {
            return;
        }
        if (this.connectionSend()) {
            this.flushParent();
        }
    }

    private int streamSend0(long streamId, ByteBuf buffer, boolean fin) throws ClosedChannelException {
        return Quiche.quiche_conn_stream_send(this.connectionAddressChecked(), streamId, Quiche.readerMemoryAddress(buffer), buffer.readableBytes(), fin);
    }

    private int streamSend(long streamId, ByteBuffer buffer, boolean fin) throws ClosedChannelException {
        return Quiche.quiche_conn_stream_send(this.connectionAddressChecked(), streamId, Quiche.memoryAddressWithPosition(buffer), buffer.remaining(), fin);
    }

    StreamRecvResult streamRecv(long streamId, ByteBuf buffer) throws Exception {
        if (this.finBuffer == null) {
            this.finBuffer = this.alloc().directBuffer(1);
        }
        int writerIndex = buffer.writerIndex();
        int recvLen = Quiche.quiche_conn_stream_recv(this.connectionAddressChecked(), streamId, Quiche.writerMemoryAddress(buffer), buffer.writableBytes(), Quiche.writerMemoryAddress(this.finBuffer));
        if (Quiche.throwIfError(recvLen)) {
            return StreamRecvResult.DONE;
        }
        buffer.writerIndex(writerIndex + recvLen);
        return this.finBuffer.getBoolean(0) ? StreamRecvResult.FIN : StreamRecvResult.OK;
    }

    void recv(InetSocketAddress recipient, InetSocketAddress sender, ByteBuf buffer) {
        ((QuicChannelUnsafe)this.unsafe()).connectionRecv(recipient, sender, buffer);
    }

    void writable() {
        boolean written = this.connectionSend();
        this.handleWritableStreams();
        if (written |= this.connectionSend()) {
            this.forceFlushParent();
        }
    }

    int streamCapacity(long streamId) {
        if (this.connection.isClosed()) {
            return 0;
        }
        return Quiche.quiche_conn_stream_capacity(this.connection.address(), streamId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleWritableStreams() {
        if (this.isConnDestroyed()) {
            return false;
        }
        this.reantranceGuard |= 8;
        try {
            long connAddr = this.connection.address();
            boolean mayNeedWrite = false;
            if (Quiche.quiche_conn_is_established(connAddr) || Quiche.quiche_conn_is_in_early_data(connAddr)) {
                long writableIterator = Quiche.quiche_conn_writable(connAddr);
                try {
                    int writable;
                    do {
                        writable = Quiche.quiche_stream_iter_next(writableIterator, this.writableStreams);
                        for (int i = 0; i < writable; ++i) {
                            long streamId = this.writableStreams[i];
                            QuicheQuicStreamChannel streamChannel = (QuicheQuicStreamChannel)this.streams.get(streamId);
                            if (streamChannel == null) continue;
                            int capacity = Quiche.quiche_conn_stream_capacity(connAddr, streamId);
                            if (capacity < 0) {
                                if (!Quiche.quiche_conn_stream_finished(connAddr, streamId)) {
                                    streamChannel.pipeline().fireExceptionCaught((Throwable)Quiche.newException(capacity));
                                }
                                streamChannel.forceClose();
                                continue;
                            }
                            if (!streamChannel.writable(capacity)) continue;
                            mayNeedWrite = true;
                        }
                    } while (writable >= this.writableStreams.length);
                }
                finally {
                    Quiche.quiche_stream_iter_free(writableIterator);
                }
            }
            boolean bl = mayNeedWrite;
            return bl;
        }
        finally {
            this.reantranceGuard &= 0xFFFFFFF7;
        }
    }

    void recvComplete() {
        try {
            if (this.isConnDestroyed()) {
                this.forceFlushParent();
                return;
            }
            this.fireChannelReadCompleteIfNeeded();
            this.connectionSend();
            this.forceFlushParent();
        }
        finally {
            this.inFireChannelReadCompleteQueue = false;
        }
    }

    private void fireChannelReadCompleteIfNeeded() {
        if (this.fireChannelReadCompletePending) {
            this.fireChannelReadCompletePending = false;
            this.pipeline().fireChannelReadComplete();
        }
    }

    private boolean isConnDestroyed() {
        return this.connection == null;
    }

    private void fireExceptionEvents(Throwable cause) {
        if (cause instanceof SSLHandshakeException) {
            this.notifyAboutHandshakeCompletionIfNeeded((SSLHandshakeException)cause);
        }
        this.pipeline().fireExceptionCaught(cause);
    }

    private boolean runTasksDirectly() {
        return this.sslTaskExecutor == null || this.sslTaskExecutor == ImmediateExecutor.INSTANCE || this.sslTaskExecutor == ImmediateEventExecutor.INSTANCE;
    }

    private void runAllTaskSend(Runnable task) {
        this.sslTaskExecutor.execute(this.decorateTaskSend(task));
    }

    private void runAll(Runnable task) {
        do {
            task.run();
        } while ((task = this.connection.sslTask()) != null);
    }

    private Runnable decorateTaskSend(Runnable task) {
        return () -> {
            try {
                this.runAll(task);
            }
            finally {
                this.eventLoop().execute(() -> {
                    if (this.connectionSend()) {
                        this.forceFlushParent();
                    }
                });
            }
        };
    }

    private boolean connectionSendSegments(SegmentedDatagramPacketAllocator segmentedDatagramPacketAllocator) {
        ArrayList<ByteBuf> bufferList = new ArrayList<ByteBuf>(segmentedDatagramPacketAllocator.maxNumSegments());
        long connAddr = this.connection.address();
        int maxDatagramSize = Quiche.quiche_conn_max_send_udp_payload_size(connAddr);
        int packetWasWritten = 0;
        boolean close = false;
        try {
            while (true) {
                int lastReadable;
                int segmentSize;
                boolean done;
                int written;
                int writerIndex;
                InetSocketAddress sendToAddress;
                ByteBuffer sendInfo;
                ByteBuf out;
                int len;
                block25: {
                    len = QuicheQuicChannel.calculateSendBufferLength(connAddr, maxDatagramSize);
                    out = this.alloc().directBuffer(len);
                    sendInfo = this.connection.nextSendInfo();
                    sendToAddress = this.remote;
                    writerIndex = out.writerIndex();
                    written = Quiche.quiche_conn_send(connAddr, Quiche.writerMemoryAddress(out), out.writableBytes(), Quiche.memoryAddressWithPosition(sendInfo));
                    if (written == 0) {
                        out.release();
                        continue;
                    }
                    try {
                        done = Quiche.throwIfError(written);
                    }
                    catch (Exception e) {
                        done = true;
                        close = Quiche.shouldClose(written);
                        if (this.tryFailConnectPromise(e)) break block25;
                        this.fireExceptionEvents(e);
                    }
                }
                int size = bufferList.size();
                if (done) {
                    out.release();
                    switch (size) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.parent().write((Object)new DatagramPacket((ByteBuf)bufferList.get(0), sendToAddress));
                            packetWasWritten = 1;
                            break;
                        }
                        default: {
                            segmentSize = QuicheQuicChannel.segmentSize(bufferList);
                            ByteBuf compositeBuffer = Unpooled.wrappedBuffer((ByteBuf[])bufferList.toArray(new ByteBuf[0]));
                            this.parent().write((Object)segmentedDatagramPacketAllocator.newPacket(compositeBuffer, segmentSize, sendToAddress));
                            packetWasWritten = 1;
                        }
                    }
                    bufferList.clear();
                    segmentSize = packetWasWritten;
                    return segmentSize != 0;
                }
                out.writerIndex(writerIndex + written);
                segmentSize = -1;
                if (this.connection.isSendInfoChanged()) {
                    InetSocketAddress oldRemote = this.remote;
                    this.remote = QuicheSendInfo.getToAddress(sendInfo);
                    this.local = QuicheSendInfo.getFromAddress(sendInfo);
                    this.pipeline().fireUserEventTriggered((Object)new QuicConnectionEvent(oldRemote, this.remote));
                    if (size > 0) {
                        segmentSize = QuicheQuicChannel.segmentSize(bufferList);
                    }
                } else if (size > 0 && ((lastReadable = QuicheQuicChannel.segmentSize(bufferList)) != out.readableBytes() || size == segmentedDatagramPacketAllocator.maxNumSegments())) {
                    segmentSize = lastReadable;
                }
                if (segmentSize != -1) {
                    boolean stop;
                    if (size == 1) {
                        stop = this.writePacket(new DatagramPacket((ByteBuf)bufferList.get(0), sendToAddress), maxDatagramSize, len);
                    } else {
                        ByteBuf compositeBuffer = Unpooled.wrappedBuffer((ByteBuf[])bufferList.toArray(new ByteBuf[0]));
                        stop = this.writePacket(segmentedDatagramPacketAllocator.newPacket(compositeBuffer, segmentSize, sendToAddress), maxDatagramSize, len);
                    }
                    bufferList.clear();
                    packetWasWritten = 1;
                    if (stop) {
                        if (out.isReadable()) {
                            this.parent().write((Object)new DatagramPacket(out, sendToAddress));
                        } else {
                            out.release();
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
                out.touch(bufferList);
                bufferList.add(out);
            }
        }
        finally {
            if (close) {
                this.unsafe().close(this.newPromise());
            }
        }
    }

    private static int segmentSize(List<ByteBuf> bufferList) {
        assert (!bufferList.isEmpty());
        int size = bufferList.size();
        return bufferList.get(size - 1).readableBytes();
    }

    private boolean connectionSendSimple() {
        long connAddr = this.connection.address();
        boolean packetWasWritten = false;
        boolean close = false;
        int maxDatagramSize = Quiche.quiche_conn_max_send_udp_payload_size(connAddr);
        while (true) {
            ByteBuffer sendInfo = this.connection.nextSendInfo();
            int len = QuicheQuicChannel.calculateSendBufferLength(connAddr, maxDatagramSize);
            ByteBuf out = this.alloc().directBuffer(len);
            int writerIndex = out.writerIndex();
            int written = Quiche.quiche_conn_send(connAddr, Quiche.writerMemoryAddress(out), out.writableBytes(), Quiche.memoryAddressWithPosition(sendInfo));
            try {
                if (Quiche.throwIfError(written)) {
                    out.release();
                }
            }
            catch (Exception e) {
                close = Quiche.shouldClose(written);
                out.release();
                if (!this.tryFailConnectPromise(e)) {
                    this.fireExceptionEvents(e);
                }
                break;
            }
            if (written == 0) {
                out.release();
                continue;
            }
            if (this.connection.isSendInfoChanged()) {
                InetSocketAddress oldRemote = this.remote;
                this.remote = QuicheSendInfo.getToAddress(sendInfo);
                this.local = QuicheSendInfo.getFromAddress(sendInfo);
                this.pipeline().fireUserEventTriggered((Object)new QuicConnectionEvent(oldRemote, this.remote));
            }
            out.writerIndex(writerIndex + written);
            boolean stop = this.writePacket(new DatagramPacket(out, this.remote), maxDatagramSize, len);
            packetWasWritten = true;
            if (stop) break;
        }
        if (close) {
            this.unsafe().close(this.newPromise());
        }
        return packetWasWritten;
    }

    private boolean writePacket(DatagramPacket packet, int maxDatagramSize, int len) {
        ChannelFuture future = this.parent().write((Object)packet);
        if (QuicheQuicChannel.isSendWindowUsed(maxDatagramSize, len)) {
            future.addListener((GenericFutureListener)this.continueSendingListener);
            return true;
        }
        return false;
    }

    private static boolean isSendWindowUsed(int maxDatagramSize, int len) {
        return len < maxDatagramSize;
    }

    private static int calculateSendBufferLength(long connAddr, int maxDatagramSize) {
        int len = Math.min(maxDatagramSize, Quiche.quiche_conn_send_quantum(connAddr));
        if (len <= 0) {
            return 8;
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectionSend() {
        if (this.isConnDestroyed()) {
            return false;
        }
        if ((this.reantranceGuard & 4) != 0) {
            this.notifyEarlyDataReadyIfNeeded();
            return false;
        }
        this.reantranceGuard |= 4;
        try {
            SegmentedDatagramPacketAllocator segmentedDatagramPacketAllocator = this.config.getSegmentedDatagramPacketAllocator();
            boolean packetWasWritten = segmentedDatagramPacketAllocator.maxNumSegments() > 0 ? this.connectionSendSegments(segmentedDatagramPacketAllocator) : this.connectionSendSimple();
            Runnable task = this.connection.sslTask();
            if (task != null) {
                if (this.runTasksDirectly()) {
                    do {
                        task.run();
                        this.notifyEarlyDataReadyIfNeeded();
                    } while ((task = this.connection.sslTask()) != null);
                    boolean bl = packetWasWritten | this.connectionSend();
                    return bl;
                }
                this.runAllTaskSend(task);
            } else {
                this.notifyEarlyDataReadyIfNeeded();
            }
            if (packetWasWritten) {
                this.timeoutHandler.scheduleTimeout();
            }
            boolean bl = packetWasWritten;
            return bl;
        }
        finally {
            this.reantranceGuard &= 0xFFFFFFFB;
        }
    }

    void finishConnect() {
        assert (!this.server);
        if (this.connectionSend()) {
            this.flushParent();
        }
    }

    private void notifyEarlyDataReadyIfNeeded() {
        if (!this.server && !this.earlyDataReadyNotified && !this.isConnDestroyed() && Quiche.quiche_conn_is_in_early_data(this.connection.address())) {
            this.earlyDataReadyNotified = true;
            this.pipeline().fireUserEventTriggered((Object)SslEarlyDataReadyEvent.INSTANCE);
        }
    }

    static QuicheQuicChannel handleConnect(Function<QuicChannel, ? extends QuicSslEngine> sslEngineProvider, Executor sslTaskExecutor, SocketAddress address, long config, int localConnIdLength, boolean supportsDatagram, ByteBuffer fromSockaddrMemory, ByteBuffer toSockaddrMemory) throws Exception {
        if (address instanceof QuicheQuicChannelAddress) {
            QuicheQuicChannelAddress addr = (QuicheQuicChannelAddress)address;
            QuicheQuicChannel channel = addr.channel;
            channel.connect(sslEngineProvider, sslTaskExecutor, config, localConnIdLength, supportsDatagram, fromSockaddrMemory, toSockaddrMemory);
            return channel;
        }
        return null;
    }

    @Override
    public Future<QuicConnectionStats> collectStats(Promise<QuicConnectionStats> promise) {
        if (this.eventLoop().inEventLoop()) {
            this.collectStats0(promise);
        } else {
            this.eventLoop().execute(() -> this.collectStats0(promise));
        }
        return promise;
    }

    private void collectStats0(Promise<QuicConnectionStats> promise) {
        if (this.isConnDestroyed()) {
            promise.setSuccess((Object)this.statsAtClose);
            return;
        }
        this.collectStats0(this.connection, promise);
    }

    private QuicConnectionStats collectStats0(QuicheQuicConnection connection, Promise<QuicConnectionStats> promise) {
        long[] stats = Quiche.quiche_conn_stats(connection.address());
        if (stats == null) {
            promise.setFailure((Throwable)new IllegalStateException("native quiche_conn_stats(...) failed"));
            return null;
        }
        QuicheQuicConnectionStats connStats = new QuicheQuicConnectionStats(stats);
        promise.setSuccess((Object)connStats);
        return connStats;
    }

    @Override
    public QuicTransportParameters peerTransportParameters() {
        return this.connection.peerParameters();
    }

    private final class TimeoutHandler
    implements Runnable {
        private ScheduledFuture<?> timeoutFuture;
        private final Consumer<QuicheQuicChannel> timeoutTask;

        TimeoutHandler(Consumer<QuicheQuicChannel> timeoutTask) {
            this.timeoutTask = timeoutTask;
        }

        @Override
        public void run() {
            if (!QuicheQuicChannel.this.isConnDestroyed()) {
                long connAddr = QuicheQuicChannel.this.connection.address();
                this.timeoutFuture = null;
                Quiche.quiche_conn_on_timeout(connAddr);
                if (Quiche.quiche_conn_is_closed(connAddr)) {
                    QuicheQuicChannel.this.forceClose();
                    if (this.timeoutTask != null) {
                        this.timeoutTask.accept(QuicheQuicChannel.this);
                    }
                } else {
                    boolean send = QuicheQuicChannel.this.connectionSend();
                    if (send) {
                        QuicheQuicChannel.this.flushParent();
                    }
                    if (!QuicheQuicChannel.this.closeAllIfConnectionClosed()) {
                        this.scheduleTimeout();
                    }
                }
            }
        }

        void scheduleTimeout() {
            if (QuicheQuicChannel.this.isConnDestroyed()) {
                this.cancel();
                return;
            }
            long nanos = Quiche.quiche_conn_timeout_as_nanos(QuicheQuicChannel.this.connection.address());
            if (this.timeoutFuture == null) {
                this.timeoutFuture = QuicheQuicChannel.this.eventLoop().schedule((Runnable)this, nanos, TimeUnit.NANOSECONDS);
            } else {
                long remaining = this.timeoutFuture.getDelay(TimeUnit.NANOSECONDS);
                if (remaining <= 0L) {
                    this.cancel();
                    this.run();
                } else if (remaining > nanos) {
                    this.cancel();
                    this.timeoutFuture = QuicheQuicChannel.this.eventLoop().schedule((Runnable)this, nanos, TimeUnit.NANOSECONDS);
                }
            }
        }

        void cancel() {
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
                this.timeoutFuture = null;
            }
        }
    }

    private static final class QuicheQuicChannelAddress
    extends SocketAddress {
        final QuicheQuicChannel channel;

        QuicheQuicChannelAddress(QuicheQuicChannel channel) {
            this.channel = channel;
        }
    }

    private final class QuicChannelUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private QuicChannelUnsafe() {
            super((AbstractChannel)QuicheQuicChannel.this);
        }

        void connectStream(QuicStreamType type, ChannelHandler handler, Promise<QuicStreamChannel> promise) {
            long streamId = QuicheQuicChannel.this.idGenerator.nextStreamId(type == QuicStreamType.BIDIRECTIONAL);
            try {
                Quiche.throwIfError(QuicheQuicChannel.this.streamSend0(streamId, Unpooled.EMPTY_BUFFER, false));
            }
            catch (Exception e) {
                promise.setFailure((Throwable)e);
                return;
            }
            if (type == QuicStreamType.UNIDIRECTIONAL) {
                UNI_STREAMS_LEFT_UPDATER.decrementAndGet(QuicheQuicChannel.this);
            } else {
                BIDI_STREAMS_LEFT_UPDATER.decrementAndGet(QuicheQuicChannel.this);
            }
            QuicheQuicStreamChannel streamChannel = this.addNewStreamChannel(streamId);
            if (handler != null) {
                streamChannel.pipeline().addLast(new ChannelHandler[]{handler});
            }
            QuicheQuicChannel.this.eventLoop().register((Channel)streamChannel).addListener(f -> {
                if (f.isSuccess()) {
                    promise.setSuccess((Object)streamChannel);
                } else {
                    promise.setFailure(f.cause());
                    QuicheQuicChannel.this.streams.remove(streamId);
                }
            });
        }

        public void connect(SocketAddress remote, SocketAddress local, ChannelPromise channelPromise) {
            assert (QuicheQuicChannel.this.eventLoop().inEventLoop());
            if (QuicheQuicChannel.this.server) {
                channelPromise.setFailure((Throwable)new UnsupportedOperationException());
                return;
            }
            if (QuicheQuicChannel.this.connectPromise != null) {
                channelPromise.setFailure((Throwable)new ConnectionPendingException());
                return;
            }
            if (remote instanceof QuicConnectionAddress) {
                if (QuicheQuicChannel.this.key != null) {
                    channelPromise.setFailure((Throwable)new AlreadyConnectedException());
                    return;
                }
                QuicConnectionAddress address = (QuicConnectionAddress)remote;
                QuicheQuicChannel.this.connectPromise = channelPromise;
                QuicheQuicChannel.this.connectAddress = address;
                int connectTimeoutMillis = QuicheQuicChannel.this.config().getConnectTimeoutMillis();
                if (connectTimeoutMillis > 0) {
                    QuicheQuicChannel.this.connectTimeoutFuture = (ScheduledFuture)QuicheQuicChannel.this.eventLoop().schedule(() -> {
                        ChannelPromise connectPromise = QuicheQuicChannel.this.connectPromise;
                        if (connectPromise != null && !connectPromise.isDone() && connectPromise.tryFailure((Throwable)new ConnectTimeoutException("connection timed out: " + remote))) {
                            this.close(this.voidPromise());
                        }
                    }, (long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
                }
                QuicheQuicChannel.this.connectPromise.addListener(future -> {
                    if (future.isCancelled()) {
                        if (QuicheQuicChannel.this.connectTimeoutFuture != null) {
                            QuicheQuicChannel.this.connectTimeoutFuture.cancel(false);
                        }
                        QuicheQuicChannel.this.connectPromise = null;
                        this.close(this.voidPromise());
                    }
                });
                QuicheQuicChannel.this.parent().connect((SocketAddress)new QuicheQuicChannelAddress(QuicheQuicChannel.this));
                return;
            }
            channelPromise.setFailure((Throwable)new UnsupportedOperationException());
        }

        private void fireConnectCloseEventIfNeeded(long connAddr) {
            if (QuicheQuicChannel.this.connectionCloseEvent == null) {
                QuicheQuicChannel.this.connectionCloseEvent = Quiche.quiche_conn_peer_error(connAddr);
                if (QuicheQuicChannel.this.connectionCloseEvent != null) {
                    QuicheQuicChannel.this.pipeline().fireUserEventTriggered((Object)QuicheQuicChannel.this.connectionCloseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connectionRecv(InetSocketAddress recipient, InetSocketAddress sender, ByteBuf buffer) {
            if (QuicheQuicChannel.this.isConnDestroyed()) {
                return;
            }
            int bufferReadable = buffer.readableBytes();
            if (bufferReadable == 0) {
                return;
            }
            QuicheQuicChannel.this.reantranceGuard = QuicheQuicChannel.this.reantranceGuard | 2;
            boolean close = false;
            try {
                ByteBuf tmpBuffer = null;
                if (buffer.isReadOnly()) {
                    tmpBuffer = QuicheQuicChannel.this.alloc().directBuffer(buffer.readableBytes());
                    tmpBuffer.writeBytes(buffer);
                    buffer = tmpBuffer;
                }
                long memoryAddress = Quiche.readerMemoryAddress(buffer);
                ByteBuffer recvInfo = QuicheQuicChannel.this.connection.nextRecvInfo();
                QuicheRecvInfo.setRecvInfo(recvInfo, sender, recipient);
                InetSocketAddress oldRemote = QuicheQuicChannel.this.remote;
                if (QuicheQuicChannel.this.connection.isRecvInfoChanged()) {
                    QuicheQuicChannel.this.remote = sender;
                    QuicheQuicChannel.this.pipeline().fireUserEventTriggered((Object)new QuicConnectionEvent(oldRemote, sender));
                }
                QuicheQuicChannel.this.local = recipient;
                long connAddr = QuicheQuicChannel.this.connection.address();
                try {
                    int res;
                    do {
                        boolean done;
                        res = Quiche.quiche_conn_recv(connAddr, memoryAddress, bufferReadable, Quiche.memoryAddressWithPosition(recvInfo));
                        try {
                            done = Quiche.throwIfError(res);
                        }
                        catch (Exception e) {
                            done = true;
                            close = Quiche.shouldClose(res);
                            if (QuicheQuicChannel.this.tryFailConnectPromise(e)) {
                                break;
                            }
                            QuicheQuicChannel.this.fireExceptionEvents(e);
                        }
                        Runnable task = QuicheQuicChannel.this.connection.sslTask();
                        if (task != null) {
                            if (QuicheQuicChannel.this.runTasksDirectly()) {
                                do {
                                    task.run();
                                } while ((task = QuicheQuicChannel.this.connection.sslTask()) != null);
                                this.processReceived(connAddr);
                            } else {
                                this.runAllTaskRecv(task);
                            }
                        } else {
                            this.processReceived(connAddr);
                        }
                        if (done) {
                            break;
                        }
                        memoryAddress += (long)res;
                    } while ((bufferReadable -= res) > 0);
                }
                finally {
                    buffer.skipBytes((int)(memoryAddress - Quiche.readerMemoryAddress(buffer)));
                    if (tmpBuffer != null) {
                        tmpBuffer.release();
                    }
                }
                if (close) {
                    QuicheQuicChannel.this.unsafe().close(QuicheQuicChannel.this.newPromise());
                }
            }
            finally {
                QuicheQuicChannel.this.reantranceGuard = QuicheQuicChannel.this.reantranceGuard & 0xFFFFFFFD;
            }
        }

        private void processReceived(long connAddr) {
            if (this.handlePendingChannelActive()) {
                return;
            }
            QuicheQuicChannel.this.notifyAboutHandshakeCompletionIfNeeded(null);
            this.fireConnectCloseEventIfNeeded(connAddr);
            if (Quiche.quiche_conn_is_established(connAddr) || Quiche.quiche_conn_is_in_early_data(connAddr)) {
                long uniLeftOld = QuicheQuicChannel.this.uniStreamsLeft;
                long bidiLeftOld = QuicheQuicChannel.this.bidiStreamsLeft;
                if (uniLeftOld == 0L || bidiLeftOld == 0L) {
                    long uniLeft = Quiche.quiche_conn_peer_streams_left_uni(connAddr);
                    long bidiLeft = Quiche.quiche_conn_peer_streams_left_bidi(connAddr);
                    QuicheQuicChannel.this.uniStreamsLeft = uniLeft;
                    QuicheQuicChannel.this.bidiStreamsLeft = bidiLeft;
                    if (uniLeftOld != uniLeft || bidiLeftOld != bidiLeft) {
                        QuicheQuicChannel.this.pipeline().fireUserEventTriggered((Object)QuicStreamLimitChangedEvent.INSTANCE);
                    }
                }
                if (QuicheQuicChannel.this.handleWritableStreams()) {
                    QuicheQuicChannel.this.flushParent();
                }
                QuicheQuicChannel.this.datagramReadable = true;
                QuicheQuicChannel.this.streamReadable = true;
                this.recvDatagram();
                this.recvStream();
            }
        }

        private void runAllTaskRecv(Runnable task) {
            QuicheQuicChannel.this.sslTaskExecutor.execute(this.decorateTaskRecv(task));
        }

        private Runnable decorateTaskRecv(Runnable task) {
            return () -> {
                try {
                    QuicheQuicChannel.this.runAll(task);
                }
                finally {
                    QuicheQuicChannel.this.eventLoop().execute(() -> {
                        if (QuicheQuicChannel.this.connection != null) {
                            this.processReceived(QuicheQuicChannel.this.connection.address());
                            if (QuicheQuicChannel.this.connectionSend()) {
                                QuicheQuicChannel.this.forceFlushParent();
                            }
                        }
                    });
                }
            };
        }

        void recv() {
            if ((QuicheQuicChannel.this.reantranceGuard & 2) != 0 || QuicheQuicChannel.this.isConnDestroyed()) {
                return;
            }
            long connAddr = QuicheQuicChannel.this.connection.address();
            if (!Quiche.quiche_conn_is_established(connAddr) && !Quiche.quiche_conn_is_in_early_data(connAddr)) {
                return;
            }
            QuicheQuicChannel.this.reantranceGuard = QuicheQuicChannel.this.reantranceGuard | 2;
            try {
                this.recvDatagram();
                this.recvStream();
            }
            finally {
                QuicheQuicChannel.this.fireChannelReadCompleteIfNeeded();
                QuicheQuicChannel.this.reantranceGuard = QuicheQuicChannel.this.reantranceGuard & 0xFFFFFFFD;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recvStream() {
            long connAddr = QuicheQuicChannel.this.connection.address();
            long readableIterator = Quiche.quiche_conn_readable(connAddr);
            if (readableIterator != -1L) {
                try {
                    if (QuicheQuicChannel.this.recvStreamPending && QuicheQuicChannel.this.streamReadable) {
                        int readable;
                        do {
                            readable = Quiche.quiche_stream_iter_next(readableIterator, QuicheQuicChannel.this.readableStreams);
                            for (int i = 0; i < readable; ++i) {
                                long streamId = QuicheQuicChannel.this.readableStreams[i];
                                QuicheQuicStreamChannel streamChannel = (QuicheQuicStreamChannel)QuicheQuicChannel.this.streams.get(streamId);
                                if (streamChannel == null) {
                                    QuicheQuicChannel.this.recvStreamPending = false;
                                    QuicheQuicChannel.this.fireChannelReadCompletePending = true;
                                    streamChannel = this.addNewStreamChannel(streamId);
                                    streamChannel.readable();
                                    QuicheQuicChannel.this.pipeline().fireChannelRead((Object)streamChannel);
                                    continue;
                                }
                                streamChannel.readable();
                            }
                        } while (readable >= QuicheQuicChannel.this.readableStreams.length);
                        QuicheQuicChannel.this.streamReadable = false;
                    }
                }
                finally {
                    Quiche.quiche_stream_iter_free(readableIterator);
                }
            }
        }

        private void recvDatagram() {
            if (!QuicheQuicChannel.this.supportsDatagram) {
                return;
            }
            long connAddr = QuicheQuicChannel.this.connection.address();
            while (QuicheQuicChannel.this.recvDatagramPending && QuicheQuicChannel.this.datagramReadable) {
                RecvByteBufAllocator.Handle recvHandle = this.recvBufAllocHandle();
                recvHandle.reset((ChannelConfig)QuicheQuicChannel.this.config());
                int numMessagesRead = 0;
                do {
                    int len;
                    if ((len = Quiche.quiche_conn_dgram_recv_front_len(connAddr)) == Quiche.QUICHE_ERR_DONE) {
                        QuicheQuicChannel.this.datagramReadable = false;
                        return;
                    }
                    ByteBuf datagramBuffer = QuicheQuicChannel.this.alloc().directBuffer(len);
                    recvHandle.attemptedBytesRead(datagramBuffer.writableBytes());
                    int writerIndex = datagramBuffer.writerIndex();
                    long memoryAddress = Quiche.writerMemoryAddress(datagramBuffer);
                    int written = Quiche.quiche_conn_dgram_recv(connAddr, memoryAddress, datagramBuffer.writableBytes());
                    try {
                        if (Quiche.throwIfError(written)) {
                            datagramBuffer.release();
                            QuicheQuicChannel.this.datagramReadable = false;
                            break;
                        }
                    }
                    catch (Exception e) {
                        datagramBuffer.release();
                        QuicheQuicChannel.this.pipeline().fireExceptionCaught((Throwable)e);
                    }
                    recvHandle.lastBytesRead(written);
                    recvHandle.incMessagesRead(1);
                    ++numMessagesRead;
                    datagramBuffer.writerIndex(writerIndex + written);
                    QuicheQuicChannel.this.recvDatagramPending = false;
                    QuicheQuicChannel.this.fireChannelReadCompletePending = true;
                    QuicheQuicChannel.this.pipeline().fireChannelRead((Object)datagramBuffer);
                } while (recvHandle.continueReading());
                recvHandle.readComplete();
                if (numMessagesRead <= 0) continue;
                QuicheQuicChannel.this.fireChannelReadCompleteIfNeeded();
            }
        }

        private boolean handlePendingChannelActive() {
            long connAddr = QuicheQuicChannel.this.connection.address();
            if (QuicheQuicChannel.this.server) {
                if (QuicheQuicChannel.this.state == 1 && Quiche.quiche_conn_is_established(connAddr)) {
                    QuicheQuicChannel.this.state = 2;
                    this.initAddresses(QuicheQuicChannel.this.connection);
                    QuicheQuicChannel.this.pipeline().fireChannelActive();
                    QuicheQuicChannel.this.notifyAboutHandshakeCompletionIfNeeded(null);
                    this.fireDatagramExtensionEvent();
                }
            } else if (QuicheQuicChannel.this.connectPromise != null && Quiche.quiche_conn_is_established(connAddr)) {
                ChannelPromise promise = QuicheQuicChannel.this.connectPromise;
                QuicheQuicChannel.this.connectPromise = null;
                QuicheQuicChannel.this.state = 2;
                this.initAddresses(QuicheQuicChannel.this.connection);
                boolean promiseSet = promise.trySuccess();
                QuicheQuicChannel.this.pipeline().fireChannelActive();
                QuicheQuicChannel.this.notifyAboutHandshakeCompletionIfNeeded(null);
                this.fireDatagramExtensionEvent();
                if (!promiseSet) {
                    this.fireConnectCloseEventIfNeeded(connAddr);
                    this.close(this.voidPromise());
                    return true;
                }
            }
            return false;
        }

        private void initAddresses(QuicheQuicConnection connection) {
            QuicheQuicChannel.this.localIdAdrr = connection.sourceId();
            QuicheQuicChannel.this.remoteIdAddr = connection.destinationId();
        }

        private void fireDatagramExtensionEvent() {
            long connAddr = QuicheQuicChannel.this.connection.address();
            int len = Quiche.quiche_conn_dgram_max_writable_len(connAddr);
            if (len != Quiche.QUICHE_ERR_DONE) {
                QuicheQuicChannel.this.pipeline().fireUserEventTriggered((Object)new QuicDatagramExtensionEvent(len));
            }
        }

        private QuicheQuicStreamChannel addNewStreamChannel(long streamId) {
            QuicheQuicStreamChannel streamChannel = new QuicheQuicStreamChannel(QuicheQuicChannel.this, streamId);
            QuicheQuicStreamChannel old = (QuicheQuicStreamChannel)QuicheQuicChannel.this.streams.put(streamId, (Object)streamChannel);
            assert (old == null);
            streamChannel.writable(QuicheQuicChannel.this.streamCapacity(streamId));
            return streamChannel;
        }
    }

    private static final class CloseData
    implements ChannelFutureListener {
        final boolean applicationClose;
        final int err;
        final ByteBuf reason;

        CloseData(boolean applicationClose, int err, ByteBuf reason) {
            this.applicationClose = applicationClose;
            this.err = err;
            this.reason = reason;
        }

        public void operationComplete(ChannelFuture future) {
            this.reason.release();
        }
    }

    static enum StreamRecvResult {
        DONE,
        FIN,
        OK;

    }
}

