/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.asn1.x9;

import java.util.Enumeration;
import java.util.Vector;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.anssi.ANSSINamedCurves;
import org.python.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.python.bouncycastle.asn1.gm.GMNamedCurves;
import org.python.bouncycastle.asn1.nist.NISTNamedCurves;
import org.python.bouncycastle.asn1.sec.SECNamedCurves;
import org.python.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.python.bouncycastle.asn1.x9.X962NamedCurves;
import org.python.bouncycastle.asn1.x9.X9ECParameters;
import org.python.bouncycastle.crypto.ec.CustomNamedCurves;
import org.python.bouncycastle.crypto.params.ECDomainParameters;

public class ECNamedCurveTable {
    public static X9ECParameters getByName(String string2) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByName(string2);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByName(string2);
        }
        if (x9ECParameters == null) {
            x9ECParameters = NISTNamedCurves.getByName(string2);
        }
        if (x9ECParameters == null) {
            x9ECParameters = TeleTrusTNamedCurves.getByName(string2);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ANSSINamedCurves.getByName(string2);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.fromDomainParameters(ECGOST3410NamedCurves.getByName(string2));
        }
        if (x9ECParameters == null) {
            x9ECParameters = GMNamedCurves.getByName(string2);
        }
        return x9ECParameters;
    }

    public static ASN1ObjectIdentifier getOID(String string2) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = X962NamedCurves.getOID(string2);
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = SECNamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = NISTNamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = TeleTrusTNamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = ANSSINamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = ECGOST3410NamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = GMNamedCurves.getOID(string2);
        }
        return aSN1ObjectIdentifier;
    }

    public static String getName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string2 = X962NamedCurves.getName(aSN1ObjectIdentifier);
        if (string2 == null) {
            string2 = SECNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = NISTNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = TeleTrusTNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = ANSSINamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = ECGOST3410NamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = GMNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = CustomNamedCurves.getName(aSN1ObjectIdentifier);
        }
        return string2;
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = TeleTrusTNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ANSSINamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.fromDomainParameters(ECGOST3410NamedCurves.getByOID(aSN1ObjectIdentifier));
        }
        if (x9ECParameters == null) {
            x9ECParameters = GMNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    public static Enumeration getNames() {
        Vector vector = new Vector();
        ECNamedCurveTable.addEnumeration(vector, X962NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, SECNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, NISTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, TeleTrusTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, ANSSINamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, ECGOST3410NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, GMNamedCurves.getNames());
        return vector.elements();
    }

    private static void addEnumeration(Vector vector, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
    }

    private static X9ECParameters fromDomainParameters(ECDomainParameters eCDomainParameters) {
        return eCDomainParameters == null ? null : new X9ECParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
    }
}

