/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.Authentication;

public class PermissionHelper {
    public static boolean hasPermission(Permission ... permission) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission);
    }

    public static boolean hasPermission(Permission permission, String onConfigurationItem) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission, onConfigurationItem);
    }

    public static boolean hasPermission(List<Permission> permission, String onConfigurationItem) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission, onConfigurationItem);
    }

    public static boolean hasPermission(Permission[] permission, String onConfigurationItem) {
        return PermissionHelper.hasPermission(Arrays.asList(permission), onConfigurationItem);
    }

    public static Map<String, Boolean> hasPermission(Permission permission, List<String> onConfigurationItems) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission, onConfigurationItems);
    }

    public static Map<String, Boolean> hasPermission(List<Permission> permissions, List<String> onConfigurationItems) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permissions, onConfigurationItems);
    }

    public static Map<String, Boolean> hasPermission(Permission[] permissions, List<String> onConfigurationItems) {
        return PermissionHelper.hasPermission(Arrays.asList(permissions), onConfigurationItems);
    }

    public static void applyPermission(SearchParameters parameters, Permission permission) {
        SecurityServiceLocator.getPermissionEnforcer().applyLoggedInUserPermission(parameters, permission);
    }

    public static List<Role> getCurrentRoles() {
        return SecurityServiceLocator.getPermissionEnforcer().getUserRoles(Permissions.getAuthentication());
    }

    public static boolean isCurrentUserAdmin() {
        return SecurityServiceLocator.getPermissionEnforcer().isCurrentUserAdmin();
    }

    public static boolean isAdmin(Authentication authentication) {
        return SecurityServiceLocator.getPermissionEnforcer().isAdmin(authentication);
    }
}

