/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ssl.FileWatcher;
import org.springframework.boot.autoconfigure.ssl.SslBundleRegistrar;
import org.springframework.boot.autoconfigure.ssl.SslProperties;
import org.springframework.boot.autoconfigure.ssl.SslPropertiesBundleRegistrar;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.DefaultSslBundleRegistry;
import org.springframework.boot.ssl.SslBundleRegistry;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={SslProperties.class})
public class SslAutoConfiguration {
    private final SslProperties sslProperties;

    SslAutoConfiguration(SslProperties sslProperties) {
        this.sslProperties = sslProperties;
    }

    @Bean
    FileWatcher fileWatcher() {
        return new FileWatcher(this.sslProperties.getBundle().getWatch().getFile().getQuietPeriod());
    }

    @Bean
    SslPropertiesBundleRegistrar sslPropertiesSslBundleRegistrar(FileWatcher fileWatcher) {
        return new SslPropertiesBundleRegistrar(this.sslProperties, fileWatcher);
    }

    @Bean
    @ConditionalOnMissingBean(value={SslBundleRegistry.class, SslBundles.class})
    DefaultSslBundleRegistry sslBundleRegistry(ObjectProvider<SslBundleRegistrar> sslBundleRegistrars) {
        DefaultSslBundleRegistry registry = new DefaultSslBundleRegistry();
        sslBundleRegistrars.orderedStream().forEach(registrar -> registrar.registerBundles((SslBundleRegistry)registry));
        return registry;
    }
}

