/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.profile.internal.FetchProfileAffectee;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;

public class FetchProfileHelper {
    public static Map<String, FetchProfile> getFetchProfiles(MetadataImplementor bootMetamodel, MappingMetamodel mappingMetamodel) {
        HashMap<String, FetchProfile> fetchProfiles = new HashMap<String, FetchProfile>();
        for (org.hibernate.mapping.FetchProfile mappingProfile : bootMetamodel.getFetchProfiles()) {
            FetchProfile fetchProfile = FetchProfileHelper.createFetchProfile(mappingMetamodel, mappingProfile);
            fetchProfiles.put(fetchProfile.getName(), fetchProfile);
        }
        return fetchProfiles;
    }

    private static FetchProfile createFetchProfile(MappingMetamodel mappingMetamodel, org.hibernate.mapping.FetchProfile mappingProfile) {
        String profileName = mappingProfile.getName();
        FetchProfile fetchProfile = new FetchProfile(profileName);
        for (FetchProfile.Fetch mappingFetch : mappingProfile.getFetches()) {
            EntityPersister owner = FetchProfileHelper.getEntityPersister(mappingMetamodel, fetchProfile, mappingFetch);
            ((FetchProfileAffectee)((Object)owner)).registerAffectingFetchProfile(profileName, null);
            Association association = new Association(owner, mappingFetch.getAssociation());
            Fetch.Style fetchStyle = Fetch.Style.parse(mappingFetch.getStyle());
            ModelPart fetchablePart = owner.findByPath(association.getAssociationPath());
            FetchProfileHelper.validateFetchablePart(fetchablePart, profileName, association);
            if (fetchablePart instanceof FetchProfileAffectee) {
                ((FetchProfileAffectee)((Object)fetchablePart)).registerAffectingFetchProfile(profileName, fetchStyle);
            }
            fetchProfile.addFetch(association, fetchStyle);
        }
        return fetchProfile;
    }

    private static void validateFetchablePart(ModelPart fetchablePart, String profileName, Association association) {
        if (fetchablePart == null) {
            throw new HibernateException(String.format("Fetch profile [%s] specified an association that does not exist - %s", profileName, association.getRole()));
        }
        if (!FetchProfileHelper.isAssociation(fetchablePart)) {
            throw new HibernateException(String.format("Fetch profile [%s] specified an association that is not an association - %s", profileName, association.getRole()));
        }
    }

    private static boolean isAssociation(ModelPart fetchablePart) {
        return fetchablePart instanceof EntityValuedModelPart || fetchablePart instanceof PluralAttributeMapping;
    }

    private static EntityPersister getEntityPersister(MappingMetamodel mappingMetamodel, FetchProfile fetchProfile, FetchProfile.Fetch mappingFetch) {
        EntityPersister persister;
        String entityName = mappingMetamodel.getImportedName(mappingFetch.getEntity());
        if (entityName != null && (persister = mappingMetamodel.getEntityDescriptor(entityName)) != null) {
            return persister;
        }
        throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile.getName() + "]");
    }
}

