/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.sql.results.graph.FetchParentAccess;

public abstract class AbstractFetchParentAccess
implements FetchParentAccess {
    private List<Consumer<Object>> listeners;

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Consumer<Object>>();
        }
        this.listeners.add(listener);
    }

    protected void clearResolutionListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    protected void notifyResolutionListeners(Object resolvedInstance) {
        if (this.listeners == null) {
            return;
        }
        for (Consumer<Object> listener : this.listeners) {
            listener.accept(resolvedInstance);
        }
        this.listeners.clear();
    }
}

