/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.AbstractScrollableResults;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowReader;

public class FetchingScrollableResultsImpl<R>
extends AbstractScrollableResults<R> {
    private final EntityInitializer resultInitializer;
    private R currentRow;
    private int currentPosition;
    private Integer maxPosition;

    public FetchingScrollableResultsImpl(JdbcValues jdbcValues, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader, SharedSessionContractImplementor persistenceContext) {
        super(jdbcValues, processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader, persistenceContext);
        this.resultInitializer = FetchingScrollableResultsImpl.extractResultInitializer(rowReader);
        this.maxPosition = jdbcValuesSourceProcessingState.getQueryOptions().getEffectiveLimit().getMaxRows();
    }

    private static <R> EntityInitializer extractResultInitializer(RowReader<R> rowReader) {
        Initializer initializer = rowReader.getInitializers().get(rowReader.getInitializers().size() - 1);
        return initializer.asEntityInitializer();
    }

    @Override
    protected R getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (this.maxPosition != null && this.maxPosition <= this.currentPosition) {
            this.currentRow = null;
            this.currentPosition = this.maxPosition + 1;
            return false;
        }
        if (this.isResultSetEmpty()) {
            this.currentRow = null;
            this.currentPosition = 0;
            return false;
        }
        boolean afterLast = this.prepareCurrentRow();
        ++this.currentPosition;
        if (afterLast && this.maxPosition == null) {
            this.maxPosition = this.currentPosition;
        }
        this.afterScrollOperation();
        return true;
    }

    @Override
    public boolean previous() {
        if (this.currentPosition <= 1) {
            this.currentPosition = 0;
            this.currentRow = null;
            return false;
        }
        if (this.getRowProcessingState().isFirst()) {
            this.currentRow = null;
        } else {
            EntityKey checkKey;
            EntityKey keyToRead = null;
            if (this.getRowProcessingState().isAfterLast() && this.maxPosition != null && this.currentPosition > this.maxPosition) {
                this.getRowProcessingState().last();
                keyToRead = this.getEntityKey();
            } else {
                this.getRowProcessingState().previous();
                boolean firstPass = true;
                EntityKey lastKey = this.getEntityKey();
                while (this.getRowProcessingState().previous()) {
                    EntityKey checkKey2 = this.getEntityKey();
                    if (firstPass) {
                        firstPass = false;
                        keyToRead = checkKey2;
                    }
                    if (lastKey.equals(checkKey2)) continue;
                }
            }
            while (this.getRowProcessingState().previous() && keyToRead.equals(checkKey = this.getEntityKey())) {
            }
            this.getRowProcessingState().next();
            this.prepareCurrentRow();
        }
        --this.currentPosition;
        this.afterScrollOperation();
        return true;
    }

    @Override
    public boolean scroll(int positions) {
        boolean more = false;
        if (positions > 0) {
            for (int i = 0; i < positions && (more = this.next()); ++i) {
            }
        } else if (positions < 0) {
            for (int i = 0; i < -positions && (more = this.previous()); ++i) {
            }
        } else {
            throw new HibernateException("scroll(0) not valid");
        }
        this.afterScrollOperation();
        return more;
    }

    @Override
    public boolean position(int position) {
        boolean underlyingScrollSuccessful = this.getRowProcessingState().position(position);
        if (!underlyingScrollSuccessful) {
            this.currentRow = null;
            return false;
        }
        this.currentPosition = position - 1;
        return this.next();
    }

    @Override
    public boolean last() {
        boolean more = false;
        if (this.maxPosition != null) {
            if (this.currentPosition > this.maxPosition) {
                more = this.previous();
            }
            for (int i = this.currentPosition; i < this.maxPosition; ++i) {
                more = this.next();
            }
        } else {
            RowProcessingStateStandardImpl rowProcessingState = this.getRowProcessingState();
            if (this.isResultSetEmpty() || rowProcessingState.isAfterLast()) {
                return false;
            }
            while (!rowProcessingState.isAfterLast()) {
                more = this.next();
            }
        }
        this.afterScrollOperation();
        return more;
    }

    @Override
    public boolean first() {
        this.beforeFirst();
        boolean more = this.next();
        this.afterScrollOperation();
        return more;
    }

    @Override
    public void beforeFirst() {
        this.getRowProcessingState().beforeFirst();
        this.currentRow = null;
        this.currentPosition = 0;
    }

    @Override
    public void afterLast() {
        this.last();
        this.next();
        this.afterScrollOperation();
    }

    @Override
    public boolean isFirst() {
        return this.currentPosition == 1;
    }

    @Override
    public boolean isLast() {
        return this.maxPosition != null && this.currentPosition == this.maxPosition;
    }

    @Override
    public int getRowNumber() {
        return this.currentPosition;
    }

    @Override
    public boolean setRowNumber(int rowNumber) {
        if (rowNumber == 1) {
            return this.first();
        }
        if (rowNumber == -1) {
            return this.last();
        }
        if (this.maxPosition != null && rowNumber == this.maxPosition) {
            return this.last();
        }
        return this.scroll(rowNumber - this.currentPosition);
    }

    private boolean prepareCurrentRow() {
        if (this.getRowProcessingState().isBeforeFirst()) {
            this.getRowProcessingState().next();
        }
        RowReader rowReader = this.getRowReader();
        boolean afterLast = false;
        boolean resultProcessed = false;
        EntityKey entityKey = this.getEntityKey();
        this.currentRow = rowReader.readRow(this.getRowProcessingState(), this.getProcessingOptions());
        this.getRowProcessingState().finishRowProcessing();
        while (!resultProcessed) {
            if (this.getRowProcessingState().next()) {
                EntityKey entityKey2 = this.getEntityKey();
                if (!entityKey.equals(entityKey2)) {
                    this.resultInitializer.finishUpRow(this.getRowProcessingState());
                    resultProcessed = true;
                    afterLast = false;
                    continue;
                }
                rowReader.readRow(this.getRowProcessingState(), this.getProcessingOptions());
                this.getRowProcessingState().finishRowProcessing();
                continue;
            }
            afterLast = true;
            resultProcessed = true;
        }
        this.getJdbcValuesSourceProcessingState().finishUp();
        this.getRowProcessingState().getSession().getPersistenceContext().initializeNonLazyCollections();
        return afterLast;
    }

    private boolean isResultSetEmpty() {
        return this.currentPosition == 0 && !this.getRowProcessingState().isBeforeFirst() && !this.getRowProcessingState().isAfterLast();
    }

    private EntityKey getEntityKey() {
        this.resultInitializer.resolveKey(this.getRowProcessingState());
        EntityKey entityKey = this.resultInitializer.getEntityKey();
        this.resultInitializer.finishUpRow(this.getRowProcessingState());
        return entityKey;
    }
}

