/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsClientBuilderConfigurer;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;

public class AwsParameterStoreEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<AwsParameterStoreEnvironmentRepository, AwsParameterStoreEnvironmentProperties> {
    private final ConfigServerProperties configServerProperties;

    public AwsParameterStoreEnvironmentRepositoryFactory(ConfigServerProperties configServerProperties) {
        this.configServerProperties = configServerProperties;
    }

    @Override
    public AwsParameterStoreEnvironmentRepository build(AwsParameterStoreEnvironmentProperties environmentProperties) {
        SsmClientBuilder clientBuilder = SsmClient.builder();
        AwsClientBuilderConfigurer.configureClientBuilder(clientBuilder, environmentProperties.getRegion(), environmentProperties.getEndpoint());
        SsmClient client = (SsmClient)clientBuilder.build();
        return new AwsParameterStoreEnvironmentRepository(client, this.configServerProperties, environmentProperties);
    }
}

