/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.Map;

public final class MapBackedClassValue<V> {
    private volatile Map<Class<?>, V> map;
    private final ClassValue<V> classValue = new ClassValue<V>(){

        @Override
        protected V computeValue(Class<?> type) {
            Map m = MapBackedClassValue.this.map;
            if (m == null) {
                throw new IllegalStateException("This MapBackedClassValue has been disposed");
            }
            return MapBackedClassValue.this.map.get(type);
        }
    };

    public MapBackedClassValue(Map<Class<?>, V> map) {
        this.map = Map.copyOf(map);
    }

    public V get(Class<?> key) {
        return this.classValue.get(key);
    }

    public void dispose() {
        this.map = null;
    }
}

