/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.api.dto.ApplyPatchesInput;
import com.xebialabs.deployit.core.rest.api.dto.PatchedSample;
import com.xebialabs.deployit.model.InvalidActivator;
import com.xebialabs.deployit.model.InvalidActivators;
import com.xebialabs.deployit.model.InvalidPatchEntry;
import com.xebialabs.deployit.model.request.ValidateActivatorRequest;
import com.xebialabs.deployit.model.request.ValidateActivatorsRequest;
import com.xebialabs.deployit.model.request.ValidatePatchEntryRequest;
import com.xebialabs.deployit.plugin.service.FormatSupportProvider;
import com.xebialabs.deployit.plugin.service.PatchFormatSupport;
import com.xebialabs.deployit.plugin.service.PatchService;
import com.xebialabs.deployit.plugin.service.ValidationService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@Controller
@Autowired
@Path(value="/patch")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001B\u0005\u000b\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003u\u0001\u0011\u0005Q\u000fC\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T\ti\u0001+\u0019;dQJ+7o\\;sG\u0016T!a\u0003\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u000e\u001d\u0005!!/Z:u\u0015\ty\u0001#\u0001\u0003d_J,'BA\t\u0013\u0003!!W\r\u001d7ps&$(BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\ra\u0006$8\r[*feZL7-\u001a\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\nqa]3sm&\u001cWM\u0003\u0002%!\u00051\u0001\u000f\\;hS:L!AJ\u0011\u0003\u0019A\u000bGo\u00195TKJ4\u0018nY3\u0002#Y\fG.\u001b3bi&|gnU3sm&\u001cW\r\u0005\u0002!S%\u0011!&\t\u0002\u0012-\u0006d\u0017\u000eZ1uS>t7+\u001a:wS\u000e,\u0017!\u00064pe6\fGoU;qa>\u0014H\u000f\u0015:pm&$WM\u001d\t\u0003A5J!AL\u0011\u0003+\u0019{'/\\1u'V\u0004\bo\u001c:u!J|g/\u001b3fe\u00061A(\u001b8jiz\"B!M\u001a5kA\u0011!\u0007A\u0007\u0002\u0015!)a\u0004\u0002a\u0001?!)q\u0005\u0002a\u0001Q!)1\u0006\u0002a\u0001Y\u0005)\u0011\r\u001d9msR\u0019\u0001HP-\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mR\u0011a\u00013u_&\u0011QH\u000f\u0002\u000e!\u0006$8\r[3e'\u0006l\u0007\u000f\\3\t\u000b}*\u0001\u0019\u0001!\u0002\u001d\r|g\u000e^3oiRK\b/Z#yiB\u0011\u0011\t\u0013\b\u0003\u0005\u001a\u0003\"a\u0011\u000e\u000e\u0003\u0011S!!\u0012\f\u0002\rq\u0012xn\u001c;?\u0013\t9%$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$\u001bQ\u0011qDJV,\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016A\u0001:t\u0015\t\t&+\u0001\u0002xg*\t1+A\u0004kC.\f'\u000f^1\n\u0005Us%!\u0003)bi\"\u0004\u0016M]1n\u0003\u00151\u0018\r\\;fC\u0005A\u0016aC2p]R,g\u000e\u001e+za\u0016DQAW\u0003A\u0002m\u000bA\u0001Z1uCB\u0011\u0011\bX\u0005\u0003;j\u0012\u0011#\u00119qYf\u0004\u0016\r^2iKNLe\u000e];uQ\t)q\f\u0005\u0002NA&\u0011\u0011M\u0014\u0002\u0005!>\u001bF\u000b\u000b\u0003\u0006GZ3\u0007CA'e\u0013\t)gJ\u0001\u0003QCRD\u0017%A4\u0002'\u0005\u0004\b\u000f\\=0w\u000e|g\u000e^3oiRK\b/Z?)\t\u0015Ig\u000b\u001c\t\u0003\u001b*L!a\u001b(\u0003\u0011\r{gn];nKNd\u0013!\\\u0011\u0002]\u0006\u0001\u0012\r\u001d9mS\u000e\fG/[8o_)\u001cxN\u001c\u0015\u0005\u000bA46\u000f\u0005\u0002Nc&\u0011!O\u0014\u0002\t!J|G-^2fg2\nQ.A\twC2LG-\u0019;f\u0003\u000e$\u0018N^1u_J$BA^@\u0002\u0004A\u0019\u0011d^=\n\u0005aT\"AB(qi&|g\u000e\u0005\u0002{{6\t1P\u0003\u0002}!\u0005)Qn\u001c3fY&\u0011ap\u001f\u0002\u0011\u0013:4\u0018\r\\5e\u0003\u000e$\u0018N^1u_JDQa\u0010\u0004A\u0002\u0001CCa 'W/\"9\u0011Q\u0001\u0004A\u0002\u0005\u001d\u0011a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u0013\ti!\u0004\u0002\u0002\f)\u0019\u0011QA>\n\t\u0005=\u00111\u0002\u0002\u0019-\u0006d\u0017\u000eZ1uK\u0006\u001bG/\u001b<bi>\u0014(+Z9vKN$\bF\u0001\u0004`Q\u001511MVA\u000bC\t\t9\"\u0001\u0011wC2LG-\u0019;f_\u0005\u001cG/\u001b<bi>\u0014xf_2p]R,g\u000e\u001e+za\u0016l\b&\u0002\u0004j-\u0006mA&A7\u0002%Y\fG.\u001b3bi\u0016\f5\r^5wCR|'o\u001d\u000b\u0007\u0003C\tI$!\u0010\u0011\r\u0005\r\u0012QFA\u001a\u001d\u0011\t)#!\u000b\u000f\u0007\r\u000b9#C\u0001\u001c\u0013\r\tYCG\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty#!\r\u0003\t1K7\u000f\u001e\u0006\u0004\u0003WQ\u0002c\u0001>\u00026%\u0019\u0011qG>\u0003#%sg/\u00197jI\u0006\u001bG/\u001b<bi>\u00148\u000fC\u0003@\u000f\u0001\u0007\u0001\tK\u0003\u0002:13v\u000bC\u0004\u0002\u0006\u001d\u0001\r!a\u0010\u0011\t\u0005%\u0011\u0011I\u0005\u0005\u0003\u0007\nYAA\rWC2LG-\u0019;f\u0003\u000e$\u0018N^1u_J\u001c(+Z9vKN$\bFA\u0004`Q\u001591MVA%C\t\tY%A\u0011wC2LG-\u0019;f_\u0005\u001cG/\u001b<bi>\u00148oL>d_:$XM\u001c;UsB,W\u0010K\u0003\bSZ\u000by\u0005L\u0001n\u0003I1\u0018\r\\5eCR,\u0007+\u0019;dQ\u0016sGO]=\u0015\r\u0005U\u0013QLA1!\u0011Ir/a\u0016\u0011\u0007i\fI&C\u0002\u0002\\m\u0014\u0011#\u00138wC2LG\rU1uG\",e\u000e\u001e:z\u0011\u0015y\u0004\u00021\u0001AQ\u0015\ti\u0006\u0014,X\u0011\u001d\t)\u0001\u0003a\u0001\u0003G\u0002B!!\u0003\u0002f%!\u0011qMA\u0006\u0005e1\u0016\r\\5eCR,\u0007+\u0019;dQ\u0016sGO]=SKF,Xm\u001d;)\u0005!y\u0006&\u0002\u0005d-\u00065\u0014EAA8\u0003q1\u0018\r\\5eCR,w&\u001a8uef|3pY8oi\u0016tG\u000fV=qKvDS\u0001C5W\u0003gb\u0013!\u001c\u0015\u0004\u0001\u0005]\u0004\u0003BA=\u0003\u000fk!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u000bgR,'/Z8usB,'\u0002BAA\u0003\u0007\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003\u000b\u000b1a\u001c:h\u0013\u0011\tI)a\u001f\u0003\u0015\r{g\u000e\u001e:pY2,'\u000fK\u0002\u0001\u0003\u001b\u0003B!a$\u0002\u001e6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*\u0001\u0006b]:|G/\u0019;j_:TA!a&\u0002\u001a\u00069a-Y2u_JL(\u0002BAN\u0003\u007f\nQAY3b]NLA!a(\u0002\u0012\nI\u0011)\u001e;po&\u0014X\r\u001a\u0015\u0006\u0001\r4\u00161U\u0011\u0003\u0003K\u000baa\f9bi\u000eD\u0007")
public class PatchResource {
    private final PatchService patchService;
    private final ValidationService validationService;
    private final FormatSupportProvider formatSupportProvider;

    @POST
    @Path(value="apply/{contentType}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PatchedSample apply(@PathParam(value="contentType") String contentTypeExt, ApplyPatchesInput data) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.patchService.applyPatch(data.patchEntries(), data.sample(), patchFormatSupport);
    }

    @POST
    @Path(value="validate/activator/{contentType}")
    @Consumes(value={"application/json"})
    public Option<InvalidActivator> validateActivator(@PathParam(value="contentType") String contentTypeExt, ValidateActivatorRequest request) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.validationService.validateActivator(request.content(), request.activator(), patchFormatSupport);
    }

    @POST
    @Path(value="validate/activators/{contentType}")
    @Consumes(value={"application/json"})
    public List<InvalidActivators> validateActivators(@PathParam(value="contentType") String contentTypeExt, ValidateActivatorsRequest request) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.validationService.validateActivators(request.content(), request.activators(), patchFormatSupport);
    }

    @POST
    @Path(value="validate/entry/{contentType}")
    @Consumes(value={"application/json"})
    public Option<InvalidPatchEntry> validatePatchEntry(@PathParam(value="contentType") String contentTypeExt, ValidatePatchEntryRequest request) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.validationService.validatePatchEntry(request.content(), request.entry(), patchFormatSupport);
    }

    public PatchResource(PatchService patchService, ValidationService validationService, FormatSupportProvider formatSupportProvider) {
        this.patchService = patchService;
        this.validationService = validationService;
        this.formatSupportProvider = formatSupportProvider;
    }
}

