/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.cte;

import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.Subquery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaCteCriteriaAttribute;
import org.hibernate.query.criteria.JpaCteCriteriaType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaSearchOrder;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SortOrder;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteSearchClauseKind;

public class SqmCteStatement<T>
extends AbstractSqmNode
implements SqmVisitableNode,
JpaCteCriteria<T> {
    private final SqmCteContainer cteContainer;
    private final SqmCteTable<T> cteTable;
    private SqmSelectQuery<?> cteDefinition;
    private CteMaterialization materialization;
    private CteSearchClauseKind searchClauseKind;
    private List<JpaSearchOrder> searchBySpecifications;
    private String searchAttributeName;
    private List<JpaCteCriteriaAttribute> cycleAttributes;
    private String cycleMarkAttributeName;
    private String cyclePathAttributeName;
    private SqmLiteral<Object> cycleValue;
    private SqmLiteral<Object> noCycleValue;

    public SqmCteStatement(String name, SqmSelectQuery<T> cteDefinition, SqmCteContainer cteContainer, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.cteDefinition = cteDefinition;
        this.cteContainer = cteContainer;
        this.materialization = CteMaterialization.UNDEFINED;
        this.searchBySpecifications = Collections.emptyList();
        this.cycleAttributes = Collections.emptyList();
        this.cteTable = SqmCteTable.createStatementTable(name, this, cteDefinition);
    }

    public SqmCteStatement(String name, SqmSelectQuery<T> nonRecursiveQueryPart, boolean unionDistinct, Function<JpaCteCriteria<T>, AbstractQuery<T>> finalCriteriaProducer, SqmCteContainer cteContainer, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.cteContainer = cteContainer;
        this.materialization = CteMaterialization.UNDEFINED;
        this.searchBySpecifications = Collections.emptyList();
        this.cycleAttributes = Collections.emptyList();
        this.cteTable = SqmCteTable.createStatementTable(name, this, nonRecursiveQueryPart);
        AbstractQuery<T> recursiveQueryPart = finalCriteriaProducer.apply(this);
        this.cteDefinition = nonRecursiveQueryPart instanceof Subquery ? (unionDistinct ? (SqmSelectQuery)((Object)nodeBuilder.union((SqmSubQuery)nonRecursiveQueryPart, (SqmSubQuery)recursiveQueryPart)) : (SqmSelectQuery)((Object)nodeBuilder.unionAll((SqmSubQuery)nonRecursiveQueryPart, (SqmSubQuery)recursiveQueryPart))) : (unionDistinct ? (SqmSelectQuery)((Object)nodeBuilder.union((SqmSelectStatement)nonRecursiveQueryPart, (SqmSelectStatement)recursiveQueryPart)) : (SqmSelectQuery)((Object)nodeBuilder.unionAll((SqmSelectStatement)nonRecursiveQueryPart, (SqmSelectStatement)recursiveQueryPart)));
    }

    private SqmCteStatement(NodeBuilder builder, SqmCteContainer cteContainer, SqmCteTable<T> cteTable, SqmSelectQuery<?> cteDefinition, CteMaterialization materialization, CteSearchClauseKind searchClauseKind, List<JpaSearchOrder> searchBySpecifications, String searchAttributeName, List<JpaCteCriteriaAttribute> cycleAttributes, String cycleMarkAttributeName, String cyclePathAttributeName, SqmLiteral<Object> cycleValue, SqmLiteral<Object> noCycleValue) {
        super(builder);
        this.cteContainer = cteContainer;
        this.cteTable = cteTable;
        this.cteDefinition = cteDefinition;
        this.materialization = materialization;
        this.searchClauseKind = searchClauseKind;
        this.searchBySpecifications = searchBySpecifications;
        this.searchAttributeName = searchAttributeName;
        this.cycleAttributes = cycleAttributes;
        this.cycleMarkAttributeName = cycleMarkAttributeName;
        this.cyclePathAttributeName = cyclePathAttributeName;
        this.cycleValue = cycleValue;
        this.noCycleValue = noCycleValue;
    }

    @Override
    public SqmCteStatement<T> copy(SqmCopyContext context) {
        SqmCteStatement existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCteStatement<T> copy = context.registerCopy(this, new SqmCteStatement<T>(this.nodeBuilder(), this.cteContainer, this.cteTable, null, this.materialization, this.searchClauseKind, this.searchBySpecifications, this.searchAttributeName, this.cycleAttributes, this.cycleMarkAttributeName, this.cyclePathAttributeName, (SqmLiteral<Object>)(this.cycleValue == null ? null : this.cycleValue.copy(context)), (SqmLiteral<Object>)(this.noCycleValue == null ? null : this.noCycleValue.copy(context))));
        copy.cteDefinition = this.cteDefinition.copy(context);
        return copy;
    }

    @Override
    public String getName() {
        return this.cteTable.getName();
    }

    public SqmCteTable<?> getCteTable() {
        return this.cteTable;
    }

    @Override
    public SqmSelectQuery<?> getCteDefinition() {
        return this.cteDefinition;
    }

    @Override
    public SqmCteContainer getCteContainer() {
        return this.cteContainer;
    }

    @Override
    public CteMaterialization getMaterialization() {
        return this.materialization;
    }

    @Override
    public void setMaterialization(CteMaterialization materialization) {
        this.materialization = materialization;
    }

    @Override
    public CteSearchClauseKind getSearchClauseKind() {
        return this.searchClauseKind;
    }

    @Override
    public List<JpaSearchOrder> getSearchBySpecifications() {
        return this.searchBySpecifications;
    }

    @Override
    public String getSearchAttributeName() {
        return this.searchAttributeName;
    }

    @Override
    public List<JpaCteCriteriaAttribute> getCycleAttributes() {
        return this.cycleAttributes;
    }

    @Override
    public String getCycleMarkAttributeName() {
        return this.cycleMarkAttributeName;
    }

    @Override
    public String getCyclePathAttributeName() {
        return this.cyclePathAttributeName;
    }

    @Override
    public Object getCycleValue() {
        return this.cycleValue == null ? null : this.cycleValue.getLiteralValue();
    }

    @Override
    public Object getNoCycleValue() {
        return this.noCycleValue == null ? null : this.noCycleValue.getLiteralValue();
    }

    public SqmLiteral<Object> getCycleLiteral() {
        return this.cycleValue;
    }

    public SqmLiteral<Object> getNoCycleLiteral() {
        return this.noCycleValue;
    }

    @Override
    public JpaCteCriteriaType<T> getType() {
        return this.cteTable;
    }

    @Override
    public void search(CteSearchClauseKind kind, String searchAttributeName, List<JpaSearchOrder> searchOrders) {
        if (kind == null || searchAttributeName == null || searchOrders == null || searchOrders.isEmpty()) {
            this.searchClauseKind = null;
            this.searchBySpecifications = Collections.emptyList();
            this.searchAttributeName = null;
        } else {
            ArrayList<JpaSearchOrder> orders = new ArrayList<JpaSearchOrder>(searchOrders.size());
            for (JpaSearchOrder order : searchOrders) {
                if (!this.cteTable.getAttributes().contains(order.getAttribute())) {
                    throw new IllegalArgumentException("Illegal search order attribute '" + (order.getAttribute() == null ? "null" : order.getAttribute().getName()) + "' passed, which is not part of the JpaCteCriteria!");
                }
                orders.add(order);
            }
            this.searchClauseKind = kind;
            this.searchAttributeName = searchAttributeName;
            this.searchBySpecifications = orders;
        }
    }

    @Override
    public <X> void cycleUsing(String cycleMarkAttributeName, String cyclePathAttributeName, X cycleValue, X noCycleValue, List<JpaCteCriteriaAttribute> cycleAttributes) {
        if (cycleMarkAttributeName == null || cycleAttributes == null || cycleAttributes.isEmpty()) {
            this.cycleMarkAttributeName = null;
            this.cyclePathAttributeName = null;
            this.cycleValue = null;
            this.noCycleValue = null;
            this.cycleAttributes = Collections.emptyList();
        } else {
            if (cycleValue == null || noCycleValue == null) {
                throw new IllegalArgumentException("Null is an illegal value for cycle mark values!");
            }
            JpaExpression cycleValueLiteral = this.nodeBuilder().literal(cycleValue);
            JpaExpression noCycleValueLiteral = this.nodeBuilder().literal(noCycleValue);
            if (cycleValueLiteral.getNodeType() != noCycleValueLiteral.getNodeType()) {
                throw new IllegalArgumentException("Inconsistent types for cycle mark values: [" + cycleValueLiteral.getNodeType() + ", " + noCycleValueLiteral.getNodeType() + "]");
            }
            ArrayList<JpaCteCriteriaAttribute> attributes = new ArrayList<JpaCteCriteriaAttribute>(cycleAttributes.size());
            for (JpaCteCriteriaAttribute cycleAttribute : cycleAttributes) {
                if (!this.cteTable.getAttributes().contains(cycleAttribute)) {
                    throw new IllegalArgumentException("Illegal cycle attribute '" + (cycleAttribute == null ? "null" : cycleAttribute.getName()) + "' passed, which is not part of the JpaCteCriteria!");
                }
                attributes.add(cycleAttribute);
            }
            this.cycleMarkAttributeName = cycleMarkAttributeName;
            this.cyclePathAttributeName = cyclePathAttributeName;
            this.cycleValue = (SqmLiteral)cycleValueLiteral;
            this.noCycleValue = (SqmLiteral)noCycleValueLiteral;
            this.cycleAttributes = attributes;
        }
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCteStatement(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        if (this.cteTable.getName() == null) {
            sb.append("generated_");
        }
        sb.append(this.cteTable.getCteName());
        sb.append(" (");
        List<SqmCteTableColumn> columns = this.cteTable.getColumns();
        sb.append(columns.get(0).getColumnName());
        for (int i = 1; i < columns.size(); ++i) {
            sb.append(", ");
            sb.append(columns.get(i).getColumnName());
        }
        sb.append(") as ");
        if (this.getMaterialization() != CteMaterialization.UNDEFINED) {
            sb.append((Object)this.getMaterialization()).append(' ');
        }
        if (this.getCteDefinition() instanceof SqmSubQuery) {
            ((SqmSubQuery)this.getCteDefinition()).appendHqlString(sb);
        } else {
            sb.append('(');
            ((SqmSelectStatement)this.getCteDefinition()).appendHqlString(sb);
            sb.append(')');
        }
        if (this.getSearchClauseKind() != null) {
            sb.append(" search ");
            if (this.getSearchClauseKind() == CteSearchClauseKind.DEPTH_FIRST) {
                sb.append(" depth ");
            } else {
                sb.append(" breadth ");
            }
            sb.append(" first by ");
            String separator = "";
            for (JpaSearchOrder searchBySpecification : this.getSearchBySpecifications()) {
                sb.append(separator);
                sb.append(searchBySpecification.getAttribute().getName());
                if (searchBySpecification.getSortOrder() != null) {
                    if (searchBySpecification.getSortOrder() == SortOrder.ASCENDING) {
                        sb.append(" asc");
                    } else {
                        sb.append(" desc");
                    }
                    if (searchBySpecification.getNullPrecedence() != null) {
                        switch (searchBySpecification.getNullPrecedence()) {
                            case FIRST: {
                                sb.append(" nulls first");
                                break;
                            }
                            case LAST: {
                                sb.append(" nulls last");
                            }
                        }
                    }
                }
                separator = ", ";
            }
            sb.append(" set ");
            sb.append(this.getSearchAttributeName());
        }
        if (this.getCycleMarkAttributeName() != null) {
            sb.append(" cycle ");
            String separator = "";
            for (JpaCteCriteriaAttribute cycleColumn : this.getCycleAttributes()) {
                sb.append(separator);
                sb.append(cycleColumn.getName());
                separator = ", ";
            }
            sb.append(" set ");
            sb.append(this.getCycleMarkAttributeName());
            sb.append(" to ");
            this.getCycleLiteral().appendHqlString(sb);
            sb.append(" default ");
            this.getNoCycleLiteral().appendHqlString(sb);
            if (this.getCyclePathAttributeName() != null) {
                sb.append(" using ");
                sb.append(this.getCyclePathAttributeName());
            }
        }
    }
}

