/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Label;
import org.infinispan.protostream.descriptors.MapDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.RepeatedFieldDescriptor;
import org.infinispan.protostream.impl.TagWriterImpl;

public final class JsonUtils {
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final String JSON_TYPE_FIELD = "_type";
    private static final String JSON_VALUE_FIELD = "_value";
    private static final ThreadLocal<DateFormat> timestampFormat = ThreadLocal.withInitial(() -> {
        SimpleDateFormat sdf = new SimpleDateFormat(RFC_3339_DATE_FORMAT);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        sdf.setCalendar(calendar);
        return sdf;
    });

    private JsonUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] fromCanonicalJSON(ImmutableSerializationContext ctx, Reader reader) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try (Reader reader2 = reader;){
            byte[] byArray;
            block19: {
                ByteArrayOutputStream byteArrayOutputStream = baos;
                try {
                    JsonToken token;
                    TagWriterImpl writer = TagWriterImpl.newInstance(ctx, baos);
                    JsonParser parser = jsonFactory.createParser(reader);
                    block16: while ((token = parser.nextToken()) != null) {
                        switch (token) {
                            case START_OBJECT: {
                                JsonUtils.processDocument(ctx, parser, writer);
                                continue block16;
                            }
                            case VALUE_NULL: {
                                continue block16;
                            }
                        }
                        throw new IllegalStateException("Invalid top level object! Found token: " + token);
                    }
                    writer.flush();
                    byArray = baos.toByteArray();
                    if (byteArrayOutputStream == null) break block19;
                }
                catch (Throwable throwable) {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                byteArrayOutputStream.close();
            }
            return byArray;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Invalid JSON", e);
        }
    }

    private static void processDocument(ImmutableSerializationContext ctx, JsonParser parser, TagWriter writer) throws IOException {
        JsonToken token;
        while ((token = parser.nextToken()) != null) {
            block0 : switch (token) {
                case END_OBJECT: {
                    return;
                }
                case FIELD_NAME: {
                    String currentField = parser.getCurrentName();
                    JsonUtils.expectField(JSON_TYPE_FIELD, currentField);
                    break;
                }
                case VALUE_STRING: {
                    String topLevelTypeName = parser.getText();
                    GenericDescriptor descriptorByName = null;
                    Type fieldType = switch (topLevelTypeName) {
                        case "double" -> Type.DOUBLE;
                        case "float" -> Type.FLOAT;
                        case "int32" -> Type.INT32;
                        case "int64" -> Type.INT64;
                        case "fixed32" -> Type.FIXED32;
                        case "fixed64" -> Type.FIXED64;
                        case "bool" -> Type.BOOL;
                        case "string" -> Type.STRING;
                        case "bytes" -> Type.BYTES;
                        case "uint32" -> Type.UINT32;
                        case "uint64" -> Type.UINT64;
                        case "sfixed32" -> Type.SFIXED32;
                        case "sfixed64" -> Type.SFIXED64;
                        case "sint32" -> Type.SINT32;
                        case "sint64" -> Type.SINT64;
                        default -> {
                            descriptorByName = ctx.getDescriptorByName(topLevelTypeName);
                            yield descriptorByName instanceof EnumDescriptor ? Type.ENUM : Type.MESSAGE;
                        }
                    };
                    switch (fieldType) {
                        case ENUM: {
                            JsonUtils.processEnum(parser, writer, (EnumDescriptor)descriptorByName);
                            break block0;
                        }
                        case MESSAGE: {
                            JsonUtils.processObject(ctx, parser, writer, (Descriptor)descriptorByName, null, true);
                            break block0;
                        }
                    }
                    JsonUtils.processPrimitive(parser, writer, fieldType);
                }
            }
        }
    }

    private static void processEnum(JsonParser parser, TagWriter writer, EnumDescriptor enumDescriptor) throws IOException {
        JsonToken token;
        block8: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case END_OBJECT: {
                    return;
                }
                case FIELD_NAME: {
                    String fieldName = parser.getCurrentName();
                    JsonUtils.expectField(JSON_VALUE_FIELD, fieldName);
                    continue block8;
                }
                case VALUE_STRING: {
                    String enumValueName = parser.getText();
                    EnumValueDescriptor enumValueDescriptor = enumDescriptor.findValueByName(enumValueName);
                    if (enumValueDescriptor == null) {
                        throw new IllegalStateException("Invalid enum value : '" + enumValueName + "'");
                    }
                    Integer topLevelTypeId = enumDescriptor.getTypeId();
                    if (topLevelTypeId == null) {
                        writer.writeString(16, enumDescriptor.getFullName());
                    } else {
                        writer.writeUInt32(19, topLevelTypeId);
                    }
                    writer.writeEnum(18, enumValueDescriptor.getNumber());
                    continue block8;
                }
                case VALUE_NUMBER_INT: {
                    int enumValueNumber = parser.getIntValue();
                    EnumValueDescriptor enumValueDescriptor = enumDescriptor.findValueByNumber(enumValueNumber);
                    if (enumValueDescriptor == null) {
                        throw new IllegalStateException("Invalid enum value : " + enumValueNumber);
                    }
                    Integer topLevelTypeId = enumDescriptor.getTypeId();
                    if (topLevelTypeId == null) {
                        writer.writeString(16, enumDescriptor.getFullName());
                    } else {
                        writer.writeUInt32(19, topLevelTypeId);
                    }
                    writer.writeEnum(18, enumValueDescriptor.getNumber());
                    continue block8;
                }
                case VALUE_NULL: {
                    throw new IllegalStateException("Invalid enum value 'null'");
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NUMBER_FLOAT: {
                    throw new IllegalStateException("Invalid enum value '" + parser.getText() + "'");
                }
            }
            throw new IllegalStateException("Unexpected token : " + token);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void processObject(ImmutableSerializationContext ctx, JsonParser parser, TagWriter writer, Descriptor messageDescriptor, Integer fieldNumber, boolean topLevel) throws IOException {
        JsonToken token;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        TagWriterImpl nestedWriter = TagWriterImpl.newInstance(ctx, baos);
        String currentField = null;
        block7: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case END_OBJECT: {
                    break block7;
                }
                case START_ARRAY: {
                    JsonUtils.processArray(ctx, messageDescriptor.getFullName(), currentField, parser, nestedWriter);
                    break;
                }
                case START_OBJECT: {
                    FieldDescriptor fd = messageDescriptor.findFieldByName(currentField);
                    if (fd.isMap()) {
                        JsonUtils.processMap(ctx, (MapDescriptor)fd, parser, nestedWriter);
                        break;
                    }
                    Descriptor messageType = fd.getMessageType();
                    if (messageType == null) {
                        throw new IllegalStateException("Field '" + currentField + "' is not an object");
                    }
                    JsonUtils.processObject(ctx, parser, nestedWriter, messageType, fd.getNumber(), false);
                    break;
                }
                case FIELD_NAME: {
                    currentField = parser.getCurrentName();
                    break;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER_INT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NUMBER_FLOAT: {
                    FieldDescriptor fd = messageDescriptor.findFieldByName(currentField);
                    if (fd == null) {
                        throw new IllegalStateException("The field '" + currentField + "' was not found in the Protobuf schema");
                    }
                    if (fd.getType() == Type.ENUM) {
                        JsonUtils.writeEnumField(parser, nestedWriter, fd, fd.getNumber());
                        break;
                    }
                    JsonUtils.writeField(parser, nestedWriter, fd.getType(), fd.getNumber());
                }
            }
        }
        if (topLevel) {
            Integer topLevelTypeId = messageDescriptor.getTypeId();
            if (topLevelTypeId == null) {
                writer.writeString(16, messageDescriptor.getFullName());
            } else {
                writer.writeUInt32(19, topLevelTypeId);
            }
            nestedWriter.flush();
            writer.writeBytes(17, baos.toByteArray());
        } else {
            nestedWriter.flush();
            writer.writeBytes((int)fieldNumber, baos.toByteArray());
        }
        writer.flush();
    }

    private static void processMap(ImmutableSerializationContext ctx, MapDescriptor md, JsonParser parser, TagWriter writer) throws IOException {
        JsonToken token;
        while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            if (token != JsonToken.FIELD_NAME) {
                throw new IllegalStateException("Unexpected token");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            TagWriterImpl nestedWriter = TagWriterImpl.newInstance(ctx, baos);
            String key = parser.getCurrentName();
            switch (md.getKeyType()) {
                case STRING: {
                    nestedWriter.writeString(1, key);
                    break;
                }
                case INT32: {
                    nestedWriter.writeInt32(1, Integer.parseInt(key));
                    break;
                }
                case INT64: {
                    nestedWriter.writeInt64(1, Long.parseLong(key));
                    break;
                }
                case FIXED32: {
                    nestedWriter.writeFixed32(1, Integer.parseInt(key));
                    break;
                }
                case FIXED64: {
                    nestedWriter.writeFixed64(1, Long.parseLong(key));
                    break;
                }
                case SINT32: {
                    nestedWriter.writeSInt32(1, Integer.parseInt(key));
                    break;
                }
                case SINT64: {
                    nestedWriter.writeSInt64(1, Long.parseLong(key));
                    break;
                }
                case SFIXED32: {
                    nestedWriter.writeSFixed32(1, Integer.parseInt(key));
                    break;
                }
                case SFIXED64: {
                    nestedWriter.writeSFixed64(1, Long.parseLong(key));
                    break;
                }
                case UINT32: {
                    nestedWriter.writeUInt32(1, Integer.parseInt(key));
                    break;
                }
                case UINT64: {
                    nestedWriter.writeUInt64(1, Long.parseLong(key));
                }
            }
            JsonUtils.processMapValue(ctx, parser, nestedWriter, md);
            writer.writeBytes(md.getNumber(), baos.toByteArray());
            writer.flush();
        }
    }

    private static void processMapValue(ImmutableSerializationContext ctx, JsonParser parser, TagWriter writer, MapDescriptor md) throws IOException {
        JsonToken token = parser.nextToken();
        if (token == null) {
            return;
        }
        block0 : switch (token) {
            case START_OBJECT: {
                JsonUtils.processObject(ctx, parser, writer, md.getMessageType(), 2, false);
                break;
            }
            case VALUE_STRING: {
                if (md.getType() == Type.ENUM) {
                    JsonUtils.writeEnumField(parser, writer, md, 2);
                    break;
                }
                writer.writeString(2, parser.getValueAsString());
                break;
            }
            case VALUE_NUMBER_INT: {
                switch (md.getType()) {
                    case INT32: {
                        writer.writeInt32(2, parser.getIntValue());
                        break;
                    }
                    case INT64: {
                        writer.writeInt64(2, parser.getLongValue());
                        break;
                    }
                    case FIXED32: {
                        writer.writeFixed32(2, parser.getIntValue());
                        break;
                    }
                    case FIXED64: {
                        writer.writeFixed64(2, parser.getLongValue());
                        break;
                    }
                    case SINT32: {
                        writer.writeSInt32(2, parser.getIntValue());
                        break;
                    }
                    case SINT64: {
                        writer.writeSInt64(2, parser.getLongValue());
                        break;
                    }
                    case SFIXED32: {
                        writer.writeSFixed32(2, parser.getIntValue());
                        break;
                    }
                    case SFIXED64: {
                        writer.writeSFixed64(2, parser.getLongValue());
                        break;
                    }
                    case UINT32: {
                        writer.writeUInt32(2, parser.getIntValue());
                        break;
                    }
                    case UINT64: {
                        writer.writeUInt64(2, parser.getLongValue());
                    }
                }
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                switch (md.getType()) {
                    case FLOAT: {
                        writer.writeFloat(2, parser.getFloatValue());
                        break block0;
                    }
                    case DOUBLE: {
                        writer.writeDouble(2, parser.getDoubleValue());
                    }
                }
            }
        }
        writer.flush();
    }

    private static void processPrimitive(JsonParser parser, TagWriter writer, Type fieldType) throws IOException {
        JsonToken token;
        block6: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case END_OBJECT: {
                    return;
                }
                case FIELD_NAME: {
                    String fieldName = parser.getCurrentName();
                    JsonUtils.expectField(JSON_VALUE_FIELD, fieldName);
                    continue block6;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER_INT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NUMBER_FLOAT: {
                    JsonUtils.writeField(parser, writer, fieldType, JsonUtils.getPrimitiveFieldId(fieldType));
                    continue block6;
                }
                case VALUE_NULL: {
                    continue block6;
                }
            }
            throw new IllegalStateException("Unexpected JSON token :" + token);
        }
    }

    private static int getPrimitiveFieldId(Type primitiveType) {
        return switch (primitiveType) {
            case Type.DOUBLE -> 1;
            case Type.FLOAT -> 2;
            case Type.INT32 -> 5;
            case Type.INT64 -> 3;
            case Type.FIXED32 -> 7;
            case Type.FIXED64 -> 6;
            case Type.BOOL -> 8;
            case Type.STRING -> 9;
            case Type.BYTES -> 10;
            case Type.UINT32 -> 11;
            case Type.UINT64 -> 4;
            case Type.SFIXED32 -> 12;
            case Type.SFIXED64 -> 13;
            case Type.SINT32 -> 14;
            case Type.SINT64 -> 15;
            default -> throw new IllegalStateException("Unknown field type " + primitiveType);
        };
    }

    private static void processArray(ImmutableSerializationContext ctx, String type, String field, JsonParser parser, TagWriter writer) throws IOException {
        JsonToken token;
        while ((token = parser.nextToken()) != null) {
            switch (token) {
                case END_ARRAY: {
                    return;
                }
                case START_ARRAY: {
                    JsonUtils.processArray(ctx, type, field, parser, writer);
                    break;
                }
                case START_OBJECT: {
                    Descriptor d = (Descriptor)ctx.getDescriptorByName(type);
                    FieldDescriptor fd = d.findFieldByName(field);
                    JsonUtils.processObject(ctx, parser, writer, fd.getMessageType(), fd.getNumber(), false);
                    break;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER_INT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NUMBER_FLOAT: {
                    Descriptor d = (Descriptor)ctx.getDescriptorByName(type);
                    FieldDescriptor fd = d.findFieldByName(field);
                    if (!fd.isRepeated()) {
                        if (token == JsonToken.VALUE_NUMBER_INT && Type.BYTES.equals((Object)fd.getType())) {
                            ArrayList<Byte> result = new ArrayList<Byte>();
                            while (token == JsonToken.VALUE_NUMBER_INT) {
                                byte value = parser.getByteValue();
                                result.add(value);
                                token = parser.nextToken();
                            }
                            byte[] binary = new byte[result.size()];
                            for (int i = 0; i < result.size(); ++i) {
                                binary[i] = (Byte)result.get(i);
                            }
                            writer.writeBytes(fd.getNumber(), binary);
                            if (token == JsonToken.END_ARRAY) {
                                return;
                            }
                        }
                        throw new IllegalStateException("Field '" + fd.getName() + "' is not an array");
                    }
                    if (fd.getType() == Type.ENUM) {
                        JsonUtils.writeEnumField(parser, writer, fd, fd.getNumber());
                        break;
                    }
                    JsonUtils.writeField(parser, writer, fd.getType(), fd.getNumber());
                    break;
                }
            }
        }
    }

    public static String toCanonicalJSON(ImmutableSerializationContext ctx, byte[] bytes, boolean prettyPrint) throws IOException {
        StringBuilder jsonOut = new StringBuilder();
        JsonUtils.toCanonicalJSON(ctx, bytes, jsonOut, prettyPrint ? 0 : -1);
        return jsonOut.toString();
    }

    private static void toCanonicalJSON(final ImmutableSerializationContext ctx, byte[] bytes, final StringBuilder jsonOut, final int initNestingLevel) throws IOException {
        if (bytes.length == 0) {
            jsonOut.append("null");
            return;
        }
        final Descriptor wrapperDescriptor = ctx.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
        final boolean prettyPrint = initNestingLevel >= 0;
        final TagHandler messageHandler = new TagHandler(){
            private JsonNestingLevel nestingLevel;
            private boolean missingType = true;

            private void indent() {
                jsonOut.append('\n');
                jsonOut.append("   ".repeat(Math.max(0, initNestingLevel + this.nestingLevel.indent)));
            }

            @Override
            public void onStart(GenericDescriptor descriptor) {
                this.nestingLevel = new JsonNestingLevel(null);
                if (prettyPrint) {
                    this.indent();
                    ++this.nestingLevel.indent;
                }
                jsonOut.append('{');
                this.writeType(descriptor);
            }

            private void writeType(AnnotatedDescriptor descriptor) {
                if (descriptor != null && this.nestingLevel.previous == null && this.nestingLevel.isFirstField) {
                    this.missingType = false;
                    this.nestingLevel.isFirstField = false;
                    if (prettyPrint) {
                        this.indent();
                    }
                    jsonOut.append('\"').append(JsonUtils.JSON_TYPE_FIELD).append('\"').append(':');
                    if (prettyPrint) {
                        jsonOut.append(' ');
                    }
                    String type = descriptor instanceof FieldDescriptor ? ((FieldDescriptor)descriptor).getTypeName() : descriptor.getFullName();
                    jsonOut.append('\"').append(type).append('\"');
                }
            }

            @Override
            public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
                if (fieldDescriptor == null) {
                    return;
                }
                if (this.missingType) {
                    this.writeType(fieldDescriptor);
                }
                this.startSlot(fieldDescriptor);
                switch (fieldDescriptor.getType()) {
                    case STRING: {
                        JsonUtils.escapeJson((String)tagValue, jsonOut, true);
                        break;
                    }
                    case FIXED64: 
                    case UINT64: {
                        jsonOut.append(Long.toUnsignedString((Long)tagValue));
                        break;
                    }
                    case FIXED32: 
                    case UINT32: {
                        jsonOut.append(Integer.toUnsignedString((Integer)tagValue));
                        break;
                    }
                    case FLOAT: {
                        Float f = (Float)tagValue;
                        if (f.isInfinite() || f.isNaN()) {
                            jsonOut.append('\"').append(f).append('\"');
                            break;
                        }
                        jsonOut.append(f);
                        break;
                    }
                    case DOUBLE: {
                        Double d = (Double)tagValue;
                        if (d.isInfinite() || d.isNaN()) {
                            jsonOut.append('\"').append(d).append('\"');
                            break;
                        }
                        jsonOut.append(d);
                        break;
                    }
                    case ENUM: {
                        EnumValueDescriptor enumValue = fieldDescriptor.getEnumType().findValueByNumber((Integer)tagValue);
                        jsonOut.append('\"').append(enumValue.getName()).append('\"');
                        break;
                    }
                    case BYTES: {
                        String base64encoded = Base64.getEncoder().encodeToString((byte[])tagValue);
                        jsonOut.append('\"').append(base64encoded).append('\"');
                        break;
                    }
                    default: {
                        if (tagValue instanceof Date) {
                            jsonOut.append('\"').append(JsonUtils.formatDate((Date)tagValue)).append('\"');
                            break;
                        }
                        if (fieldNumber == 18 && fieldDescriptor.name.equals("wrappedEnum")) {
                            jsonOut.append('\"').append(tagValue).append('\"');
                            break;
                        }
                        jsonOut.append(tagValue);
                    }
                }
            }

            @Override
            public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
                if (fieldDescriptor == null) {
                    return;
                }
                this.startSlot(fieldDescriptor);
                this.nestingLevel = new JsonNestingLevel(this.nestingLevel);
                if (prettyPrint) {
                    this.indent();
                    ++this.nestingLevel.indent;
                }
                if (!fieldDescriptor.isMap()) {
                    jsonOut.append('{');
                }
            }

            @Override
            public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
                if (this.nestingLevel.repeatedFieldDescriptor != null) {
                    this.endArraySlot();
                }
                if (prettyPrint) {
                    --this.nestingLevel.indent;
                    this.indent();
                }
                if (!fieldDescriptor.isMap()) {
                    jsonOut.append('}');
                }
                this.nestingLevel = this.nestingLevel.previous;
            }

            @Override
            public void onEnd() {
                if (this.nestingLevel.repeatedFieldDescriptor != null) {
                    this.endArraySlot();
                }
                if (prettyPrint) {
                    --this.nestingLevel.indent;
                    this.indent();
                }
                jsonOut.append('}');
                this.nestingLevel = null;
                if (prettyPrint) {
                    jsonOut.append('\n');
                }
            }

            private void startSlot(FieldDescriptor fieldDescriptor) {
                boolean map;
                if (this.nestingLevel.repeatedFieldDescriptor != null && !this.nestingLevel.repeatedFieldDescriptor.name.equals(fieldDescriptor.name)) {
                    this.endArraySlot();
                }
                boolean bl = map = this.nestingLevel.previous != null && this.nestingLevel.previous.repeatedFieldDescriptor != null && this.nestingLevel.previous.repeatedFieldDescriptor.isMap();
                if (this.nestingLevel.isFirstField) {
                    this.nestingLevel.isFirstField = false;
                } else {
                    jsonOut.append(map ? (char)':' : ',');
                }
                if (!map) {
                    if (!fieldDescriptor.isRepeated() || this.nestingLevel.repeatedFieldDescriptor == null) {
                        if (prettyPrint) {
                            this.indent();
                        }
                        if (fieldDescriptor.getLabel() == Label.ONE_OF) {
                            jsonOut.append('\"').append(JsonUtils.JSON_VALUE_FIELD).append("\":");
                        } else {
                            jsonOut.append('\"').append(fieldDescriptor.getName()).append("\":");
                        }
                    }
                    if (prettyPrint) {
                        jsonOut.append(' ');
                    }
                }
                if (fieldDescriptor.isRepeated() && this.nestingLevel.repeatedFieldDescriptor == null) {
                    this.nestingLevel.repeatedFieldDescriptor = fieldDescriptor;
                    jsonOut.append(fieldDescriptor.isMap() ? (char)'{' : '[');
                }
            }

            private void endArraySlot() {
                boolean map = this.nestingLevel.repeatedFieldDescriptor.isMap();
                if (prettyPrint && this.nestingLevel.repeatedFieldDescriptor.getType() == Type.MESSAGE) {
                    this.indent();
                }
                this.nestingLevel.repeatedFieldDescriptor = null;
                jsonOut.append(map ? (char)'}' : ']');
            }
        };
        TagHandler wrapperHandler = new TagHandler(){
            private Integer typeId;
            private String typeName;
            private byte[] wrappedMessage;
            private Integer wrappedEnum;
            private String wrappedContainerType;

            private GenericDescriptor getDescriptor() {
                return this.typeId != null ? ctx.getDescriptorByTypeId(this.typeId) : ctx.getDescriptorByName(this.typeName);
            }

            @Override
            public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
                if (fieldDescriptor == null) {
                    return;
                }
                switch (fieldNumber) {
                    case 19: {
                        this.typeId = (Integer)tagValue;
                        break;
                    }
                    case 16: {
                        this.typeName = (String)tagValue;
                        break;
                    }
                    case 17: {
                        this.wrappedMessage = (byte[])tagValue;
                        break;
                    }
                    case 18: {
                        this.wrappedEnum = (Integer)tagValue;
                        break;
                    }
                    case 28: {
                        this.wrappedContainerType = (String)tagValue;
                        GenericDescriptor descriptorByName = ctx.getDescriptorByName(this.wrappedContainerType);
                        messageHandler.onStart(descriptorByName);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 21: 
                    case 22: {
                        if (this.wrappedContainerType != null) {
                            messageHandler.onTag(fieldNumber, new RepeatedFieldDescriptor(fieldDescriptor), tagValue);
                            break;
                        }
                        messageHandler.onStart(null);
                        messageHandler.onTag(fieldNumber, fieldDescriptor, tagValue);
                        messageHandler.onEnd();
                    }
                }
            }

            @Override
            public void onEnd() {
                if (this.wrappedContainerType != null) {
                    messageHandler.onEnd();
                } else if (this.wrappedEnum != null) {
                    EnumDescriptor enumDescriptor = (EnumDescriptor)this.getDescriptor();
                    String enumConstantName = enumDescriptor.findValueByNumber(this.wrappedEnum).getName();
                    FieldDescriptor fd = wrapperDescriptor.findFieldByNumber(18);
                    messageHandler.onStart(enumDescriptor);
                    messageHandler.onTag(18, fd, enumConstantName);
                    messageHandler.onEnd();
                } else if (this.wrappedMessage != null) {
                    try {
                        Descriptor messageDescriptor = (Descriptor)this.getDescriptor();
                        ProtobufParser.INSTANCE.parse(messageHandler, messageDescriptor, this.wrappedMessage);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        ProtobufParser.INSTANCE.parse(wrapperHandler, wrapperDescriptor, bytes);
    }

    private static void writeEnumField(JsonParser parser, TagWriter writer, FieldDescriptor fd, int fieldNumber) throws IOException {
        String value = parser.getText();
        EnumDescriptor enumDescriptor = fd.getEnumType();
        EnumValueDescriptor valueDescriptor = enumDescriptor.findValueByName(value);
        if (valueDescriptor == null) {
            throw new IllegalStateException("Invalid enum value '" + value + "'");
        }
        int choice = valueDescriptor.getNumber();
        writer.writeEnum(fieldNumber, choice);
    }

    private static void writeField(JsonParser parser, TagWriter writer, Type fieldType, int fieldNumber) throws IOException {
        switch (fieldType) {
            case DOUBLE: {
                writer.writeDouble(fieldNumber, Double.parseDouble(parser.getText()));
                break;
            }
            case FLOAT: {
                writer.writeFloat(fieldNumber, Float.parseFloat(parser.getText()));
                break;
            }
            case INT64: {
                writer.writeInt64(fieldNumber, Long.parseLong(parser.getText()));
                break;
            }
            case UINT64: {
                writer.writeUInt64(fieldNumber, Long.parseUnsignedLong(parser.getText()));
                break;
            }
            case FIXED64: {
                writer.writeFixed64(fieldNumber, Long.parseUnsignedLong(parser.getText()));
                break;
            }
            case SFIXED64: {
                writer.writeSFixed64(fieldNumber, Long.parseLong(parser.getText()));
                break;
            }
            case SINT64: {
                writer.writeSInt64(fieldNumber, Long.parseLong(parser.getText()));
                break;
            }
            case INT32: {
                writer.writeInt32(fieldNumber, Integer.parseInt(parser.getText()));
                break;
            }
            case FIXED32: {
                writer.writeFixed32(fieldNumber, Integer.parseUnsignedInt(parser.getText()));
                break;
            }
            case UINT32: {
                writer.writeUInt32(fieldNumber, Integer.parseUnsignedInt(parser.getText()));
                break;
            }
            case SFIXED32: {
                writer.writeSFixed32(fieldNumber, Integer.parseInt(parser.getText()));
                break;
            }
            case SINT32: {
                writer.writeSInt32(fieldNumber, Integer.parseInt(parser.getText()));
                break;
            }
            case BOOL: {
                writer.writeBool(fieldNumber, parser.getBooleanValue());
                break;
            }
            case STRING: {
                writer.writeString(fieldNumber, parser.getText());
                break;
            }
            case BYTES: {
                byte[] binary = parser.getBinaryValue();
                writer.writeBytes(fieldNumber, binary);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldType);
            }
        }
    }

    private static void expectField(String expectedFieldName, String actualFieldName) {
        if (!expectedFieldName.equals(actualFieldName)) {
            throw new IllegalStateException("The document should contain a top level field '" + expectedFieldName + "'");
        }
    }

    private static void escapeJson(String value, StringBuilder out, boolean htmlSafe) {
        out.append('\"');
        int prev = 0;
        int len = value.length();
        for (int cur = 0; cur < len; ++cur) {
            char ch = value.charAt(cur);
            String esc = null;
            if (ch < ' ') {
                esc = switch (ch) {
                    case '\t' -> "\\t";
                    case '\b' -> "\\b";
                    case '\n' -> "\\n";
                    case '\r' -> "\\r";
                    case '\f' -> "\\f";
                    default -> String.format("\\u%04x", ch);
                };
            } else if (ch < '\u0080') {
                if (ch == '\"') {
                    esc = "\\\"";
                } else if (ch == '\\') {
                    esc = "\\\\";
                } else if (htmlSafe) {
                    esc = switch (ch) {
                        case '<' -> "\\u003c";
                        case '>' -> "\\u003e";
                        case '&' -> "\\u0026";
                        case '=' -> "\\u003d";
                        case '\'' -> "\\u0027";
                        default -> esc;
                    };
                }
            } else if (ch == '\u2028') {
                esc = "\\u2028";
            } else {
                if (ch != '\u2029') continue;
                esc = "\\u2029";
            }
            if (esc == null) continue;
            if (prev < cur) {
                out.append(value, prev, cur);
            }
            prev = cur + 1;
            out.append(esc);
        }
        if (prev < len) {
            out.append(value, prev, len);
        }
        out.append('\"');
    }

    private static String formatDate(Date date) {
        return timestampFormat.get().format(date);
    }

    private static final class JsonNestingLevel {
        boolean isFirstField = true;
        FieldDescriptor repeatedFieldDescriptor;
        int indent;
        JsonNestingLevel previous;

        JsonNestingLevel(JsonNestingLevel previous) {
            this.previous = previous;
            this.indent = previous != null ? previous.indent + 1 : 0;
        }
    }
}

